/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Block.Plants;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class VerticalGrowingPlantBlock
extends Block
implements IPlantable {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private final int MAX_GROWTH_HEIGHT;

    public VerticalGrowingPlantBlock(BlockBehaviour.Properties prop, int maxHeight) {
        super(prop);
        this.MAX_GROWTH_HEIGHT = maxHeight;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        boolean state_is_top = this.updateTopProperty(state, level, pos);
        int state_age = (Integer)state.m_61143_((Property)AGE);
        if (state_is_top && level.m_46859_(pos.m_7494_())) {
            int height = 1;
            while (level.m_8055_(pos.m_6625_(height)).m_60713_((Block)this)) {
                ++height;
            }
            if (height < this.MAX_GROWTH_HEIGHT && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                if (state_age == 15) {
                    this.growUp(state, level, pos);
                } else {
                    level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(state_age + 1))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true)), 4);
                }
            }
        }
    }

    private boolean updateTopProperty(BlockState state, ServerLevel level, BlockPos pos) {
        boolean state_is_actually_top;
        boolean state_is_top = (Boolean)state.m_61143_((Property)TOP);
        boolean bl = state_is_actually_top = !level.m_8055_(pos.m_7494_()).m_60713_((Block)this);
        if (state_is_top && !state_is_actually_top) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false)));
            return false;
        }
        if (!state_is_top && state_is_actually_top) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true)));
            return true;
        }
        return state_is_top;
    }

    private void growUp(BlockState state, ServerLevel level, BlockPos pos) {
        level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false)));
        level.m_46597_(pos.m_7494_(), this.m_49966_());
        ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos.m_7494_(), (BlockState)this.m_49966_());
    }

    public BlockState m_7417_(BlockState state1, Direction direction, BlockState state2, LevelAccessor levelAccessor, BlockPos pos1, BlockPos pos2) {
        if (!state1.m_60710_((LevelReader)levelAccessor, pos1)) {
            levelAccessor.m_186460_(pos1, (Block)this, 1);
        }
        return super.m_7417_(state1, direction, state2, levelAccessor, pos1, pos2);
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockState soil = levelReader.m_8055_(pos.m_7495_());
        if (soil.canSustainPlant((BlockGetter)levelReader, pos.m_7495_(), Direction.UP, (IPlantable)this)) {
            return true;
        }
        BlockState belowstate = levelReader.m_8055_(pos.m_7495_());
        return belowstate.m_60713_((Block)this) && (Boolean)belowstate.m_61143_((Property)TOP) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateDefinitionBuilder) {
        stateDefinitionBuilder.m_61104_(new Property[]{AGE});
        stateDefinitionBuilder.m_61104_(new Property[]{TOP});
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.PLAINS;
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        return this.m_49966_();
    }
}

