/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Block.Furnaces;

import com.mojang.serialization.MapCodec;
import fr.factionbedrock.aerialhell.Block.Furnaces.AbstractAerialHellFurnaceBlock;
import fr.factionbedrock.aerialhell.BlockEntity.StellarFurnaceBlockEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class StellarFurnaceBlock
extends AbstractAerialHellFurnaceBlock {
    public static final MapCodec<StellarFurnaceBlock> CODEC = StellarFurnaceBlock.m_306223_(StellarFurnaceBlock::new);

    public StellarFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends AbstractFurnaceBlock> m_304657_() {
        return CODEC;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StellarFurnaceBlockEntity(pos, state);
    }

    protected void m_7137_(Level worldIn, BlockPos pos, Player player) {
        BlockEntity blockentity = worldIn.m_7702_(pos);
        if (blockentity instanceof StellarFurnaceBlockEntity) {
            player.m_5893_((MenuProvider)blockentity);
            player.m_36220_(Stats.f_12966_);
        }
    }

    @Override
    public BlockEntityType<? extends AbstractFurnaceBlockEntity> getTickerBlockEntity() {
        return (BlockEntityType)AerialHellBlockEntities.STELLAR_FURNACE.get();
    }

    @Override
    public SoundEvent getLitSound() {
        return SoundEvents.f_11907_;
    }

    @Override
    public Vector3d getParticlePos(BlockPos pos, Direction direction) {
        Direction.Axis direction$axis = direction.m_122434_();
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        double offset = Math.random() * 0.6 - 0.3;
        double posX = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : offset;
        double posZ = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : offset;
        return new Vector3d(x + posX, y, z + posZ);
    }

    @Override
    public Vector3d getParticleRandomOffset(RandomSource rand) {
        return new Vector3d(0.0, rand.m_188500_() * 6.0 / 16.0, 0.0);
    }

    @Override
    public Vector3d getParticleRandomVelocity(RandomSource rand) {
        return new Vector3d(0.0, 0.0, 0.0);
    }

    @Override
    public ParticleOptions getParticleType() {
        return Math.random() > 0.5 ? ParticleTypes.f_123762_ : ParticleTypes.f_123744_;
    }

    @Override
    public int getParticleCount() {
        return 1;
    }
}

