/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Block.DungeonCores;

import fr.factionbedrock.aerialhell.Block.DungeonCores.CoreProtectedBlock;
import fr.factionbedrock.aerialhell.Block.DungeonCores.CoreProtectedChestBlock;
import fr.factionbedrock.aerialhell.Block.DungeonCores.CoreProtectedRotatedPillarBlock;
import fr.factionbedrock.aerialhell.Block.DungeonCores.CoreProtectedSlabBlock;
import fr.factionbedrock.aerialhell.Block.DungeonCores.CoreProtectedStairsBlock;
import fr.factionbedrock.aerialhell.Block.DungeonCores.CoreProtectedTrappedBlock;
import fr.factionbedrock.aerialhell.Client.Registry.AerialHellParticleTypes;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class DungeonCoreBlock
extends Block {
    int coreProtectRange;

    public DungeonCoreBlock(BlockBehaviour.Properties properties, int coreRangeIn) {
        super(properties);
        this.coreProtectRange = coreRangeIn;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    public boolean onDestroyedByPlayer(BlockState state, Level worldIn, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean flag = super.onDestroyedByPlayer(state, worldIn, pos, player, willHarvest, fluid);
        if (flag) {
            this.setAreaProtected(worldIn, pos, false);
        }
        return flag;
    }

    public void setAreaProtected(Level worldIn, BlockPos originPos, boolean protect) {
        if (this.isMudCore(this)) {
            this.setAreaProtected(worldIn, originPos, AerialHellTags.Blocks.MUD_DUNGEON, protect);
        } else if (this.isLunaticCore(this)) {
            this.setAreaProtected(worldIn, originPos, AerialHellTags.Blocks.LUNATIC_DUNGEON, protect);
        } else if (this.isShadowCatacombsCore(this)) {
            this.setAreaProtected(worldIn, originPos, AerialHellTags.Blocks.SHADOW_CATACOMBS_DUNGEON, protect);
        } else if (this.isGoldenNetherCore(this)) {
            this.setAreaProtected(worldIn, originPos, AerialHellTags.Blocks.GOLDEN_NETHER_DUNGEON, protect);
        } else if (this.isVoluciteCore(this)) {
            this.setAreaProtected(worldIn, originPos, AerialHellTags.Blocks.VOLUCITE_DUNGEON, protect);
        }
    }

    private void setAreaProtected(Level worldIn, BlockPos originPos, TagKey<Block> tag, boolean protect) {
        for (int x = originPos.m_123341_() - (this.coreProtectRange - 1) / 2; x <= originPos.m_123341_() + (this.coreProtectRange - 1) / 2; ++x) {
            for (int y = originPos.m_123342_() - (this.coreProtectRange - 1) / 2; y <= originPos.m_123342_() + (this.coreProtectRange - 1) / 2; ++y) {
                for (int z = originPos.m_123343_() - (this.coreProtectRange - 1) / 2; z <= originPos.m_123343_() + (this.coreProtectRange - 1) / 2; ++z) {
                    BlockPos newPos = new BlockPos(x, y, z);
                    BlockState blockstate = worldIn.m_8055_(newPos);
                    if (!blockstate.m_204336_(tag)) continue;
                    this.setBlockProtected(worldIn, newPos, protect);
                }
            }
        }
    }

    private void setBlockProtected(Level worldIn, BlockPos pos, boolean protect) {
        BlockState old_blockstate = worldIn.m_8055_(pos);
        Block block = old_blockstate.m_60734_();
        if (block instanceof CoreProtectedBlock) {
            worldIn.m_46597_(pos, (BlockState)old_blockstate.m_61124_((Property)CoreProtectedBlock.CORE_PROTECTED, (Comparable)Boolean.valueOf(protect)));
        } else if (block instanceof CoreProtectedRotatedPillarBlock) {
            worldIn.m_46597_(pos, (BlockState)old_blockstate.m_61124_((Property)CoreProtectedRotatedPillarBlock.CORE_PROTECTED, (Comparable)Boolean.valueOf(protect)));
        } else if (block instanceof CoreProtectedSlabBlock) {
            worldIn.m_46597_(pos, (BlockState)old_blockstate.m_61124_((Property)CoreProtectedSlabBlock.CORE_PROTECTED, (Comparable)Boolean.valueOf(protect)));
        } else if (block instanceof CoreProtectedStairsBlock) {
            worldIn.m_46597_(pos, (BlockState)old_blockstate.m_61124_((Property)CoreProtectedStairsBlock.CORE_PROTECTED, (Comparable)Boolean.valueOf(protect)));
        } else if (block instanceof CoreProtectedChestBlock) {
            worldIn.m_46597_(pos, (BlockState)old_blockstate.m_61124_((Property)CoreProtectedChestBlock.CORE_PROTECTED, (Comparable)Boolean.valueOf(protect)));
        } else if (block instanceof CoreProtectedTrappedBlock) {
            worldIn.m_46597_(pos, (BlockState)old_blockstate.m_61124_((Property)CoreProtectedTrappedBlock.CORE_PROTECTED, (Comparable)Boolean.valueOf(protect)));
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        float x = (float)pos.m_123341_() + 0.5f;
        float y = (float)pos.m_123342_() + 0.5f;
        float z = (float)pos.m_123343_() + 0.5f;
        SimpleParticleType particle = ParticleTypes.f_123762_;
        if (this.isMudCore(this)) {
            particle = ParticleTypes.f_123796_;
        } else if (this.isLunaticCore(this)) {
            particle = (SimpleParticleType)AerialHellParticleTypes.COPPER_PINE_LEAVES.get();
        } else if (this.isShadowCatacombsCore(this)) {
            particle = (SimpleParticleType)AerialHellParticleTypes.SHADOW_PARTICLE.get();
        } else if (this.isGoldenNetherCore(this)) {
            particle = (SimpleParticleType)AerialHellParticleTypes.GOD_FLAME.get();
        } else if (this.isVoluciteCore(this)) {
            particle = ParticleTypes.f_123809_;
        }
        world.m_7106_((ParticleOptions)particle, (double)(x + 1.5f * (rand.m_188501_() - 0.5f)), (double)(y + 1.5f * (rand.m_188501_() - 0.5f)), (double)(z + 1.5f * (rand.m_188501_() - 0.5f)), 0.4 * (double)(rand.m_188501_() - 0.5f), 0.4 * (double)(rand.m_188501_() - 0.5f), 0.4 * (double)(rand.m_188501_() - 0.5f));
    }

    private boolean isMudCore(DungeonCoreBlock core) {
        return core == AerialHellBlocksAndItems.MUD_DUNGEON_CORE.get();
    }

    private boolean isLunaticCore(DungeonCoreBlock core) {
        return core == AerialHellBlocksAndItems.LUNATIC_DUNGEON_CORE.get();
    }

    private boolean isShadowCatacombsCore(DungeonCoreBlock core) {
        return core == AerialHellBlocksAndItems.SHADOW_CATACOMBS_DUNGEON_CORE.get();
    }

    private boolean isGoldenNetherCore(DungeonCoreBlock core) {
        return core == AerialHellBlocksAndItems.GOLDEN_NETHER_DUNGEON_CORE.get();
    }

    private boolean isVoluciteCore(DungeonCoreBlock core) {
        return core == AerialHellBlocksAndItems.VOLUCITE_DUNGEON_CORE.get();
    }
}

