/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Block;

import fr.factionbedrock.aerialhell.BlockEntity.ChestMimicBlockEntity;
import fr.factionbedrock.aerialhell.Client.Registry.AerialHellParticleTypes;
import fr.factionbedrock.aerialhell.Entity.AbstractChestMimicEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ChestMimic.AerialTreeChestMimicEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ChestMimic.CopperPineChestMimicEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ChestMimic.GoldenBeechChestMimicEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ChestMimic.SkyCactusFiberChestMimicEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlockEntities;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Entities.AerialHellEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ChestMimicBlock
extends ChestBlock {
    public ChestMimicBlock(BlockBehaviour.Properties builder) {
        super(builder, () -> AerialHellBlockEntities.CHEST_MIMIC.get());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_51478_, (Comparable)Direction.NORTH)).m_61124_((Property)f_51479_, (Comparable)ChestType.SINGLE)).m_61124_((Property)f_51480_, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!ChestBlock.m_51508_((LevelAccessor)worldIn, (BlockPos)pos)) {
            if (worldIn.m_5776_()) {
                this.addSpawnParticle(worldIn, pos);
            } else {
                worldIn.m_5594_(null, pos, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, 0.7f + 0.5f * worldIn.f_46441_.m_188501_());
                this.revealMimic(state, worldIn, pos);
                worldIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_213646_(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack stack, boolean bool) {
        super.m_213646_(state, worldIn, pos, stack, bool);
        this.revealMimic(state, (Level)worldIn, pos);
    }

    private void revealMimic(BlockState state, Level worldIn, BlockPos pos) {
        float angle = ((Direction)state.m_61143_((Property)f_51478_)).m_122435_();
        AbstractChestMimicEntity chestMimic = this.getNewChestMimicEntity(worldIn);
        chestMimic.m_19890_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, angle, 0.0f);
        chestMimic.m_5616_(angle);
        worldIn.m_7967_((Entity)chestMimic);
    }

    public void addSpawnParticle(Level worldIn, BlockPos pos) {
        for (int i = 0; i < 20; ++i) {
            double dx = worldIn.f_46441_.m_188583_() * 0.04;
            double dy = worldIn.f_46441_.m_188583_() * 0.04;
            double dz = worldIn.f_46441_.m_188583_() * 0.04;
            double x = (double)((float)pos.m_123341_() + 0.5f) + dx * 10.0;
            double y = (double)((float)pos.m_123342_() + 0.5f) + dy * 10.0;
            double z = (double)((float)pos.m_123343_() + 0.5f) + dz * 10.0;
            worldIn.m_7106_((ParticleOptions)this.getMimicSpawnParticle(), x, y, z, dx * 10.0, dy * 10.0, dz * 10.0);
        }
    }

    private SimpleParticleType getMimicSpawnParticle() {
        if (this == AerialHellBlocksAndItems.AERIAL_TREE_CHEST_MIMIC.get()) {
            return (SimpleParticleType)AerialHellParticleTypes.OSCILLATOR.get();
        }
        if (this == AerialHellBlocksAndItems.COPPER_PINE_CHEST_MIMIC.get()) {
            return (SimpleParticleType)AerialHellParticleTypes.COPPER_PINE_LEAVES.get();
        }
        if (this == AerialHellBlocksAndItems.GOLDEN_BEECH_CHEST_MIMIC.get()) {
            return (SimpleParticleType)AerialHellParticleTypes.LUNATIC_PARTICLE.get();
        }
        return (SimpleParticleType)AerialHellParticleTypes.LUNATIC_PARTICLE.get();
    }

    private AbstractChestMimicEntity getNewChestMimicEntity(Level worldIn) {
        if (this == AerialHellBlocksAndItems.AERIAL_TREE_CHEST_MIMIC.get()) {
            return new AerialTreeChestMimicEntity((EntityType<? extends AerialTreeChestMimicEntity>)((EntityType)AerialHellEntities.AERIAL_TREE_MIMIC.get()), worldIn);
        }
        if (this == AerialHellBlocksAndItems.COPPER_PINE_CHEST_MIMIC.get()) {
            return new CopperPineChestMimicEntity((EntityType<? extends CopperPineChestMimicEntity>)((EntityType)AerialHellEntities.COPPER_PINE_MIMIC.get()), worldIn);
        }
        if (this == AerialHellBlocksAndItems.GOLDEN_BEECH_CHEST_MIMIC.get()) {
            return new GoldenBeechChestMimicEntity((EntityType<? extends GoldenBeechChestMimicEntity>)((EntityType)AerialHellEntities.GOLDEN_BEECH_MIMIC.get()), worldIn);
        }
        return new SkyCactusFiberChestMimicEntity((EntityType<? extends SkyCactusFiberChestMimicEntity>)((EntityType)AerialHellEntities.SKY_CACTUS_FIBER_MIMIC.get()), worldIn);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChestMimicBlockEntity(pos, state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_51478_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_51478_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)f_51478_)));
    }
}

