/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Block;

import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.AerialHellSoundEvents;
import fr.factionbedrock.aerialhell.Util.EntityHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BonePileBlock
extends SnowLayerBlock {
    private static final int MAX_WAIT_TIMER = 10;
    public static final IntegerProperty WALK_DESTROY_TIMER = IntegerProperty.m_61631_((String)"walk_destroy_timer", (int)0, (int)10);

    public BonePileBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WALK_DESTROY_TIMER, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(1)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WALK_DESTROY_TIMER, f_56581_});
    }

    private int getRandomWalkDestroyTimer(RandomSource rand) {
        return 2 + rand.m_188503_(7);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.m_8055_(pos.m_7495_());
        if (!blockstate.m_60713_(Blocks.f_50375_)) {
            if (!blockstate.m_60713_(Blocks.f_50719_) && !blockstate.m_60713_(Blocks.f_50135_)) {
                return Block.m_49918_((VoxelShape)blockstate.m_60812_((BlockGetter)worldIn, pos.m_7495_()), (Direction)Direction.UP) || blockstate.m_60734_() == this && (Integer)blockstate.m_61143_((Property)f_56581_) == 8;
            }
            return true;
        }
        return false;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
    }

    public boolean m_6724_(BlockState state) {
        return false;
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entityIn) {
        if (this.canEntityWalkDestroy(world, pos, entityIn)) {
            boolean downBlockStateIsBonePile = this.isBonePileBlockState(world, pos.m_7495_());
            boolean topBlockStateIsBonePile = this.isBonePileBlockState(world, pos.m_7494_());
            BlockPos posToUpdate = pos;
            if (topBlockStateIsBonePile) {
                posToUpdate = pos.m_7494_();
                downBlockStateIsBonePile = true;
            }
            int currentLayerNumber = (Integer)world.m_8055_(posToUpdate).m_61143_((Property)f_56581_);
            int newLayerNumber = this.getNewLayerNumber(currentLayerNumber, downBlockStateIsBonePile, world.f_46441_);
            this.updateLayerNumber(world, posToUpdate, newLayerNumber, entityIn);
        }
    }

    private void updateLayerNumber(Level world, BlockPos pos, int newLayerNumber, Entity entityIn) {
        if (newLayerNumber > 0) {
            if (!world.m_5776_()) {
                world.m_46597_(pos, (BlockState)((BlockState)world.m_8055_(pos).m_61124_((Property)f_56581_, (Comparable)Integer.valueOf(newLayerNumber))).m_61124_((Property)WALK_DESTROY_TIMER, (Comparable)Integer.valueOf(this.getRandomWalkDestroyTimer(world.f_46441_))));
            }
        } else if (!world.m_5776_()) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        if (!world.m_5776_()) {
            if (newLayerNumber < 2 || world.f_46441_.m_188503_(4) == 0) {
                entityIn.m_19983_(new ItemStack((ItemLike)AerialHellBlocksAndItems.MUD_BONE.get()));
            }
        } else {
            entityIn.m_5496_((SoundEvent)AerialHellSoundEvents.BLOCK_BONE_PILE_STEP_BREAK.get(), 0.5f, 0.9f + world.f_46441_.m_188501_() * 0.3f);
        }
    }

    private boolean canEntityWalkDestroy(Level world, BlockPos pos, Entity walkingEntity) {
        LivingEntity walkingLEntity;
        BlockState blockState = world.m_8055_(pos);
        if ((Integer)blockState.m_61143_((Property)WALK_DESTROY_TIMER) > 0) {
            world.m_46597_(pos, (BlockState)((BlockState)world.m_8055_(pos).m_61124_((Property)f_56581_, (Comparable)((Integer)blockState.m_61143_((Property)f_56581_)))).m_61124_((Property)WALK_DESTROY_TIMER, (Comparable)Integer.valueOf((Integer)blockState.m_61143_((Property)WALK_DESTROY_TIMER) - 1)));
            return false;
        }
        if (walkingEntity instanceof LivingEntity && !EntityHelper.isShadowEntity((Entity)(walkingLEntity = (LivingEntity)walkingEntity)) && !EntityHelper.isFeatheryEntity((Entity)walkingLEntity)) {
            int topLayerNumber;
            boolean topBlockStateIsBonePile = this.isBonePileBlockState(world, pos.m_7494_());
            boolean posBlockStateIsBonePile = this.isBonePileBlockState(world, pos);
            boolean downBlockStateIsBonePile = this.isBonePileBlockState(world, pos.m_7495_());
            int posLayerNumber = posBlockStateIsBonePile ? (Integer)world.m_8055_(pos).m_61143_((Property)f_56581_) : 0;
            int n = topLayerNumber = topBlockStateIsBonePile ? (Integer)world.m_8055_(pos.m_7494_()).m_61143_((Property)f_56581_) : 0;
            if (!(topBlockStateIsBonePile && topLayerNumber > 2 || posLayerNumber <= 1 && !downBlockStateIsBonePile)) {
                return true;
            }
        }
        return false;
    }

    private boolean isBonePileBlockState(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60713_((Block)this);
    }

    private int getNewLayerNumber(int currentLayerNumber, boolean downBlockStateIsBonePile, RandomSource rand) {
        if (downBlockStateIsBonePile) {
            if (currentLayerNumber > 3) {
                int newLayerNumber = currentLayerNumber - 2 + rand.m_188503_(3);
                if (newLayerNumber < 3 && newLayerNumber != 0) {
                    newLayerNumber = 3;
                }
                return newLayerNumber;
            }
            return 0;
        }
        if (currentLayerNumber > 3) {
            return currentLayerNumber - (1 + rand.m_188503_(2));
        }
        return 1;
    }
}

