/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Block;

import fr.factionbedrock.aerialhell.Client.Registry.AerialHellParticleTypes;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.AerialHellSoundEvents;
import fr.factionbedrock.aerialhell.Util.BlockHelper;
import fr.factionbedrock.aerialhell.Util.EntityHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aerialhell")
public class AerialHellPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public AerialHellPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public boolean trySpawnPortal(LevelAccessor level, BlockPos pos) {
        Size portalSize = this.isPortal(level, pos);
        if (portalSize != null && !AerialHellPortalBlock.onTrySpawnPortal(level, pos, portalSize)) {
            portalSize.placePortalBlocks();
            return true;
        }
        return false;
    }

    public static boolean onTrySpawnPortal(LevelAccessor world, BlockPos pos, Size size) {
        return MinecraftForge.EVENT_BUS.post((Event)new PortalSpawnEvent(world, pos, world.m_8055_(pos), size));
    }

    @Nullable
    public Size isPortal(LevelAccessor level, BlockPos pos) {
        Size sizeX = new Size(level, pos, Direction.Axis.X);
        if (sizeX.isValid() && sizeX.portalBlockCount == 0) {
            return sizeX;
        }
        Size sizeZ = new Size(level, pos, Direction.Axis.Z);
        return sizeZ.isValid() && sizeZ.portalBlockCount == 0 ? sizeZ : null;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.m_122434_();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.m_61143_(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.m_122479_();
        return !flag && facingState.m_60734_() != this && !new Size(level, currentPos, direction$axis1).validatePortal() ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        LivingEntity livingEntity;
        if (entity.m_20159_()) return;
        if (entity.m_20160_()) return;
        if (!entity.m_6072_()) return;
        if (entity instanceof LivingEntity && EntityHelper.isLivingEntityOnPortalCooldown(livingEntity = (LivingEntity)entity) && !EntityHelper.isCreativePlayer(entity)) {
            EntityHelper.setAfterTeleportationEffect((LivingEntity)entity);
            return;
        }
        if (entity.m_20092_()) {
            entity.m_20091_();
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity2 = (LivingEntity)entity;
            if (!EntityHelper.isCreativePlayer(entity)) {
                if (EntityHelper.isLivingEntityUnderAerialHellPortalEffect(livingEntity2)) {
                    if (!EntityHelper.isLivingEntityReadyToTeleport(livingEntity2)) return;
                    EntityHelper.tryTeleportEntityWithAerialHellPortal(entity, pos);
                    EntityHelper.setAfterTeleportationEffect(livingEntity2);
                    return;
                }
                if (!EntityHelper.shouldLivingEntityHavePortalEffect(livingEntity2)) return;
                EntityHelper.setAerialHellPortalEffect(livingEntity2);
                return;
            }
        }
        EntityHelper.tryTeleportEntityWithAerialHellPortal(entity, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(100) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)AerialHellSoundEvents.BLOCK_AERIAL_HELL_PORTAL_AMBIENT.get(), SoundSource.BLOCKS, 0.6f, 0.9f + random.m_188501_() * 0.2f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)pos.m_123342_() + random.m_188500_();
            double z = (double)pos.m_123343_() + random.m_188500_();
            double xSpeed = ((double)random.m_188501_() - 0.5) * 0.5;
            double ySpeed = ((double)random.m_188501_() - 0.5) * 0.5;
            double zSpeed = ((double)random.m_188501_() - 0.5) * 0.5;
            int j = random.m_188503_(2) * 2 - 1;
            if (!level.m_8055_(pos.m_122024_()).m_60713_((Block)this) && !level.m_8055_(pos.m_122029_()).m_60713_((Block)this)) {
                x = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                xSpeed = random.m_188501_() * 2.0f * (float)j;
            } else {
                z = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                zSpeed = random.m_188501_() * 2.0f * (float)j;
            }
            level.m_7106_((ParticleOptions)AerialHellParticleTypes.AERIAL_HELL_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public static class Size {
        private final LevelAccessor level;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(LevelAccessor level, BlockPos pos, Direction.Axis axis) {
            this.level = level;
            this.axis = axis;
            if (axis == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.m_123342_() > blockpos.m_123342_() - 21 && pos.m_123342_() > 0 && this.canConnect(level.m_8055_(pos.m_7495_()))) {
                pos = pos.m_7495_();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.m_5484_(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos framePos;
            BlockState state;
            int distance;
            for (distance = 0; distance < 22; ++distance) {
                BlockPos blockpos = pos.m_5484_(directionIn, distance);
                state = this.level.m_8055_(blockpos.m_7495_());
                if (!this.canConnect(this.level.m_8055_(blockpos)) || !BlockHelper.isAerialHellPortalFrameBlock(state)) break;
            }
            return BlockHelper.isAerialHellPortalFrameBlock(state = this.level.m_8055_(framePos = pos.m_5484_(directionIn, distance))) ? distance : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockState state;
                    BlockPos blockpos = this.bottomLeft.m_5484_(this.rightDir, i).m_6630_(this.height);
                    BlockState blockstate = this.level.m_8055_(blockpos);
                    if (!this.canConnect(blockstate)) break block0;
                    Block block = blockstate.m_60734_();
                    if (block == AerialHellBlocksAndItems.AERIAL_HELL_PORTAL.get()) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !BlockHelper.isAerialHellPortalFrameBlock(state = this.level.m_8055_(blockpos.m_121945_(this.leftDir))) : i == this.width - 1 && !BlockHelper.isAerialHellPortalFrameBlock(state = this.level.m_8055_(blockpos.m_121945_(this.rightDir)))) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockState state = this.level.m_8055_(this.bottomLeft.m_5484_(this.rightDir, j).m_6630_(this.height));
                if (BlockHelper.isAerialHellPortalFrameBlock(state)) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean canConnect(BlockState pos) {
            Block block = pos.m_60734_();
            return pos.m_60795_() || block == AerialHellBlocksAndItems.AERIAL_HELL_PORTAL.get();
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.m_5484_(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.level.m_7731_(blockpos.m_6630_(j), (BlockState)((AerialHellPortalBlock)((Object)AerialHellBlocksAndItems.AERIAL_HELL_PORTAL.get())).m_49966_().m_61124_(AXIS, (Comparable)this.axis), 18);
                }
            }
        }

        private boolean isPortalCountValidForSize() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean validatePortal() {
            return this.isValid() && this.isPortalCountValidForSize();
        }
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final Size size;

        public PortalSpawnEvent(LevelAccessor world, BlockPos pos, BlockState state, Size size) {
            super(world, pos, state);
            this.size = size;
        }

        public Size getPortalSize() {
            return this.size;
        }
    }
}

