/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import terrablender.core.TerraBlender;

public class EndBiomeRegistry {
    private static final List<WeightedEntry.Wrapper<ResourceKey<Biome>>> highlandsBiomes = new ArrayList<WeightedEntry.Wrapper<ResourceKey<Biome>>>();
    private static final List<WeightedEntry.Wrapper<ResourceKey<Biome>>> midlandsBiomes = new ArrayList<WeightedEntry.Wrapper<ResourceKey<Biome>>>();
    private static final List<WeightedEntry.Wrapper<ResourceKey<Biome>>> edgeBiomes = new ArrayList<WeightedEntry.Wrapper<ResourceKey<Biome>>>();
    private static final List<WeightedEntry.Wrapper<ResourceKey<Biome>>> islandBiomes = new ArrayList<WeightedEntry.Wrapper<ResourceKey<Biome>>>();

    public static void registerHighlandsBiome(ResourceKey<Biome> biome, int weight) {
        highlandsBiomes.add((WeightedEntry.Wrapper<ResourceKey<Biome>>)WeightedEntry.m_146290_(biome, (int)weight));
    }

    public static void registerMidlandsBiome(ResourceKey<Biome> biome, int weight) {
        midlandsBiomes.add((WeightedEntry.Wrapper<ResourceKey<Biome>>)WeightedEntry.m_146290_(biome, (int)weight));
    }

    public static void registerEdgeBiome(ResourceKey<Biome> biome, int weight) {
        edgeBiomes.add((WeightedEntry.Wrapper<ResourceKey<Biome>>)WeightedEntry.m_146290_(biome, (int)weight));
    }

    public static void registerIslandBiome(ResourceKey<Biome> biome, int weight) {
        islandBiomes.add((WeightedEntry.Wrapper<ResourceKey<Biome>>)WeightedEntry.m_146290_(biome, (int)weight));
    }

    public static List<WeightedEntry.Wrapper<ResourceKey<Biome>>> getHighlandsBiomes() {
        return ImmutableList.copyOf(highlandsBiomes);
    }

    public static List<WeightedEntry.Wrapper<ResourceKey<Biome>>> getMidlandsBiomes() {
        return ImmutableList.copyOf(midlandsBiomes);
    }

    public static List<WeightedEntry.Wrapper<ResourceKey<Biome>>> getEdgeBiomes() {
        return ImmutableList.copyOf(edgeBiomes);
    }

    public static List<WeightedEntry.Wrapper<ResourceKey<Biome>>> getIslandBiomes() {
        return ImmutableList.copyOf(islandBiomes);
    }

    static {
        EndBiomeRegistry.registerHighlandsBiome((ResourceKey<Biome>)Biomes.f_48164_, TerraBlender.CONFIG.vanillaEndHighlandsWeight);
        EndBiomeRegistry.registerMidlandsBiome((ResourceKey<Biome>)Biomes.f_48163_, TerraBlender.CONFIG.vanillaEndMidlandsWeight);
        EndBiomeRegistry.registerEdgeBiome((ResourceKey<Biome>)Biomes.f_48165_, TerraBlender.CONFIG.vanillaEndBarrensWeight);
        EndBiomeRegistry.registerIslandBiome((ResourceKey<Biome>)Biomes.f_48162_, TerraBlender.CONFIG.vanillaSmallEndIslandsWeight);
    }
}

