/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import sereneseasons.api.SSGameRules;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonChangedEvent;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.ServerConfig;
import sereneseasons.handler.PacketHandler;
import sereneseasons.handler.season.SeasonHandlerClient;
import sereneseasons.init.ModTags;
import sereneseasons.network.message.MessageSyncSeasonCycle;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SeasonHandler
implements SeasonHelper.ISeasonDataProvider {
    public static final HashMap<Level, Long> lastDayTimes = new HashMap();
    public static final HashMap<Level, Integer> updateTicks = new HashMap();
    public static final HashMap<ResourceKey<Level>, Integer> prevServerSeasonCycleTicks = new HashMap();

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        MinecraftServer server;
        Level level = event.level;
        if (event.phase != TickEvent.Phase.START || level.m_5776_() || !ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)level.m_46472_())) {
            return;
        }
        long dayTime = level.m_46468_();
        long lastDayTime = lastDayTimes.getOrDefault(level, dayTime);
        lastDayTimes.put(level, dayTime);
        if (!level.m_46469_().m_46207_(SSGameRules.RULE_DOSEASONCYCLE)) {
            return;
        }
        if (!((Boolean)ServerConfig.progressSeasonWhileOffline.get()).booleanValue() && (server = level.m_7654_()) != null && server.m_6846_().m_11309_() == 0) {
            return;
        }
        long difference = dayTime - lastDayTime;
        if (difference == 0L) {
            return;
        }
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        savedData.seasonCycleTicks = Mth.m_14100_((int)(savedData.seasonCycleTicks + (int)difference), (int)SeasonTime.ZERO.getCycleDuration());
        int ticks = updateTicks.getOrDefault(level, 0);
        if (ticks >= 20) {
            SeasonHandler.sendSeasonUpdate(level);
            ticks %= 20;
        }
        updateTicks.put(level, ticks + 1);
        savedData.m_77762_();
    }

    @SubscribeEvent
    public static void onJoinLevel(EntityJoinLevelEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Level level = player.m_9236_();
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        PacketHandler.HANDLER.send((Object)new MessageSyncSeasonCycle((ResourceKey<Level>)level.m_46472_(), savedData.seasonCycleTicks), PacketDistributor.PLAYER.with((Object)player));
    }

    public static void sendSeasonUpdate(Level level) {
        if (level.m_5776_()) {
            return;
        }
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        SeasonTime newTime = new SeasonTime(savedData.seasonCycleTicks);
        SeasonTime prevTime = new SeasonTime(prevServerSeasonCycleTicks.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), key -> newTime.getSeasonCycleTicks()));
        Season.SubSeason prevSeason = prevTime.getSubSeason();
        Season.TropicalSeason prevTropicalSeason = prevTime.getTropicalSeason();
        Season.SubSeason newSeason = newTime.getSubSeason();
        Season.TropicalSeason newTropicalSeason = newTime.getTropicalSeason();
        prevServerSeasonCycleTicks.put((ResourceKey<Level>)level.m_46472_(), newTime.getSeasonCycleTicks());
        if (!prevSeason.equals(newSeason)) {
            MinecraftForge.EVENT_BUS.post((Event)new SeasonChangedEvent.Standard(level, prevSeason, newSeason));
        }
        if (!prevTropicalSeason.equals(newTropicalSeason)) {
            MinecraftForge.EVENT_BUS.post((Event)new SeasonChangedEvent.Tropical(level, prevTropicalSeason, newTropicalSeason));
        }
        PacketHandler.HANDLER.send((Object)new MessageSyncSeasonCycle((ResourceKey<Level>)level.m_46472_(), savedData.seasonCycleTicks), PacketDistributor.ALL.noArg());
    }

    public static SeasonSavedData getSeasonSavedData(Level w) {
        if (w.m_5776_() || !(w instanceof ServerLevel)) {
            return null;
        }
        ServerLevel world = (ServerLevel)w;
        DimensionDataStorage saveDataManager = world.m_7726_().m_8483_();
        Supplier<SeasonSavedData> defaultSaveDataSupplier = () -> {
            SeasonSavedData savedData = new SeasonSavedData();
            int startingSeason = (Integer)ServerConfig.startingSubSeason.get();
            if (startingSeason == 0) {
                savedData.seasonCycleTicks = world.f_46441_.m_188503_(12) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            if (startingSeason > 0) {
                savedData.seasonCycleTicks = (startingSeason - 1) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            savedData.m_77762_();
            return savedData;
        };
        return (SeasonSavedData)saveDataManager.m_164861_(new SavedData.Factory(defaultSaveDataSupplier, SeasonSavedData::load, DataFixTypes.LEVEL), "seasons");
    }

    @Override
    public ISeasonState getServerSeasonState(Level world) {
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
        return new SeasonTime(savedData.seasonCycleTicks);
    }

    @Override
    public ISeasonState getClientSeasonState(Level level) {
        int time = level != null ? SeasonHandlerClient.clientSeasonCycleTicks.getOrDefault(level.m_46472_(), 0) : 0;
        return new SeasonTime(time);
    }

    @Override
    public boolean usesTropicalSeasons(Holder<Biome> biome) {
        return biome.m_203656_(ModTags.Biomes.TROPICAL_BIOMES);
    }
}

