/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sereneseasons.api.SSBlockEntities;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.block.entity.SeasonSensorBlockEntity;
import sereneseasons.config.ServerConfig;
import sereneseasons.season.SeasonTime;

public class SeasonSensorBlock
extends BaseEntityBlock {
    public static final MapCodec<SeasonSensorBlock> CODEC = SeasonSensorBlock.m_306223_(SeasonSensorBlock::new);
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final IntegerProperty SEASON = IntegerProperty.m_61631_((String)"season", (int)0, (int)3);

    public SeasonSensorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)SEASON, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter reader, BlockPos pos, Direction direction) {
        return (Integer)state.m_61143_((Property)POWER);
    }

    public void updatePower(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (ServerConfig.isDimensionWhitelisted((ResourceKey<Level>)world.m_46472_())) {
            BlockState currentState = world.m_8055_(pos);
            int power = 0;
            int startTicks = (Integer)currentState.m_61143_((Property)SEASON) * SeasonTime.ZERO.getSeasonDuration();
            int endTicks = ((Integer)currentState.m_61143_((Property)SEASON) + 1) * SeasonTime.ZERO.getSeasonDuration();
            int currentTicks = SeasonHelper.getSeasonState(world).getSeasonCycleTicks();
            if (currentTicks >= startTicks && currentTicks <= endTicks) {
                float delta = (float)(currentTicks - startTicks) / (float)SeasonTime.ZERO.getSeasonDuration();
                power = (int)Math.min(delta * 15.0f + 1.0f, 15.0f);
            }
            if ((Integer)currentState.m_61143_((Property)POWER) != power) {
                world.m_7731_(pos, (BlockState)currentState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(power)), 3);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (player.m_36326_()) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockState blockstate = (BlockState)state.m_61122_((Property)SEASON);
            world.m_7731_(pos, blockstate, 4);
            this.updatePower(world, pos);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, rayTraceResult);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SeasonSensorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.f_46443_ && level.m_6042_().f_223549_() ? SeasonSensorBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SSBlockEntities.SEASON_SENSOR.get()), SeasonSensorBlock::tickEntity) : null;
    }

    private static void tickEntity(Level level, BlockPos pos, BlockState state, SeasonSensorBlockEntity entity) {
        Block block;
        if (level != null && !level.f_46443_ && (long)SeasonHelper.getSeasonState(level).getSeasonCycleTicks() % 20L == 0L && (block = state.m_60734_()) instanceof SeasonSensorBlock) {
            ((SeasonSensorBlock)block).updatePower(level, pos);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWER, SEASON});
    }
}

