/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.bumblezone.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.bumblezone.modinit.BzEntities;
import com.telepathicgrunt.bumblezone.utils.BzPlacingUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3233;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_3537;
import net.minecraft.class_3543;
import net.minecraft.class_3730;
import net.minecraft.class_3756;
import net.minecraft.class_3757;
import net.minecraft.class_3780;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_4076;
import net.minecraft.class_4538;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5311;
import net.minecraft.class_5425;
import net.minecraft.class_5483;

public class BzChunkGenerator
extends class_2794 {
    public static final Codec<BzChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(surfaceChunkGenerator -> surfaceChunkGenerator.field_24747), (App)class_5311.field_24821.fieldOf("structures").forGetter(class_2794::method_12109)).apply((Applicative)instance, instance.stable(BzChunkGenerator::new)));
    private static final float[] field_16649 = (float[])class_156.method_654((Object)new float[13824], array -> {
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 24; ++j) {
                for (int k = 0; k < 24; ++k) {
                    array[i * 24 * 24 + j * 24 + k] = (float)BzChunkGenerator.method_16571(j - 12, k - 12, i - 12);
                }
            }
        }
    });
    private static final int LERP_RANGE = 3;
    private static final float[] HEIGHT_LERP = (float[])class_156.method_654((Object)new float[49], fs -> {
        for (int i = -3; i <= 3; ++i) {
            for (int j = -3; j <= 3; ++j) {
                float f;
                fs[i + 3 + (j + 3) * 7] = f = 1.0f / class_3532.method_15355((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private static final class_5483.class_1964 INITIAL_HONEY_SLIME_ENTRY = new class_5483.class_1964(BzEntities.HONEY_SLIME, 1, 1, 3);
    private static final class_5483.class_1964 INITIAL_BEE_ENTRY = new class_5483.class_1964(class_1299.field_20346, 1, 1, 4);
    private static final class_2680 CAVE_AIR = class_2246.field_10543.method_9564();
    protected final class_2680 defaultBlock;
    protected final class_2680 defaultFluid;
    private final int verticalNoiseResolution;
    private final int horizontalNoiseResolution;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    protected final class_2919 random = new class_2919(0L);
    private final class_3537 lowerInterpolatedNoise;
    private final class_3537 upperInterpolatedNoise;
    private final class_3537 interpolationNoise;
    private final class_3757 surfaceDepthNoise;
    private final class_3537 field_24776;
    private final class_5311 structureConfig;
    private final int height;

    public static void registerChunkgenerator() {
        class_2378.method_10230((class_2378)class_2378.field_25097, (class_2960)new class_2960("the_bumblezone", "chunk_generator"), CODEC);
    }

    public BzChunkGenerator(class_1966 biomeSource, class_5311 structureConfig) {
        this(biomeSource, biomeSource, structureConfig);
    }

    private BzChunkGenerator(class_1966 biomeSource, class_1966 biomeSource2, class_5311 structureConfig) {
        super(biomeSource, biomeSource2, structureConfig, 0L);
        this.structureConfig = structureConfig;
        this.height = 256;
        this.verticalNoiseResolution = 8;
        this.horizontalNoiseResolution = 4;
        this.defaultBlock = class_2246.field_21212.method_9564();
        this.defaultFluid = BzBlocks.SUGAR_WATER_BLOCK.method_9564();
        this.noiseSizeX = 16 / this.horizontalNoiseResolution;
        this.noiseSizeY = this.height / this.verticalNoiseResolution;
        this.noiseSizeZ = 16 / this.horizontalNoiseResolution;
        this.lowerInterpolatedNoise = new class_3537(this.random, IntStream.rangeClosed(-15, 0));
        this.upperInterpolatedNoise = new class_3537(this.random, IntStream.rangeClosed(-15, 0));
        this.interpolationNoise = new class_3537(this.random, IntStream.rangeClosed(-7, 0));
        this.surfaceDepthNoise = new class_3543(this.random, IntStream.rangeClosed(-3, 0));
        this.random.method_12660(2620);
        this.field_24776 = new class_3537(this.random, IntStream.rangeClosed(-15, 0));
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    @Environment(value=EnvType.CLIENT)
    public class_2794 method_27997(long seed) {
        return new BzChunkGenerator(this.field_24747.method_27985(seed), this.structureConfig);
    }

    private double sampleNoise(int x, int y, int z, double horizontalScaleX, double verticalScale, double horizontalScaleZ, double horizontalStretch, double verticalStretch) {
        double d = 0.0;
        double e = 0.0;
        double f = 0.0;
        double g = 1.0;
        for (int i = 0; i < 16; ++i) {
            class_3756 perlinNoiseSampler3;
            class_3756 perlinNoiseSampler2;
            double h = class_3537.method_16452((double)((double)x * horizontalScaleX * g));
            double j = class_3537.method_16452((double)((double)y * verticalScale * g));
            double k = class_3537.method_16452((double)((double)z * horizontalScaleZ * g));
            double l = verticalScale * g;
            class_3756 perlinNoiseSampler = this.lowerInterpolatedNoise.method_16668(i);
            if (perlinNoiseSampler != null) {
                d += perlinNoiseSampler.method_16447(h, j, k, l, (double)y * l) / g;
            }
            if ((perlinNoiseSampler2 = this.upperInterpolatedNoise.method_16668(i)) != null) {
                e += perlinNoiseSampler2.method_16447(h, j, k, l, (double)y * l) / g;
            }
            if (i < 8 && (perlinNoiseSampler3 = this.interpolationNoise.method_16668(i)) != null) {
                f += perlinNoiseSampler3.method_16447(class_3537.method_16452((double)((double)x * horizontalStretch * g)), class_3537.method_16452((double)((double)y * verticalStretch * g)), class_3537.method_16452((double)((double)z * horizontalStretch * g)), verticalStretch * g, (double)y * verticalStretch * g) / g;
            }
            g /= 2.0;
        }
        return class_3532.method_15390((double)(d / 512.0), (double)(e / 512.0), (double)((f / 10.0 + 1.0) / 2.0));
    }

    private double[] sampleNoiseColumn(int x, int z) {
        double[] ds = new double[this.noiseSizeY + 1];
        this.sampleNoiseColumn(ds, x, z);
        return ds;
    }

    private void sampleNoiseColumn(double[] buffer, int x, int z) {
        float g = 0.0f;
        float h = 0.0f;
        float i = 0.0f;
        int k = this.method_16398();
        float l = this.field_24747.method_16359(x, k, z).method_8695();
        for (int m = -3; m <= 3; ++m) {
            for (int n = -3; n <= 3; ++n) {
                class_1959 biome = this.field_24747.method_16359(x + m, k, z + n);
                float o = biome.method_8695();
                float p = biome.method_8686();
                float u = o > l ? 0.5f : 1.0f;
                float v = u * HEIGHT_LERP[m + 3 + (n + 3) * 7] / 3.0f;
                g += p * v;
                h += o * v;
                i += v;
            }
        }
        float w = h / i;
        float yy = g / i;
        double topSlideTarget = w * 0.5f - 0.125f;
        double topSlideSize = yy * 0.9f + 0.1f;
        double ac = topSlideTarget * 0.265625;
        double ad = 96.0 / topSlideSize;
        double xScale = 2600.0;
        double zScale = 250.0;
        double yScale = 16.0;
        double xzStretch = 8.0;
        double yStretch = 2.0;
        topSlideTarget = -10.0;
        topSlideSize = 3.0;
        double topSlideOffset = 0.0;
        double randomDensity = this.method_28553(x, z);
        double densityFactor = 1.0;
        double densityOffset = -0.46875;
        for (int y = 0; y <= this.noiseSizeY; ++y) {
            double as = this.sampleNoise(x, y * 2, z, xScale, yScale, zScale, xzStretch, yStretch);
            double at = 1.0 - (double)y * 2.0 / (double)this.noiseSizeY + randomDensity;
            double au = at * densityFactor + densityOffset;
            double av = (au + ac) * ad;
            as = av > 0.0 ? (as += av * 4.0) : (as += av);
            double ax = ((double)(this.noiseSizeY - y) - topSlideOffset) / topSlideSize;
            buffer[y] = as = class_3532.method_15390((double)topSlideTarget, (double)as, (double)ax);
        }
    }

    private double method_28553(int i, int j) {
        double d = this.field_24776.method_16453((double)(i * 200), 10.0, (double)(j * 200), 1.0, 0.0, true);
        double f = d < 0.0 ? -d * 0.3 : d;
        double g = f * 24.575625 - 2.0;
        return g < 0.0 ? g * 0.009486607142857142 : Math.min(g, 1.0) * 0.006640625;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmapType) {
        return this.sampleHeightmap(x, z, null, heightmapType.method_16402());
    }

    public class_1922 method_26261(int x, int z) {
        class_2680[] blockStates = new class_2680[this.noiseSizeY * this.verticalNoiseResolution];
        this.sampleHeightmap(x, z, blockStates, null);
        return new class_4966(blockStates);
    }

    private int sampleHeightmap(int x, int z, class_2680[] states, Predicate<class_2680> predicate) {
        int i = Math.floorDiv(x, this.horizontalNoiseResolution);
        int j = Math.floorDiv(z, this.horizontalNoiseResolution);
        int k = Math.floorMod(x, this.horizontalNoiseResolution);
        int l = Math.floorMod(z, this.horizontalNoiseResolution);
        double d = (double)k / (double)this.horizontalNoiseResolution;
        double e = (double)l / (double)this.horizontalNoiseResolution;
        double[][] ds = new double[][]{this.sampleNoiseColumn(i, j), this.sampleNoiseColumn(i, j + 1), this.sampleNoiseColumn(i + 1, j), this.sampleNoiseColumn(i + 1, j + 1)};
        for (int m = this.noiseSizeY - 1; m >= 0; --m) {
            double f = ds[0][m];
            double g = ds[1][m];
            double h = ds[2][m];
            double n = ds[3][m];
            double o = ds[0][m + 1];
            double p = ds[1][m + 1];
            double q = ds[2][m + 1];
            double r = ds[3][m + 1];
            for (int s = this.verticalNoiseResolution - 1; s >= 0; --s) {
                double t = (double)s / (double)this.verticalNoiseResolution;
                double u = class_3532.method_16438((double)t, (double)d, (double)e, (double)f, (double)o, (double)h, (double)q, (double)g, (double)p, (double)n, (double)r);
                int v = m * this.verticalNoiseResolution + s;
                class_2680 blockState = this.getBlockState(u, v);
                if (states != null) {
                    states[v] = blockState;
                }
                if (predicate == null || !predicate.test(blockState)) continue;
                return v + 1;
            }
        }
        return 0;
    }

    protected class_2680 getBlockState(double density, int y) {
        class_2680 blockState3 = density > 0.0 ? this.defaultBlock : (y < this.method_16398() ? this.defaultFluid : CAVE_AIR);
        return blockState3;
    }

    public void method_12110(class_3233 region, class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        int i = chunkPos.field_9181;
        int j = chunkPos.field_9180;
        class_2919 chunkRandom = new class_2919();
        chunkRandom.method_12659(i, j);
        class_1923 chunkPos2 = chunk.method_12004();
        int k = chunkPos2.method_8326();
        int l = chunkPos2.method_8328();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int m = 0; m < 16; ++m) {
            for (int n = 0; n < 16; ++n) {
                int o = k + m;
                int p = l + n;
                int q = chunk.method_12005(class_2902.class_2903.field_13194, m, n) + 1;
                double e = this.surfaceDepthNoise.method_16454((double)o * 0.0625, (double)p * 0.0625, 0.0625, (double)m * 0.0625) * 15.0;
                region.method_23753((class_2338)mutable.method_10103(k + m, q, l + n)).method_8703((Random)chunkRandom, chunk, o, p, q, e, this.defaultBlock, this.defaultFluid, this.method_16398(), region.method_8412());
            }
        }
        this.makeCeilingAndFloor(chunk, (Random)chunkRandom);
    }

    public void method_12088(class_1936 world, class_5138 accessor, class_2791 chunk) {
        ObjectArrayList objectList = new ObjectArrayList(10);
        ObjectArrayList objectList2 = new ObjectArrayList(32);
        class_1923 chunkPos = chunk.method_12004();
        int i = chunkPos.field_9181;
        int j = chunkPos.field_9180;
        int k = i << 4;
        int l = j << 4;
        for (class_3195 feature : class_3195.field_24861) {
            accessor.method_26974(class_4076.method_18681((class_1923)chunkPos, (int)0), feature).forEach(arg_0 -> BzChunkGenerator.lambda$populateNoise$4(chunkPos, (ObjectList)objectList, k, l, (ObjectList)objectList2, arg_0));
        }
        double[][][] ds = new double[2][this.noiseSizeZ + 1][this.noiseSizeY + 1];
        for (int m = 0; m < this.noiseSizeZ + 1; ++m) {
            ds[0][m] = new double[this.noiseSizeY + 1];
            this.sampleNoiseColumn(ds[0][m], i * this.noiseSizeX, j * this.noiseSizeZ + m);
            ds[1][m] = new double[this.noiseSizeY + 1];
        }
        class_2839 protoChunk = (class_2839)chunk;
        class_2902 heightmap = protoChunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 heightmap2 = protoChunk.method_12032(class_2902.class_2903.field_13194);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        ObjectListIterator objectListIterator = objectList.iterator();
        ObjectListIterator objectListIterator2 = objectList2.iterator();
        for (int n = 0; n < this.noiseSizeX; ++n) {
            int p;
            for (p = 0; p < this.noiseSizeZ + 1; ++p) {
                this.sampleNoiseColumn(ds[1][p], i * this.noiseSizeX + n + 1, j * this.noiseSizeZ + p);
            }
            for (p = 0; p < this.noiseSizeZ; ++p) {
                class_2826 chunkSection = protoChunk.method_16679(15);
                chunkSection.method_16676();
                for (int ySection = this.noiseSizeY - 1; ySection >= 0; --ySection) {
                    double t;
                    double s;
                    double r;
                    double h;
                    double g;
                    double f;
                    double e;
                    double d;
                    if (ySection > 15) {
                        int tempYSection = ySection;
                        ySection = 31 - ySection;
                        d = ds[0][p][ySection + 1];
                        e = ds[0][p + 1][ySection + 1];
                        f = ds[1][p][ySection + 1];
                        g = ds[1][p + 1][ySection + 1];
                        h = ds[0][p][ySection];
                        r = ds[0][p + 1][ySection];
                        s = ds[1][p][ySection];
                        t = ds[1][p + 1][ySection];
                        ySection = tempYSection;
                    } else {
                        d = ds[0][p][ySection];
                        e = ds[0][p + 1][ySection];
                        f = ds[1][p][ySection];
                        g = ds[1][p + 1][ySection];
                        h = ds[0][p][ySection + 1];
                        r = ds[0][p + 1][ySection + 1];
                        s = ds[1][p][ySection + 1];
                        t = ds[1][p + 1][ySection + 1];
                    }
                    for (int yInChunk = this.verticalNoiseResolution - 1; yInChunk >= 0; --yInChunk) {
                        int currentY = ySection * this.verticalNoiseResolution + yInChunk;
                        int yPosInChunkSection = currentY & 0xF;
                        int yChunkSection = currentY >> 4;
                        if (chunkSection.method_12259() >> 4 != yChunkSection) {
                            chunkSection.method_16677();
                            chunkSection = protoChunk.method_16679(yChunkSection);
                            chunkSection.method_16676();
                        }
                        double y = (double)yInChunk / (double)this.verticalNoiseResolution;
                        double z = class_3532.method_16436((double)y, (double)d, (double)h);
                        double aa = class_3532.method_16436((double)y, (double)f, (double)s);
                        double ab = class_3532.method_16436((double)y, (double)e, (double)r);
                        double ac = class_3532.method_16436((double)y, (double)g, (double)t);
                        for (int ad = 0; ad < this.horizontalNoiseResolution; ++ad) {
                            int ae = k + n * this.horizontalNoiseResolution + ad;
                            int af = ae & 0xF;
                            double ag = (double)ad / (double)this.horizontalNoiseResolution;
                            double ah = class_3532.method_16436((double)ag, (double)z, (double)aa);
                            double ai = class_3532.method_16436((double)ag, (double)ab, (double)ac);
                            for (int aj = 0; aj < this.horizontalNoiseResolution; ++aj) {
                                int au;
                                int at;
                                int ak = l + p * this.horizontalNoiseResolution + aj;
                                int al = ak & 0xF;
                                double am = (double)aj / (double)this.horizontalNoiseResolution;
                                double an = class_3532.method_16436((double)am, (double)ah, (double)ai);
                                double ao = class_3532.method_15350((double)(an / 200.0), (double)-1.0, (double)1.0);
                                ao = ao / 2.0 - ao * ao * ao / 24.0;
                                while (objectListIterator.hasNext()) {
                                    class_3443 structurePiece = (class_3443)objectListIterator.next();
                                    class_3341 blockBox = structurePiece.method_14935();
                                    at = Math.max(0, Math.max(blockBox.field_14381 - ae, ae - blockBox.field_14378));
                                    au = currentY - (blockBox.field_14380 + (structurePiece instanceof class_3790 ? ((class_3790)structurePiece).method_16646() : 0));
                                    int ar = Math.max(0, Math.max(blockBox.field_14379 - ak, ak - blockBox.field_14376));
                                    ao += BzChunkGenerator.method_16572(at, au, ar) * 0.8;
                                }
                                objectListIterator.back(objectList.size());
                                while (objectListIterator2.hasNext()) {
                                    class_3780 jigsawJunction = (class_3780)objectListIterator2.next();
                                    int as = ae - jigsawJunction.method_16610();
                                    at = currentY - jigsawJunction.method_16611();
                                    au = ak - jigsawJunction.method_16609();
                                    ao += BzChunkGenerator.method_16572(as, at, au) * 0.4;
                                }
                                objectListIterator2.back(objectList2.size());
                                class_2680 blockState = this.getBlockState(ao, currentY);
                                if (blockState == CAVE_AIR) continue;
                                if (blockState.method_26213() != 0) {
                                    mutable.method_10103(ae, currentY, ak);
                                    protoChunk.method_12315((class_2338)mutable);
                                }
                                chunkSection.method_12256(af, yPosInChunkSection, al, blockState, false);
                                heightmap.method_12597(af, currentY, al, blockState);
                                heightmap2.method_12597(af, currentY, al, blockState);
                            }
                        }
                    }
                }
                chunkSection.method_16677();
            }
            double[][] es = ds[0];
            ds[0] = ds[1];
            ds[1] = es;
        }
    }

    private static double method_16572(int i, int j, int k) {
        int l = i + 12;
        int m = j + 12;
        int n = k + 12;
        if (l >= 0 && l < 24) {
            if (m >= 0 && m < 24) {
                return n >= 0 && n < 24 ? (double)field_16649[n * 24 * 24 + l * 24 + m] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double method_16571(int i, int j, int k) {
        double d = i * i + k * k;
        double e = (double)j + 0.5;
        double f = e * e;
        double g = Math.pow(Math.E, -(f / 16.0 + d / 16.0));
        double h = -e * class_3532.method_15345((double)(f / 2.0 + d / 2.0)) / 2.0;
        return h * g;
    }

    public int method_12104() {
        return this.height;
    }

    public List<class_5483.class_1964> method_12113(class_1959 biome, class_5138 accessor, class_1311 group, class_2338 pos) {
        return super.method_12113(biome, accessor, group, pos);
    }

    public void method_12107(class_3233 region) {
        int xChunk = region.method_14336();
        int zChunk = region.method_14339();
        int xCord = xChunk << 4;
        int zCord = zChunk << 4;
        class_1959 biome = region.method_23753(new class_1923(xChunk, zChunk).method_8323());
        class_2919 sharedseedrandom = new class_2919();
        sharedseedrandom.method_12661(region.method_8412(), xCord, zCord);
        while (sharedseedrandom.nextFloat() < biome.method_30966().method_31002() * 0.75f) {
            class_1308 mobentity;
            class_5483.class_1964 biome$spawnlistentry = sharedseedrandom.nextFloat() < 0.25f ? INITIAL_HONEY_SLIME_ENTRY : INITIAL_BEE_ENTRY;
            int startingX = xCord + sharedseedrandom.nextInt(16);
            int startingZ = zCord + sharedseedrandom.nextInt(16);
            class_2338.class_2339 blockpos = new class_2338.class_2339(startingX, 0, startingZ);
            int height = BzPlacingUtils.topOfSurfaceBelowHeight((class_1936)region, sharedseedrandom.nextInt(255), -1, (class_2338)blockpos) + 1;
            if (!biome$spawnlistentry.field_9389.method_5896() || height <= 0 || height >= 255) continue;
            float width = biome$spawnlistentry.field_9389.method_17685();
            double xLength = class_3532.method_15350((double)startingX, (double)((double)xCord + (double)width), (double)((double)xCord + 16.0 - (double)width));
            double zLength = class_3532.method_15350((double)startingZ, (double)((double)zCord + (double)width), (double)((double)zCord + 16.0 - (double)width));
            class_1297 entity = biome$spawnlistentry.field_9389.method_5883((class_1937)region.method_8410());
            if (entity == null) continue;
            entity.method_5808(xLength, (double)height, zLength, sharedseedrandom.nextFloat() * 360.0f, 0.0f);
            if (!(entity instanceof class_1308) || !(mobentity = (class_1308)entity).method_5979((class_1936)region, class_3730.field_16472) || !mobentity.method_5957((class_4538)region)) continue;
            mobentity.method_5943((class_5425)region, region.method_8404(new class_2338(mobentity.method_19538())), class_3730.field_16472, null, null);
            region.method_8649((class_1297)mobentity);
        }
    }

    protected void makeCeilingAndFloor(class_2791 chunk, Random random) {
        class_2338.class_2339 blockpos$Mutable = new class_2338.class_2339();
        int xStart = chunk.method_12004().method_8326();
        int zStart = chunk.method_12004().method_8328();
        int roofHeight = 250;
        int floorHeight = 2;
        for (class_2338 blockpos : class_2338.method_10094((int)xStart, (int)0, (int)zStart, (int)(xStart + 15), (int)0, (int)(zStart + 15))) {
            for (int ceilingY = 255; ceilingY >= roofHeight - random.nextInt(2); --ceilingY) {
                chunk.method_12010((class_2338)blockpos$Mutable.method_10103(blockpos.method_10263(), ceilingY, blockpos.method_10260()), BzBlocks.BEESWAX_PLANKS.method_9564(), false);
            }
            for (int floorY = 0; floorY <= floorHeight + random.nextInt(2); ++floorY) {
                chunk.method_12010((class_2338)blockpos$Mutable.method_10103(blockpos.method_10263(), floorY, blockpos.method_10260()), BzBlocks.BEESWAX_PLANKS.method_9564(), false);
            }
        }
    }

    public int method_16398() {
        return 40;
    }

    private static /* synthetic */ void lambda$populateNoise$4(class_1923 chunkPos, ObjectList objectList, int k, int l, ObjectList objectList2, class_3449 start) {
        Iterator structurePiecesIterator = start.method_14963().iterator();
        block0: while (structurePiecesIterator.hasNext()) {
            class_3443 structurePiece = (class_3443)structurePiecesIterator.next();
            if (!structurePiece.method_16654(chunkPos, 12)) continue;
            if (structurePiece instanceof class_3790) {
                class_3790 poolStructurePiece = (class_3790)structurePiece;
                class_3785.class_3786 projection = poolStructurePiece.method_16644().method_16624();
                if (projection == class_3785.class_3786.field_16687) {
                    objectList.add((Object)poolStructurePiece);
                }
                Iterator iterator = poolStructurePiece.method_16645().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    class_3780 jigsawJunction = (class_3780)iterator.next();
                    int kx = jigsawJunction.method_16610();
                    int lx = jigsawJunction.method_16609();
                    if (kx <= k - 12 || lx <= l - 12 || kx >= k + 15 + 12 || lx >= l + 15 + 12) continue;
                    objectList2.add((Object)jigsawJunction);
                }
            }
            objectList.add((Object)structurePiece);
        }
        return;
    }
}

