/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.bumblezone.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.bumblezone.Bumblezone;
import com.telepathicgrunt.bumblezone.mixin.world.BiomeLayerSamplerAccessor;
import com.telepathicgrunt.bumblezone.world.dimension.layer.BzBiomeLayer;
import com.telepathicgrunt.bumblezone.world.dimension.layer.BzBiomePillarLayer;
import com.telepathicgrunt.bumblezone.world.dimension.layer.BzBiomeScalePillarLayer;
import java.util.Map;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3625;
import net.minecraft.class_3627;
import net.minecraft.class_3628;
import net.minecraft.class_3631;
import net.minecraft.class_3642;
import net.minecraft.class_3656;
import net.minecraft.class_3660;
import net.minecraft.class_5321;
import net.minecraft.class_5504;
import net.minecraft.class_5505;

public class BzBiomeProvider
extends class_1966 {
    public static final Codec<BzBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(biomeSource -> biomeSource.BIOME_REGISTRY)).apply((Applicative)instance, instance.stable(BzBiomeProvider::new)));
    private final class_3642 BIOME_SAMPLER;
    private final class_2378<class_1959> BIOME_REGISTRY;
    public static class_2378<class_1959> layersBiomeRegistry;

    public static void registerBiomeProvider() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960("the_bumblezone", "biome_source"), CODEC);
    }

    public BzBiomeProvider(class_2378<class_1959> biomeRegistry) {
        this(0L, biomeRegistry);
    }

    public BzBiomeProvider(long seed, class_2378<class_1959> biomeRegistry) {
        super(biomeRegistry.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals("the_bumblezone")).map(Map.Entry::getValue).collect(Collectors.toList()));
        BzBiomeLayer.setSeed(seed);
        this.BIOME_REGISTRY = biomeRegistry;
        layersBiomeRegistry = biomeRegistry;
        this.BIOME_SAMPLER = BzBiomeProvider.buildWorldProcedure(seed);
    }

    public static <T extends class_3625, C extends class_3628<T>> class_3627<T> stack(long seed, class_3660 parent, class_3627<T> incomingArea, int count, LongFunction<C> contextFactory) {
        class_3627 LayerFactory = incomingArea;
        for (int i = 0; i < count; ++i) {
            LayerFactory = parent.method_15862((class_3628)contextFactory.apply(seed + (long)i), LayerFactory);
        }
        return LayerFactory;
    }

    public static class_3642 buildWorldProcedure(long seed) {
        class_3627 layerFactory = BzBiomeProvider.build(salt -> new class_3631(25, seed, salt));
        return new class_3642(layerFactory);
    }

    public static <T extends class_3625, C extends class_3628<T>> class_3627<T> build(LongFunction<C> contextFactory) {
        class_3627 layer = BzBiomeLayer.INSTANCE.method_15854((class_3628)contextFactory.apply(200L));
        layer = BzBiomePillarLayer.INSTANCE.method_15862((class_3628)contextFactory.apply(1008L), layer);
        layer = BzBiomeScalePillarLayer.INSTANCE.method_15862((class_3628)contextFactory.apply(1055L), layer);
        layer = class_3656.field_16198.method_15862((class_3628)contextFactory.apply(2003L), layer);
        layer = class_3656.field_16198.method_15862((class_3628)contextFactory.apply(2523L), layer);
        return layer;
    }

    public class_1959 method_16359(int x, int y, int z) {
        return this.sample(this.BIOME_REGISTRY, x, z);
    }

    public class_1959 sample(class_2378<class_1959> dynamicBiomeRegistry, int x, int z) {
        int resultBiomeID = ((BiomeLayerSamplerAccessor)this.BIOME_SAMPLER).thebumblezone_getSampler().method_15825(x, z);
        class_1959 biome = (class_1959)dynamicBiomeRegistry.method_10200(resultBiomeID);
        if (biome == null) {
            if (class_155.field_1125) {
                throw (IllegalStateException)class_156.method_22320((Throwable)new IllegalStateException("Unknown biome id: " + resultBiomeID));
            }
            class_5321 backupBiomeKey = class_5504.method_31144((int)0);
            Bumblezone.LOGGER.warn("Unknown biome id: ${}. Will spawn ${} instead.", (Object)resultBiomeID, (Object)backupBiomeKey.method_29177());
            return (class_1959)dynamicBiomeRegistry.method_29107(backupBiomeKey);
        }
        return biome;
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1966 method_27985(long seed) {
        return new BzBiomeProvider(seed, this.BIOME_REGISTRY);
    }
}

