/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.bumblezone.modcompat;

import com.telepathicgrunt.bumblezone.Bumblezone;
import com.telepathicgrunt.bumblezone.modcompat.BeeBetterCompat;
import com.telepathicgrunt.bumblezone.modcompat.CharmCompat;
import com.telepathicgrunt.bumblezone.modcompat.PotionOfBeesCompat;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import org.apache.logging.log4j.Level;

public class ModChecker {
    public static boolean potionOfBeesPresent = false;
    public static boolean beeBetterPresent = false;
    public static boolean charmPresent = false;

    public static void setupModCompat() {
        String currentModID = "";
        try {
            currentModID = "potionofbees";
            ModChecker.loadupModCompat(currentModID, () -> PotionOfBeesCompat.setupPotionOfBees());
            currentModID = "beebetter";
            ModChecker.loadupModCompat(currentModID, () -> BeeBetterCompat.setupBeeBetter());
            currentModID = "charm";
            if (ModChecker.isNotOutdated(currentModID, "2.3.2")) {
                ModChecker.loadupModCompat(currentModID, () -> CharmCompat.setupCharm());
            }
        }
        catch (Exception e) {
            ModChecker.printErrorToLogs("classloading " + currentModID + " and so, mod compat done afterwards broke");
            e.printStackTrace();
        }
    }

    private static void loadupModCompat(String modid, Runnable runnable) {
        try {
            if (FabricLoader.getInstance().isModLoaded(modid)) {
                runnable.run();
            }
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs(modid);
            e.printStackTrace();
        }
    }

    private static void printErrorToLogs(String currentModID) {
        Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
        Bumblezone.LOGGER.log(Level.INFO, " ");
        Bumblezone.LOGGER.log(Level.INFO, "ERROR: Something broke when trying to add mod compatibility with" + currentModID + ". Please let The Bumblezone developer (TelepathicGrunt) know about this!");
        Bumblezone.LOGGER.log(Level.INFO, " ");
        Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
    }

    private static boolean isNotOutdated(String currentModID, String minVersion) throws VersionParsingException {
        boolean validVersion;
        if (!FabricLoader.getInstance().isModLoaded(currentModID)) {
            return false;
        }
        ModContainer modContainer = FabricLoader.getInstance().getModContainer(currentModID).orElse(null);
        if (modContainer == null) {
            return false;
        }
        Version modVersion = modContainer.getMetadata().getVersion();
        if (modVersion instanceof SemanticVersion) {
            validVersion = ((SemanticVersion)modVersion).compareTo(SemanticVersion.parse((String)minVersion)) < 0;
        } else {
            boolean bl = validVersion = modVersion.getFriendlyString().split("-")[0].compareTo(minVersion) < 0;
        }
        if (validVersion) {
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "BUMBLEZONE: You're using a version of " + modContainer.getMetadata().getName() + " that is outdated. Please update " + modContainer.getMetadata().getName() + " to the latest version of that mod to enable compat with Bumblezone again.");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            return false;
        }
        return true;
    }
}

