/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.bumblezone.entities;

import com.google.common.primitives.Doubles;
import com.telepathicgrunt.bumblezone.Bumblezone;
import com.telepathicgrunt.bumblezone.entities.IPlayerComponent;
import com.telepathicgrunt.bumblezone.tags.BZBlockTags;
import com.telepathicgrunt.bumblezone.utils.BzPlacingUtils;
import com.telepathicgrunt.bumblezone.world.dimension.BzDimension;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_4481;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class PlayerTeleportationBackend {
    public static void enteringBumblezone(class_1297 entity) {
        if (entity instanceof class_3222) {
            ((IPlayerComponent)Bumblezone.PLAYER_COMPONENT.get((Object)entity)).setNonBZPos(entity.method_19538());
            ((IPlayerComponent)Bumblezone.PLAYER_COMPONENT.get((Object)entity)).setNonBZDimension(((class_3222)entity).method_14220().method_27983().method_29177());
            MinecraftServer minecraftServer = entity.method_5682();
            class_3218 bumblezoneWorld = minecraftServer.method_3847(BzDimension.BZ_WORLD_KEY);
            class_5321 world_key = entity.field_6002.method_27983();
            if (bumblezoneWorld == null) {
                Bumblezone.LOGGER.log(Level.INFO, "Bumblezone: Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: https://bugs.mojang.com/browse/MC-195468. A restart will fix this.");
                class_2585 message = new class_2585("Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: \u00a76https://bugs.mojang.com/browse/MC-195468\u00a7f. A restart will fix this.");
                ((class_3222)entity).method_7353((class_2561)message, true);
                return;
            }
            class_3218 serverWorld = minecraftServer.method_3847(world_key);
            if (serverWorld == null) {
                serverWorld = minecraftServer.method_3847(class_1937.field_25179);
            }
            class_243 destinationPosition = PlayerTeleportationBackend.teleportByPearl((class_1657)entity, serverWorld, bumblezoneWorld);
            ((class_3222)entity).method_14251(bumblezoneWorld, destinationPosition.field_1352, destinationPosition.field_1351, destinationPosition.field_1350, entity.field_6031, entity.field_5965);
        }
    }

    public static void exitingBumblezone(class_1297 entity, class_3218 destination) {
        boolean upwardChecking;
        boolean bl = upwardChecking = entity.method_23318() > 0.0;
        if (entity instanceof class_3222) {
            class_243 destinationPosition = PlayerTeleportationBackend.teleportByOutOfBounds((class_1657)entity, destination, upwardChecking);
            ((class_3222)entity).method_14251(destination, destinationPosition.field_1352, destinationPosition.field_1351, destinationPosition.field_1350, entity.field_6031, entity.field_5965);
        }
    }

    private static class_243 teleportByOutOfBounds(class_1657 playerEntity, class_3218 destination, boolean checkingUpward) {
        class_2338 finalSpawnPos;
        double coordinateScale = playerEntity.method_5770().method_8597().method_31110() / destination.method_8597().method_31110();
        class_2338 validBlockPos = null;
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 1) {
            finalSpawnPos = new class_2338(Doubles.constrainToRange((double)(playerEntity.method_19538().method_10216() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), playerEntity.method_19538().method_10214(), Doubles.constrainToRange((double)(playerEntity.method_19538().method_10215() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
            validBlockPos = PlayerTeleportationBackend.validPlayerSpawnLocationByBeehive((class_1937)destination, finalSpawnPos, 72, checkingUpward);
        } else if (Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 2) {
            class_243 playerPos = ((IPlayerComponent)Bumblezone.PLAYER_COMPONENT.get((Object)playerEntity)).getNonBZPos();
            if (playerPos != null) {
                validBlockPos = new class_2338(playerPos);
            }
        } else {
            finalSpawnPos = new class_2338(Doubles.constrainToRange((double)(playerEntity.method_19538().method_10216() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), playerEntity.method_19538().method_10214(), Doubles.constrainToRange((double)(playerEntity.method_19538().method_10215() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
            validBlockPos = PlayerTeleportationBackend.validPlayerSpawnLocationByBeehive((class_1937)destination, finalSpawnPos, 72, checkingUpward);
            class_243 playerPos = ((IPlayerComponent)Bumblezone.PLAYER_COMPONENT.get((Object)playerEntity)).getNonBZPos();
            if (validBlockPos == null && playerPos != null) {
                validBlockPos = new class_2338(playerPos);
            }
        }
        finalSpawnPos = validBlockPos;
        if (finalSpawnPos == null) {
            finalSpawnPos = new class_2338(playerEntity.method_19538());
        }
        if ((Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 2 || Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 3 && validBlockPos == null) && destination.method_8320(finalSpawnPos.method_10084()).method_26225()) {
            destination.method_8652(finalSpawnPos, class_2246.field_10124.method_9564(), 3);
            destination.method_8652(finalSpawnPos.method_10084(), class_2246.field_10124.method_9564(), 3);
        }
        return new class_243((double)finalSpawnPos.method_10263() + 0.5, (double)(finalSpawnPos.method_10264() + 1), (double)finalSpawnPos.method_10260() + 0.5);
    }

    private static class_243 teleportByPearl(class_1657 playerEntity, class_3218 originalWorld, class_3218 bumblezoneWorld) {
        int heightCheck;
        class_2338 blockpos;
        Object validBlockPos;
        double coordinateScale = 1.0;
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode != 2) {
            coordinateScale = originalWorld.method_8597().method_31110() / bumblezoneWorld.method_8597().method_31110();
        }
        if ((validBlockPos = PlayerTeleportationBackend.validPlayerSpawnLocation((class_1937)bumblezoneWorld, blockpos = new class_2338(Doubles.constrainToRange((double)(playerEntity.method_19538().method_10216() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), playerEntity.method_19538().method_10214(), Doubles.constrainToRange((double)(playerEntity.method_19538().method_10215() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7)), 10)) == null) {
            validBlockPos = new class_2338(blockpos.method_10263(), BzPlacingUtils.topOfSurfaceBelowHeightThroughWater((class_1936)bumblezoneWorld, blockpos.method_10264(), 0, blockpos) + 1, blockpos.method_10260());
            if (validBlockPos.method_10264() == 0) {
                validBlockPos = null;
            } else if (bumblezoneWorld.method_8320(validBlockPos).method_26207() == class_3614.field_15920 && bumblezoneWorld.method_8320(validBlockPos.method_10084()).method_26207() == class_3614.field_15920) {
                class_2338.class_2339 mutable = new class_2338.class_2339(validBlockPos.method_10263(), validBlockPos.method_10264(), validBlockPos.method_10260());
                while (mutable.method_10264() < 255 && !bumblezoneWorld.method_22347((class_2338)mutable) || bumblezoneWorld.method_8320((class_2338)mutable).method_26207() == class_3614.field_15920) {
                    mutable.method_10098(class_2350.field_11036);
                }
                validBlockPos = bumblezoneWorld.method_8320((class_2338)mutable).method_26207() != class_3614.field_15959 ? null : mutable;
            } else if (!bumblezoneWorld.method_22347(validBlockPos) && bumblezoneWorld.method_8320(validBlockPos).method_26207() != class_3614.field_15920 && bumblezoneWorld.method_8320(validBlockPos.method_10084()).method_26207() != class_3614.field_15959) {
                validBlockPos = null;
            }
            if (validBlockPos == null) {
                bumblezoneWorld.method_8501(blockpos, class_2246.field_10124.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10084(), class_2246.field_10124.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10074(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10084().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10095(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10067(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10078(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10072(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10095().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10067().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10078().method_10084(), class_2246.field_21212.method_9564());
                bumblezoneWorld.method_8501(blockpos.method_10072().method_10084(), class_2246.field_21212.method_9564());
                validBlockPos = blockpos;
            }
        }
        if (playerEntity.method_6113()) {
            playerEntity.method_18400();
        }
        for (heightCheck = 0; heightCheck <= validBlockPos.method_10264() && bumblezoneWorld.method_8320(validBlockPos.method_10087(heightCheck)).method_26215(); ++heightCheck) {
        }
        if (heightCheck >= validBlockPos.method_10264()) {
            bumblezoneWorld.method_8501(validBlockPos.method_10264() == 0 ? validBlockPos : validBlockPos.method_10074(), class_2246.field_21212.method_9564());
        }
        return new class_243((double)validBlockPos.method_10263() + 0.5, (double)validBlockPos.method_10264(), (double)validBlockPos.method_10260() + 0.5);
    }

    private static class_2338 validPlayerSpawnLocationByBeehive(class_1937 world, class_2338 position, int maximumRange, boolean checkingUpward) {
        int maxHeight = 0;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        HashSet<class_2818> chunksInRange = new HashSet<class_2818>();
        for (int x = -maximumRange; x < maximumRange; ++x) {
            for (int z = -maximumRange; z < maximumRange; ++z) {
                mutableBlockPos.method_10103(position.method_10263() + x, 0, position.method_10260() + z);
                class_2791 chunk = world.method_22350((class_2338)mutableBlockPos);
                if (chunk instanceof class_2818) {
                    chunksInRange.add((class_2818)chunk);
                }
                maxHeight = Math.max(maxHeight, world.method_8624(class_2902.class_2903.field_13197, mutableBlockPos.method_10263(), mutableBlockPos.method_10260()));
            }
        }
        maxHeight = Math.min(maxHeight, world.method_8322() - 1);
        class_2338.class_2339 mutableTemp1 = new class_2338.class_2339();
        class_2338.class_2339 mutableTemp2 = new class_2338.class_2339();
        HashSet tempSet = new HashSet();
        chunksInRange.stream().map(class_2818::method_12214).forEach(map -> tempSet.addAll(map.values()));
        Stream<class_2586> allBlockEntitiesInRange = tempSet.stream().filter(be -> {
            if (!PlayerTeleportationBackend.isValidBeeHive(be.method_11010())) {
                return false;
            }
            if (Bumblezone.BZ_CONFIG.BZDimensionConfig.seaLevelOrHigherExitTeleporting && be.method_11016().method_10264() < world.method_8615()) {
                return false;
            }
            mutableTemp1.method_10101((class_2382)be.method_11016()).method_10100(-position.method_10263(), 0, -position.method_10260());
            return mutableTemp1.method_10263() * mutableTemp1.method_10263() + mutableTemp1.method_10260() + mutableTemp1.method_10260() < maximumRange;
        });
        List sortedBlockEntities = allBlockEntitiesInRange.sorted((be1, be2) -> {
            mutableTemp1.method_10101((class_2382)be1.method_11016()).method_10100(-position.method_10263(), 0, -position.method_10260());
            mutableTemp2.method_10101((class_2382)be2.method_11016()).method_10100(-position.method_10263(), 0, -position.method_10260());
            int heightDiff = mutableTemp1.method_10264() - mutableTemp2.method_10264();
            int xzDiff = Math.abs(mutableTemp1.method_10263() - mutableTemp2.method_10263()) + Math.abs(mutableTemp1.method_10260() - mutableTemp2.method_10260());
            if (checkingUpward) {
                heightDiff *= -1;
                xzDiff *= -1;
            }
            return heightDiff - xzDiff;
        }).collect(Collectors.toList());
        for (class_2586 blockEntity : sortedBlockEntities) {
            class_2338 validSpot = PlayerTeleportationBackend.validPlayerSpawnLocation(world, blockEntity.method_11016(), 4);
            if (validSpot == null) continue;
            return validSpot;
        }
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.teleportationMode == 3) {
            return null;
        }
        if (maxHeight + 1 < world.method_8322()) {
            ++maxHeight;
        }
        mutableBlockPos.method_10103(position.method_10263(), BzPlacingUtils.topOfSurfaceBelowHeight((class_1936)world, maxHeight, 0, position), position.method_10260());
        if (mutableBlockPos.method_10264() <= 0) {
            mutableBlockPos.method_10103(position.method_10263(), world.method_8322() / 2, position.method_10260());
        }
        PlayerTeleportationBackend.createSpaceForPlayer(world, mutableBlockPos);
        return mutableBlockPos;
    }

    private static void createSpaceForPlayer(class_1937 world, class_2338.class_2339 mutableBlockPos) {
        if (Bumblezone.BZ_CONFIG.BZDimensionConfig.generateBeenest) {
            world.method_8501((class_2338)mutableBlockPos, class_2246.field_20421.method_9564());
        } else if (world.method_8320((class_2338)mutableBlockPos).method_26207() == class_3614.field_15959 || !world.method_8320((class_2338)mutableBlockPos).method_26227().method_15769() && !world.method_8320((class_2338)mutableBlockPos).method_26227().method_15767((class_3494)class_3486.field_15517)) {
            world.method_8501((class_2338)mutableBlockPos, class_2246.field_21212.method_9564());
        }
        world.method_8501(mutableBlockPos.method_10084(), class_2246.field_10124.method_9564());
    }

    private static class_2338 validPlayerSpawnLocation(class_1937 world, class_2338 position, int maximumRange) {
        class_2338.class_2339 currentPos = new class_2338.class_2339(position.method_10263(), position.method_10264(), position.method_10260());
        for (int range = 0; range < maximumRange; ++range) {
            int radius = range * range;
            int outerRadius = (range + 1) * (range + 1);
            for (int y = 0; y <= range * 2; ++y) {
                int y2 = y > range ? -(y - range) : y;
                for (int x = 0; x <= range * 2; ++x) {
                    int x2 = x > range ? -(x - range) : x;
                    for (int z = 0; z <= range * 2; ++z) {
                        int z2 = z > range ? -(z - range) : z;
                        int distanceSq = x2 * x2 + z2 * z2 + y2 * y2;
                        if (distanceSq < radius || distanceSq >= outerRadius) continue;
                        currentPos.method_10101((class_2382)position.method_10069(x2, y2, z2));
                        if (!world.method_8320(currentPos.method_10074()).method_26225() || world.method_8320((class_2338)currentPos).method_26207() != class_3614.field_15959 || world.method_8320(currentPos.method_10084()).method_26207() != class_3614.field_15959) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }

    public static boolean isValidBeeHive(class_2680 block) {
        if (BZBlockTags.BLACKLISTED_TELEPORTATION_HIVES_TAG.method_15141((Object)block.method_26204())) {
            return false;
        }
        return class_3481.field_20340.method_15141((Object)block.method_26204()) || block.method_26204() instanceof class_4481;
    }

    public static void playerLeavingBz(class_2960 dimensionLeaving, class_3222 serverPlayerEntity) {
        if (!dimensionLeaving.equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            ((IPlayerComponent)Bumblezone.PLAYER_COMPONENT.get((Object)serverPlayerEntity)).setNonBZDimension(dimensionLeaving);
        }
    }
}

