/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3449;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5281;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.potions.TFMobEffects;
import twilightforest.util.PlayerHelper;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.structures.start.LegacyStructureFeature;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.biomes.BiomeKeys;

public class TFGenerationSettings {
    private static final Map<class_2960, class_2960[]> BIOME_ADVANCEMENTS = new HashMap<class_2960, class_2960[]>();
    private static final Map<class_2960, BiConsumer<class_1657, class_1937>> BIOME_PROGRESSION_ENFORCEMENT = new HashMap<class_2960, BiConsumer<class_1657, class_1937>>();
    @Deprecated
    public static final int SEALEVEL = 0;
    public static final class_2960 DIMENSION;
    public static final class_5321<class_5363> WORLDGEN_KEY;
    public static final class_5321<class_1937> DIMENSION_KEY;

    private static void registerBiomeAdvancementRestriction(class_5321<class_1959> biome, class_2960 ... advancements) {
        BIOME_ADVANCEMENTS.put(biome.method_29177(), advancements);
    }

    private static void registerBiomeProgressionEnforcement(class_5321<class_1959> biome, BiConsumer<class_1657, class_1937> exec) {
        BIOME_PROGRESSION_ENFORCEMENT.put(biome.method_29177(), exec);
    }

    public static void enforceBiomeProgression(class_1657 player, class_1937 world) {
        class_1959 currentBiome = (class_1959)world.method_23753(player.method_24515()).comp_349();
        if (TFGenerationSettings.isBiomeSafeFor(currentBiome, (class_1297)player)) {
            return;
        }
        BiConsumer<class_1657, class_1937> exec = BIOME_PROGRESSION_ENFORCEMENT.get(world.method_30349().method_30530(class_2378.field_25114).method_10221((Object)currentBiome));
        if (exec != null) {
            exec.accept(player, world);
        }
    }

    private static void trySpawnHintMonster(class_1657 player, class_1937 world, TFFeature feature) {
        if (world.field_9229.nextInt(4) == 0) {
            feature.trySpawnHintMonster(world, player);
        }
    }

    public static boolean isTwilightPortalDestination(class_1937 world) {
        return DIMENSION.equals((Object)world.method_27983().method_29177());
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean isTwilightWorldOnClient(class_1937 world) {
        return "twilightforest".equals(class_310.method_1551().field_1687.method_27983().method_29177().method_12836()) || TFGenerationSettings.isTwilightPortalDestination(world);
    }

    public static boolean usesTwilightChunkGenerator(class_3218 world) {
        return world.method_14178().method_12129() instanceof ChunkGeneratorTwilight;
    }

    public static boolean isProgressionEnforced(class_1937 world) {
        return world.method_8450().method_8355(TwilightForestMod.ENFORCED_PROGRESSION_RULE);
    }

    public static boolean isBiomeSafeFor(class_1959 biome, class_1297 entity) {
        class_2960[] advancements = BIOME_ADVANCEMENTS.get(entity.field_6002.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome));
        if (advancements != null && entity instanceof class_1657) {
            return PlayerHelper.doesPlayerHaveRequiredAdvancements((class_1657)entity, advancements);
        }
        return true;
    }

    public static void markStructureConquered(class_1937 world, class_2338 pos, TFFeature feature) {
        ChunkGeneratorTwilight generator = WorldUtil.getChunkGenerator((class_1936)world);
        if (generator != null && TFFeature.getFeatureAt(pos.method_10263(), pos.method_10260(), (class_5281)((class_3218)world)) == feature) {
            TFGenerationSettings.locateTFStructureInRange((class_5281)((class_3218)world), feature, pos, 0).ifPresent(start -> {
                if (start instanceof TFStructureStart) {
                    TFStructureStart s = (TFStructureStart)((Object)start);
                    s.setConquered(true);
                }
            });
        }
    }

    public static Optional<class_3449> locateTFStructureInRange(class_5281 world, class_2338 pos, int range) {
        TFFeature featureCheck = TFFeature.getFeatureForRegionPos(pos.method_10263(), pos.method_10260(), world);
        return TFGenerationSettings.locateTFStructureInRange(world, featureCheck, pos, range);
    }

    public static Optional<class_3449> locateTFStructureInRange(class_5281 world, TFFeature featureCheck, class_2338 pos, int range) {
        int cx1 = class_3532.method_15375((float)(pos.method_10263() - range >> 4));
        int cx2 = class_3532.method_15386((float)(pos.method_10263() + range >> 4));
        int cz1 = class_3532.method_15375((float)(pos.method_10260() - range >> 4));
        int cz2 = class_3532.method_15386((float)(pos.method_10260() + range >> 4));
        for (class_5312 structureFeature : world.method_30349().method_33309(class_2378.field_25915).method_10220().toList()) {
            class_3195 class_31952 = structureFeature.field_24835;
            if (!(class_31952 instanceof LegacyStructureFeature)) continue;
            LegacyStructureFeature legacyData = (LegacyStructureFeature)class_31952;
            TFFeature feature = legacyData.feature;
            if (feature != featureCheck) continue;
            for (int x = cx1; x <= cx2; ++x) {
                for (int z = cz1; z <= cz2; ++z) {
                    Optional<class_3449> structure = world.method_22342(x, z, class_2806.field_16423).method_12180(structureFeature).stream().map(longVal -> class_4076.method_18681((class_1923)new class_1923(longVal.longValue()), (int)0)).map(sectionPos -> world.method_8393(sectionPos.method_18674(), sectionPos.method_18687()) ? world.method_22342(sectionPos.method_18674(), sectionPos.method_18687(), class_2806.field_16423).method_12181(structureFeature) : null).filter(structureStart -> structureStart != null && structureStart.method_16657()).findFirst();
                    if (!structure.isPresent()) continue;
                    return structure;
                }
            }
        }
        return Optional.empty();
    }

    static {
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.DARK_FOREST, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.DARK_FOREST_CENTER, TwilightForestMod.prefix("progress_knights"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.FINAL_PLATEAU, TwilightForestMod.prefix("progress_troll"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.FIRE_SWAMP, TwilightForestMod.prefix("progress_labyrinth"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.GLACIER, TwilightForestMod.prefix("progress_yeti"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.HIGHLANDS, TwilightForestMod.prefix("progress_merge"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.SNOWY_FOREST, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.SWAMP, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(BiomeKeys.THORNLANDS, TwilightForestMod.prefix("progress_troll"));
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.DARK_FOREST, (player, world) -> {
            if (!world.field_9236 && player.field_6012 % 60 == 0) {
                player.method_6092(new class_1293(class_1294.field_5919, 100, 0, false, true));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.KNIGHT_STRONGHOLD);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.DARK_FOREST_CENTER, (player, world) -> {
            if (!world.field_9236 && player.field_6012 % 60 == 0) {
                player.method_6092(new class_1293(class_1294.field_5919, 100, 0, false, true));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.DARK_TOWER);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.FINAL_PLATEAU, (player, world) -> {
            if (!world.field_9236 && player.field_6012 % 5 == 0) {
                player.method_5643(class_1282.field_5846, 1.5f);
                world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), TFSounds.ACID_RAIN_BURNS, class_3419.field_15248, 1.0f, 1.0f);
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.TROLL_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.FIRE_SWAMP, (player, world) -> {
            if (!world.field_9236 && player.field_6012 % 60 == 0) {
                player.method_5639(8);
            }
            TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.HYDRA_LAIR);
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.GLACIER, (player, world) -> {
            if (!world.field_9236 && player.field_6012 % 60 == 0) {
                player.method_6092(new class_1293((class_1291)TFMobEffects.FROSTY.get(), 100, 3, false, true));
            }
            TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.ICE_TOWER);
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.HIGHLANDS, (player, world) -> {
            if (!world.field_9236 && player.field_6012 % 5 == 0) {
                player.method_5643(class_1282.field_5846, 0.5f);
                world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), TFSounds.ACID_RAIN_BURNS, class_3419.field_15248, 1.0f, 1.0f);
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.TROLL_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.SNOWY_FOREST, (player, world) -> {
            if (!world.field_9236 && player.field_6012 % 60 == 0) {
                player.method_6092(new class_1293((class_1291)TFMobEffects.FROSTY.get(), 100, 2, false, true));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.YETI_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.SWAMP, (player, world) -> {
            if (!world.field_9236 && player.field_6012 % 60 == 0) {
                class_1293 currentHunger = player.method_6112(class_1294.field_5903);
                int hungerLevel = currentHunger != null ? currentHunger.method_5578() + 1 : 1;
                player.method_6092(new class_1293(class_1294.field_5903, 100, hungerLevel, false, true));
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.LABYRINTH);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(BiomeKeys.THORNLANDS, (player, world) -> {
            if (!world.field_9236 && player.field_6012 % 5 == 0) {
                player.method_5643(class_1282.field_5846, 1.0f);
                world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), TFSounds.ACID_RAIN_BURNS, class_3419.field_15248, 1.0f, 1.0f);
                TFGenerationSettings.trySpawnHintMonster(player, world, TFFeature.TROLL_CAVE);
            }
        });
        DIMENSION = TwilightForestMod.prefix("twilight_forest");
        WORLDGEN_KEY = class_5321.method_29179((class_5321)class_2378.field_25490, (class_2960)DIMENSION);
        DIMENSION_KEY = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)DIMENSION);
    }
}

