/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3532;
import net.minecraft.class_3773;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5455;
import net.minecraft.class_5483;
import net.minecraft.class_5742;
import net.minecraft.class_6834;
import net.minecraft.class_6880;
import twilightforest.TwilightForestMod;
import twilightforest.entity.TFEntities;
import twilightforest.entity.monster.Kobold;
import twilightforest.util.IntPair;
import twilightforest.util.PlayerHelper;
import twilightforest.world.components.structures.HedgeMazeComponent;
import twilightforest.world.components.structures.HollowHillComponent;
import twilightforest.world.components.structures.HydraLairComponent;
import twilightforest.world.components.structures.QuestGrove;
import twilightforest.world.components.structures.YetiCaveComponent;
import twilightforest.world.components.structures.courtyard.CourtyardMain;
import twilightforest.world.components.structures.darktower.DarkTowerMainComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleMainComponent;
import twilightforest.world.components.structures.icetower.IceTowerMainComponent;
import twilightforest.world.components.structures.lichtower.TowerMainComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRuinsComponent;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerMainComponent;
import twilightforest.world.components.structures.stronghold.StrongholdEntranceComponent;
import twilightforest.world.components.structures.trollcave.TrollCaveMainComponent;
import twilightforest.world.components.structures.trollcave.TrollCavePieces;
import twilightforest.world.registration.biomes.BiomeKeys;

public class TFFeature {
    public static final TFFeature NOTHING = new TFFeature(0, "no_feature", false, new class_2960[0]){
        {
            this.enableDecorations().disableStructure();
        }
    };
    public static final TFFeature SMALL_HILL = new TFFeature(1, "small_hollow_hill", true, true, new class_2960[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)class_1299.field_6079, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6051, 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SWARM_SPIDER.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.KOBOLD.get()), 10, 4, 8);
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new HollowHillComponent(TFHill, this, 0, this.size, x - 3, y - 2, z - 3);
        }
    };
    public static final TFFeature MEDIUM_HILL = new TFFeature(2, "medium_hollow_hill", true, true, new class_2960[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP_SAPPER.get()), 1, 1, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.KOBOLD.get()), 10, 4, 8).addMonster((class_1299<? extends class_1309>)class_1299.field_6137, 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SWARM_SPIDER.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6079, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.FIRE_BEETLE.get()), 5, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SLIME_BEETLE.get()), 5, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6145, 1, 1, 1);
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new HollowHillComponent(TFHill, this, 0, this.size, x - 7, y - 5, z - 7);
        }
    };
    public static final TFFeature LARGE_HILL = new TFFeature(3, "large_hollow_hill", true, true, new class_2960[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP_SAPPER.get()), 2, 1, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6137, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6084, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6091, 1, 1, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.WRAITH.get()), 2, 1, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.FIRE_BEETLE.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SLIME_BEETLE.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.PINCH_BEETLE.get()), 10, 2, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6145, 1, 1, 1);
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new HollowHillComponent(TFHill, this, 0, this.size, x - 11, y - 5, z - 11);
        }
    };
    public static final TFFeature HEDGE_MAZE = new TFFeature(2, "hedge_maze", true, new class_2960[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new HedgeMazeComponent(this, 0, x + 1, y + 4, z + 1);
        }
    };
    public static final TFFeature QUEST_GROVE = new TFFeature(1, "quest_grove", true, new class_2960[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new QuestGrove(structureManager, new class_2338(x - 12, y, z - 12));
        }
    };
    public static final TFFeature NAGA_COURTYARD = new TFFeature(3, "naga_courtyard", true, new class_2960[0]){
        {
            this.enableTerrainAlterations();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new CourtyardMain(this, rand, 0, x + 1, y + 1, z + 1, structureManager);
        }
    };
    public static final TFFeature LICH_TOWER = new TFFeature(1, "lich_tower", true, new class_2960[]{TwilightForestMod.prefix("progress_naga")}){
        {
            this.addMonster((class_1299<? extends class_1309>)class_1299.field_6051, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6137, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 1, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6091, 1, 1, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.DEATH_TOME.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6145, 1, 1, 1);
            this.adjustToTerrainHeight = true;
        }

        @Override
        protected void addBookInformation(class_1799 book, class_2499 bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.lichtower", 4);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)TFFeature.BOOK_AUTHOR));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"Notes on a Pointy Tower"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new TowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature HYDRA_LAIR = new TFFeature(2, "hydra_lair", true, true, new class_2960[]{TwilightForestMod.prefix("progress_labyrinth")}){
        {
            this.enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
        }

        @Override
        protected void addBookInformation(class_1799 book, class_2499 bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.hydralair", 4);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)TFFeature.BOOK_AUTHOR));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"Notes on the Fire Swamp"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new HydraLairComponent(this, rand, 0, x - 7, y, z - 7);
        }
    };
    public static final TFFeature LABYRINTH = new TFFeature(3, "labyrinth", true, new class_2960[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.MINOTAUR.get()), 20, 2, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6084, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.MAZE_SLIME.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6091, 1, 1, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.FIRE_BEETLE.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SLIME_BEETLE.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.PINCH_BEETLE.get()), 10, 2, 4);
        }

        @Override
        protected void addBookInformation(class_1799 book, class_2499 bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.labyrinth", 5);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)TFFeature.BOOK_AUTHOR));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"Notes on a Swampy Labyrinth"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new MazeRuinsComponent(this, 0, x, y, z);
        }

        @Override
        public class_2893.class_2895 getDecorationStage() {
            return class_2893.class_2895.field_13172;
        }
    };
    public static final TFFeature DARK_TOWER = new TFFeature(1, "dark_tower", true, new class_2960[]{TwilightForestMod.prefix("progress_knights")}){
        {
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.CARMINITE_GOLEM.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6137, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6091, 2, 1, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6145, 1, 1, 1).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.CARMINITE_GHASTLING.get()), 10, 1, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.CARMINITE_BROODLING.get()), 10, 8, 8).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.PINCH_BEETLE.get()), 10, 2, 4).addMonster(1, (class_1299<? extends class_1309>)((class_1299)TFEntities.CARMINITE_GHASTGUARD.get()), 10, 1, 4).addWaterCreature((class_1299<? extends class_1309>)class_1299.field_6114, 10, 4, 4);
            this.adjustToTerrainHeight = true;
        }

        @Override
        protected void addBookInformation(class_1799 book, class_2499 bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.darktower", 3);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)TFFeature.BOOK_AUTHOR));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"Notes on a Wooden Tower"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new DarkTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature KNIGHT_STRONGHOLD = new TFFeature(3, "knight_stronghold", true, new class_2960[]{TwilightForestMod.prefix("progress_trophy_pedestal")}){
        {
            this.enableDecorations().disableProtectionAura();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.BLOCKCHAIN_GOBLIN.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.LOWER_GOBLIN_KNIGHT.get()), 5, 1, 2).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.HELMET_CRAB.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SLIME_BEETLE.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.REDCAP_SAPPER.get()), 2, 1, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.KOBOLD.get()), 10, 4, 8).addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 10, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6069, 5, 4, 4);
        }

        @Override
        protected void addBookInformation(class_1799 book, class_2499 bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.tfstronghold", 5);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)TFFeature.BOOK_AUTHOR));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"Notes on a Stronghold"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new StrongholdEntranceComponent(this, 0, x, y + 5, z);
        }

        @Override
        public class_2893.class_2895 getDecorationStage() {
            return class_2893.class_2895.field_13172;
        }
    };
    public static final TFFeature YETI_CAVE = new TFFeature(2, "yeti_lairs", true, true, new class_2960[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.undergroundDecoAllowed = false;
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.YETI.get()), 10, 4, 4);
        }

        @Override
        protected void addBookInformation(class_1799 book, class_2499 bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.yeticave", 3);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)TFFeature.BOOK_AUTHOR));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"Notes on an Icy Cave"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new YetiCaveComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature ICE_TOWER = new TFFeature(2, "ice_tower", true, new class_2960[]{TwilightForestMod.prefix("progress_yeti")}){
        {
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.SNOW_GUARDIAN.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.STABLE_ICE_CORE.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.UNSTABLE_ICE_CORE.get()), 5, 4, 4);
        }

        @Override
        protected void addBookInformation(class_1799 book, class_2499 bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.icetower", 3);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)TFFeature.BOOK_AUTHOR));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"Notes on Auroral Fortification"));
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new IceTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature TROLL_CAVE = new TFFeature(4, "troll_lairs", true, new class_2960[]{TwilightForestMod.prefix("progress_merge")}){
        {
            this.enableDecorations().enableTerrainAlterations().disableProtectionAura();
            this.addMonster((class_1299<? extends class_1309>)class_1299.field_6046, 5, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6137, 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.TROLL.get()), 20, 4, 4).addMonster((class_1299<? extends class_1309>)class_1299.field_6145, 5, 1, 1).addMonster(1, (class_1299<? extends class_1309>)((class_1299)TFEntities.GIANT_MINER.get()), 10, 1, 1).addMonster(1, (class_1299<? extends class_1309>)((class_1299)TFEntities.ARMORED_GIANT.get()), 10, 1, 1);
        }

        @Override
        protected void addBookInformation(class_1799 book, class_2499 bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.trollcave", 3);
            book.method_7959("pages", (class_2520)bookPages);
            book.method_7959("author", (class_2520)class_2519.method_23256((String)TFFeature.BOOK_AUTHOR));
            book.method_7959("title", (class_2520)class_2519.method_23256((String)"Notes on the Highlands"));
        }

        @Override
        public class_2893.class_2895 getDecorationStage() {
            return class_2893.class_2895.field_13172;
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new TrollCaveMainComponent(TrollCavePieces.TFTCMai, this, 0, x, y, z);
        }
    };
    public static final TFFeature FINAL_CASTLE = new TFFeature(4, "final_castle", true, new class_2960[]{TwilightForestMod.prefix("progress_troll")}){
        {
            this.addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.KOBOLD.get()), 10, 4, 4).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.ADHERENT.get()), 10, 1, 1).addMonster((class_1299<? extends class_1309>)((class_1299)TFEntities.HARBINGER_CUBE.get()), 10, 1, 1).addMonster((class_1299<? extends class_1309>)class_1299.field_6091, 10, 1, 1).addMonster(1, (class_1299<? extends class_1309>)((class_1299)TFEntities.KOBOLD.get()), 10, 4, 4).addMonster(1, (class_1299<? extends class_1309>)((class_1299)TFEntities.ADHERENT.get()), 10, 1, 1).addMonster(1, (class_1299<? extends class_1309>)((class_1299)TFEntities.HARBINGER_CUBE.get()), 10, 1, 1).addMonster(1, (class_1299<? extends class_1309>)((class_1299)TFEntities.ARMORED_GIANT.get()), 10, 1, 1).addMonster(2, (class_1299<? extends class_1309>)((class_1299)TFEntities.ADHERENT.get()), 10, 1, 1).addMonster(3, (class_1299<? extends class_1309>)class_1299.field_6099, 10, 1, 1);
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new FinalCastleMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature MUSHROOM_TOWER = new TFFeature(2, "mushroom_tower", true, new class_2960[0]){
        {
            this.disableStructure();
            this.adjustToTerrainHeight = true;
        }

        @Override
        public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
            return new MushroomTowerMainComponent(this, rand, 0, x, y, z);
        }
    };
    public static final TFFeature QUEST_ISLAND = new TFFeature(1, "quest_island", false, new class_2960[0]){
        {
            this.disableStructure();
        }
    };
    private static final Map<class_2960, TFFeature> BIOME_FEATURES = new ImmutableMap.Builder().put((Object)BiomeKeys.DARK_FOREST.method_29177(), (Object)KNIGHT_STRONGHOLD).put((Object)BiomeKeys.DARK_FOREST_CENTER.method_29177(), (Object)DARK_TOWER).put((Object)BiomeKeys.ENCHANTED_FOREST.method_29177(), (Object)QUEST_GROVE).put((Object)BiomeKeys.FINAL_PLATEAU.method_29177(), (Object)FINAL_CASTLE).put((Object)BiomeKeys.FIRE_SWAMP.method_29177(), (Object)HYDRA_LAIR).put((Object)BiomeKeys.GLACIER.method_29177(), (Object)ICE_TOWER).put((Object)BiomeKeys.HIGHLANDS.method_29177(), (Object)TROLL_CAVE).put((Object)BiomeKeys.SNOWY_FOREST.method_29177(), (Object)YETI_CAVE).put((Object)BiomeKeys.SWAMP.method_29177(), (Object)LABYRINTH).put((Object)BiomeKeys.LAKE.method_29177(), (Object)QUEST_ISLAND).build();
    public static final class_3773 TFHill = TFFeature.registerPiece("TFHill", HollowHillComponent::new);
    public static final class_3773 TFHedge = TFFeature.registerPiece("TFHedge", HedgeMazeComponent::new);
    public static final class_3773 TFQuestGrove = TFFeature.registerPiece("TFQuest1", QuestGrove::new);
    public static final class_3773 TFHydra = TFFeature.registerPiece("TFHydra", HydraLairComponent::new);
    public static final class_3773 TFYeti = TFFeature.registerPiece("TFYeti", YetiCaveComponent::new);
    public final int size;
    public final String name;
    public final boolean centerBounds;
    public boolean surfaceDecorationsAllowed = false;
    public boolean undergroundDecoAllowed = true;
    public boolean isStructureEnabled = true;
    public boolean requiresTerraforming = false;
    private final class_2960[] requiredAdvancements;
    public boolean hasProtectionAura = true;
    protected boolean adjustToTerrainHeight = false;
    private static int maxPossibleSize;
    private final List<List<class_5483.class_1964>> spawnableMonsterLists = new ArrayList<List<class_5483.class_1964>>();
    private final List<class_5483.class_1964> ambientCreatureList = new ArrayList<class_5483.class_1964>();
    private final List<class_5483.class_1964> waterCreatureList = new ArrayList<class_5483.class_1964>();
    private long lastSpawnedHintMonsterTime;
    private static final String BOOK_AUTHOR = "A Forgotten Explorer";

    TFFeature(int size, String name, boolean featureGenerator, class_2960 ... requiredAdvancements) {
        this(size, name, featureGenerator, false, requiredAdvancements);
    }

    TFFeature(int size, String name, boolean featureGenerator, boolean centerBounds, class_2960 ... requiredAdvancements) {
        this.size = size;
        this.name = name;
        this.requiredAdvancements = requiredAdvancements;
        this.centerBounds = centerBounds;
        maxPossibleSize = Math.max(this.size, maxPossibleSize);
    }

    static void init() {
    }

    public static int getMaxSize() {
        return maxPossibleSize;
    }

    public boolean shouldAdjustToTerrain() {
        return this.adjustToTerrainHeight;
    }

    public static TFFeature getFeatureAt(int regionX, int regionZ, class_5281 world) {
        return TFFeature.generateFeature(regionX >> 4, regionZ >> 4, world);
    }

    public static boolean isInFeatureChunk(int regionX, int regionZ) {
        int chunkX = regionX >> 4;
        int chunkZ = regionZ >> 4;
        class_2338 cc = TFFeature.getNearestCenterXYZ(chunkX, chunkZ);
        return chunkX == cc.method_10263() >> 4 && chunkZ == cc.method_10260() >> 4;
    }

    public TFFeature enableDecorations() {
        this.surfaceDecorationsAllowed = true;
        return this;
    }

    public TFFeature disableStructure() {
        this.enableDecorations();
        this.isStructureEnabled = false;
        return this;
    }

    public TFFeature enableTerrainAlterations() {
        this.requiresTerraforming = true;
        return this;
    }

    public TFFeature disableProtectionAura() {
        this.hasProtectionAura = false;
        return this;
    }

    public TFFeature addMonster(class_1299<? extends class_1309> monsterClass, int weight, int minGroup, int maxGroup) {
        this.addMonster(0, monsterClass, weight, minGroup, maxGroup);
        return this;
    }

    public TFFeature addMonster(int listIndex, class_1299<? extends class_1309> monsterClass, int weight, int minGroup, int maxGroup) {
        List<Object> monsterList;
        if (this.spawnableMonsterLists.size() > listIndex) {
            monsterList = this.spawnableMonsterLists.get(listIndex);
        } else {
            monsterList = new ArrayList();
            this.spawnableMonsterLists.add(listIndex, monsterList);
        }
        monsterList.add(new class_5483.class_1964(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public TFFeature addWaterCreature(class_1299<? extends class_1309> monsterClass, int weight, int minGroup, int maxGroup) {
        this.waterCreatureList.add(new class_5483.class_1964(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public static TFFeature getFeatureDirectlyAt(int chunkX, int chunkZ, class_5281 world) {
        if (TFFeature.isInFeatureChunk(chunkX << 4, chunkZ << 4)) {
            return TFFeature.getFeatureAt(chunkX << 4, chunkZ << 4, world);
        }
        return NOTHING;
    }

    public static TFFeature generateFeature(int chunkX, int chunkZ, class_5281 world) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        class_1959 biomeAt = (class_1959)world.method_23753(new class_2338((chunkX << 4) + 8, 0, (chunkZ << 4) + 8)).comp_349();
        return TFFeature.generateFeature(chunkX, chunkZ, biomeAt, world.method_8412(), world.method_30349());
    }

    public static TFFeature generateFeature(int chunkX, int chunkZ, class_1959 biome, long seed, class_5455 registryAccess) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        TFFeature biomeFeature = BIOME_FEATURES.get(registryAccess.method_30530(class_2378.field_25114).method_10221((Object)biome));
        if (biomeFeature != null) {
            return biomeFeature;
        }
        int regionOffsetX = Math.abs((chunkX + 64 >> 4) % 8);
        int regionOffsetZ = Math.abs((chunkZ + 64 >> 4) % 8);
        if (regionOffsetX == 4 && regionOffsetZ == 5 || regionOffsetX == 4 && regionOffsetZ == 3) {
            return LICH_TOWER;
        }
        if (regionOffsetX == 5 && regionOffsetZ == 4 || regionOffsetX == 3 && regionOffsetZ == 4) {
            return NAGA_COURTYARD;
        }
        return switch (new Random(seed + (long)chunkX * 25117L + (long)chunkZ * 151121L).nextInt(16)) {
            case 6, 7, 8 -> MEDIUM_HILL;
            case 9 -> LARGE_HILL;
            case 10, 11 -> HEDGE_MAZE;
            case 12, 13 -> NAGA_COURTYARD;
            case 14, 15 -> LICH_TOWER;
            default -> SMALL_HILL;
        };
    }

    public static TFFeature getNearestFeature(int cx, int cz, class_5281 world) {
        return TFFeature.getNearestFeature(cx, cz, world, null);
    }

    public static TFFeature getNearestFeature(int cx, int cz, class_5281 world, @Nullable IntPair center) {
        int maxSize = TFFeature.getMaxSize();
        int diam = maxSize * 2 + 1;
        TFFeature[] features = new TFFeature[diam * diam];
        for (int rad = 1; rad <= maxSize; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z = -rad; z <= rad; ++z) {
                    int idx = (x + maxSize) * diam + (z + maxSize);
                    TFFeature directlyAt = features[idx];
                    if (directlyAt == null) {
                        features[idx] = directlyAt = TFFeature.getFeatureDirectlyAt(x + cx, z + cz, world);
                    }
                    if (directlyAt.size != rad) continue;
                    if (center != null) {
                        center.x = (x << 4) + 8;
                        center.z = (z << 4) + 8;
                    }
                    return directlyAt;
                }
            }
        }
        return NOTHING;
    }

    @Nullable
    public static class_2338 findNearestFeaturePosBySpacing(class_5281 worldIn, TFFeature feature, class_2338 blockPos, int p_191069_3_, int p_191069_4_, int p_191069_5_, boolean p_191069_6_, int p_191069_7_, boolean findUnexplored) {
        int i = blockPos.method_10263() >> 4;
        int j = blockPos.method_10260() >> 4;
        Random random = new Random();
        block0: for (int k = 0; k <= p_191069_7_; ++k) {
            for (int l = -k; l <= k; ++l) {
                boolean flag = l == -k || l == k;
                for (int i1 = -k; i1 <= k; ++i1) {
                    boolean flag1;
                    boolean bl = flag1 = i1 == -k || i1 == k;
                    if (!flag && !flag1) continue;
                    int j1 = i + p_191069_3_ * l;
                    int k1 = j + p_191069_3_ * i1;
                    if (j1 < 0) {
                        j1 -= p_191069_3_ - 1;
                    }
                    if (k1 < 0) {
                        k1 -= p_191069_3_ - 1;
                    }
                    int l1 = j1 / p_191069_3_;
                    int i2 = k1 / p_191069_3_;
                    Random random1 = new Random();
                    l1 *= p_191069_3_;
                    i2 *= p_191069_3_;
                    if (p_191069_6_) {
                        l1 += (random1.nextInt(p_191069_3_ - p_191069_4_) + random1.nextInt(p_191069_3_ - p_191069_4_)) / 2;
                        i2 += (random1.nextInt(p_191069_3_ - p_191069_4_) + random1.nextInt(p_191069_3_ - p_191069_4_)) / 2;
                    } else {
                        l1 += random1.nextInt(p_191069_3_ - p_191069_4_);
                        i2 += random1.nextInt(p_191069_3_ - p_191069_4_);
                    }
                    random.nextInt();
                    if (TFFeature.getFeatureAt(l1 << 4, i2 << 4, (class_5281)worldIn.method_8410()) == feature) {
                        if (findUnexplored && worldIn.method_8393(l1, i2)) continue;
                        return new class_2338((l1 << 4) + 8, 64, (i2 << 4) + 8);
                    }
                    if (k == 0) break;
                }
                if (k == 0) continue block0;
            }
        }
        return null;
    }

    public static TFFeature getFeatureForRegion(int chunkX, int chunkZ, class_5281 world) {
        int featureX = Math.round((float)chunkX / 16.0f) * 16;
        int featureZ = Math.round((float)chunkZ / 16.0f) * 16;
        return TFFeature.generateFeature(featureX, featureZ, world);
    }

    public static TFFeature getFeatureForRegionPos(int posX, int posZ, class_5281 world) {
        return TFFeature.getFeatureForRegion(posX >> 4, posZ >> 4, world);
    }

    public static class_2338 getNearestCenterXYZ(int chunkX, int chunkZ) {
        int regionX = chunkX + 8 >> 4;
        int regionZ = chunkZ + 8 >> 4;
        long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
        seed = seed * seed * 42317861L + seed * 7L;
        int num0 = (int)(seed >> 12 & 3L);
        int num1 = (int)(seed >> 15 & 3L);
        int num2 = (int)(seed >> 18 & 3L);
        int num3 = (int)(seed >> 21 & 3L);
        int centerX = 8 + num0 - num1;
        int centerZ = 8 + num2 - num3;
        int ccz = regionZ >= 0 ? (regionZ * 16 + centerZ - 8) * 16 + 8 : (regionZ * 16 + (16 - centerZ) - 8) * 16 + 9;
        int ccx = regionX >= 0 ? (regionX * 16 + centerX - 8) * 16 + 8 : (regionX * 16 + (16 - centerX) - 8) * 16 + 9;
        return new class_2338(ccx, 0, ccz);
    }

    public List<class_5483.class_1964> getCombinedMonsterSpawnableList() {
        ArrayList<class_5483.class_1964> list = new ArrayList<class_5483.class_1964>();
        this.spawnableMonsterLists.forEach(l -> {
            if (l != null) {
                list.addAll((Collection<class_5483.class_1964>)l);
            }
        });
        return list;
    }

    public List<class_5483.class_1964> getCombinedCreatureSpawnableList() {
        ArrayList<class_5483.class_1964> list = new ArrayList<class_5483.class_1964>();
        list.addAll(this.ambientCreatureList);
        list.addAll(this.waterCreatureList);
        return list;
    }

    public List<class_5483.class_1964> getSpawnableList(class_1311 creatureType) {
        return switch (creatureType) {
            case class_1311.field_6302 -> this.getSpawnableMonsterList(0);
            case class_1311.field_6303 -> this.ambientCreatureList;
            case class_1311.field_6300 -> this.waterCreatureList;
            default -> new ArrayList();
        };
    }

    public List<class_5483.class_1964> getSpawnableMonsterList(int index) {
        if (index >= 0 && index < this.spawnableMonsterLists.size()) {
            return this.spawnableMonsterLists.get(index);
        }
        return new ArrayList<class_5483.class_1964>();
    }

    public boolean doesPlayerHaveRequiredAdvancements(class_1657 player) {
        return PlayerHelper.doesPlayerHaveRequiredAdvancements(player, this.requiredAdvancements);
    }

    public void trySpawnHintMonster(class_1937 world, class_1657 player) {
        this.trySpawnHintMonster(world, player, player.method_24515());
    }

    public void trySpawnHintMonster(class_1937 world, class_1657 player, class_2338 pos) {
        long currentTime = world.method_8510();
        if (currentTime < this.lastSpawnedHintMonsterTime) {
            this.lastSpawnedHintMonsterTime = 0L;
        }
        if (currentTime - this.lastSpawnedHintMonsterTime > 1200L) {
            for (int i = 0; i < 20; ++i) {
                if (!this.didSpawnHintMonster(world, player, pos)) continue;
                this.lastSpawnedHintMonsterTime = currentTime;
                break;
            }
        }
    }

    private boolean didSpawnHintMonster(class_1937 world, class_1657 player, class_2338 pos) {
        int dx = world.field_9229.nextInt(16) - world.field_9229.nextInt(16);
        int dy = world.field_9229.nextInt(4) - world.field_9229.nextInt(4);
        int dz = world.field_9229.nextInt(16) - world.field_9229.nextInt(16);
        Kobold hinty = (Kobold)((class_1299)TFEntities.KOBOLD.get()).method_5883(world);
        hinty.method_5725(pos.method_10069(dx, dy, dz), 0.0f, 0.0f);
        if (hinty.method_5957((class_4538)world) && hinty.method_5985().method_6369((class_1297)player)) {
            class_1799 book = this.createHintBook();
            hinty.method_5673(class_1304.field_6173, book);
            hinty.method_5946(class_1304.field_6173, 1.0f);
            world.method_8649((class_1297)hinty);
            return true;
        }
        return false;
    }

    public class_1799 createHintBook() {
        class_1799 book = new class_1799((class_1935)class_1802.field_8360);
        this.addBookInformation(book, new class_2499());
        return book;
    }

    protected void addBookInformation(class_1799 book, class_2499 bookPages) {
        TFFeature.addTranslatedPages(bookPages, "twilightforest.book.unknown", 2);
        book.method_7959("pages", (class_2520)bookPages);
        book.method_7959("author", (class_2520)class_2519.method_23256((String)BOOK_AUTHOR));
        book.method_7959("title", (class_2520)class_2519.method_23256((String)"Notes on the Unexplained"));
    }

    @Nullable
    public class_3443 provideFirstPiece(class_3485 structureManager, class_2794 chunkGenerator, Random rand, int x, int y, int z) {
        return null;
    }

    public Optional<class_3443> generatePieces(class_6834.class_6835<?> context) {
        class_1923 chunkPos = context.comp_309();
        if (!TFFeature.isInFeatureChunk(chunkPos.field_9181 << 4, chunkPos.field_9180 << 4)) {
            return Optional.empty();
        }
        boolean dontCenter = this == LICH_TOWER || this == TROLL_CAVE || this == YETI_CAVE;
        int x = (chunkPos.field_9181 << 4) + (dontCenter ? 0 : 7);
        int z = (chunkPos.field_9180 << 4) + (dontCenter ? 0 : 7);
        int y = this.shouldAdjustToTerrain() ? class_3532.method_15340((int)context.comp_306().method_18028(x, z, class_2902.class_2903.field_13194, context.comp_311()), (int)(context.comp_306().method_16398() + 1), (int)(context.comp_306().method_16398() + 7)) : context.comp_306().method_16398();
        class_6880 holder = context.comp_306().method_16359(class_5742.method_33100((int)x), class_5742.method_33100((int)y), class_5742.method_33100((int)z));
        if (this != TFFeature.generateFeature(chunkPos.field_9181, chunkPos.field_9180, (class_1959)holder.comp_349(), context.comp_308(), context.comp_314())) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.provideFirstPiece(context.comp_313(), context.comp_306(), new Random(context.comp_308() + (long)chunkPos.field_9181 * 25117L + (long)chunkPos.field_9180 * 151121L), x, y, z));
    }

    public class_2893.class_2895 getDecorationStage() {
        return class_2893.class_2895.field_13173;
    }

    private static void addTranslatedPages(class_2499 bookPages, String translationKey, int pageCount) {
        for (int i = 1; i <= pageCount; ++i) {
            bookPages.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)new class_2588(translationKey + "." + i))));
        }
    }

    public static class_3773 registerPiece(String name, class_3773 piece) {
        return (class_3773)class_2378.method_10230((class_2378)class_2378.field_16645, (class_2960)TwilightForestMod.prefix(name.toLowerCase(Locale.ROOT)), (Object)piece);
    }

    public final class_3341 getComponentToAddBoundingBox(int x, int y, int z, int minX, int minY, int minZ, int spanX, int spanY, int spanZ, @Nullable class_2350 dir) {
        if (this.centerBounds) {
            x += (spanX + minX) / 4;
            y += (spanY + minY) / 4;
            z += (spanZ + minZ) / 4;
        }
        return switch (dir) {
            case class_2350.field_11039 -> new class_3341(x - spanZ + minZ, y + minY, z + minX, x + minZ, y + spanY + minY, z + spanX + minX);
            case class_2350.field_11043 -> new class_3341(x - spanX - minX, y + minY, z - spanZ - minZ, x - minX, y + spanY + minY, z - minZ);
            case class_2350.field_11034 -> new class_3341(x + minZ, y + minY, z - spanX, x + spanZ + minZ, y + spanY + minY, z + minX);
            default -> new class_3341(x + minX, y + minY, z + minZ, x + spanX + minX, y + spanY + minY, z + spanZ + minZ);
        };
    }

    public static boolean isTheseFeatures(TFFeature feature, TFFeature ... predicates) {
        for (TFFeature predicate : predicates) {
            if (feature != predicate) continue;
            return true;
        }
        return false;
    }
}

