/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.trollcave;

import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3481;
import net.minecraft.class_3773;
import net.minecraft.class_4651;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5847;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_6880;
import twilightforest.block.TFBlocks;
import twilightforest.loot.TFTreasure;
import twilightforest.util.RotationUtil;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.feature.BlockSpikeFeature;
import twilightforest.world.components.feature.config.SpikeConfig;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.trollcave.CloudCastleComponent;
import twilightforest.world.components.structures.trollcave.TrollCaveConnectComponent;
import twilightforest.world.components.structures.trollcave.TrollCavePieces;
import twilightforest.world.components.structures.trollcave.TrollVaultComponent;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.features.TFConfiguredFeatures;

public class TrollCaveMainComponent
extends TFStructureComponentOld {
    protected static final SpikeConfig STONE_STALACTITE = new SpikeConfig((class_4651)class_4651.method_38432((class_2248)class_2246.field_10340), (class_6017)class_6019.method_35017((int)6, (int)9), (class_6017)class_6019.method_35017((int)3, (int)4), true);
    protected static final SpikeConfig STONE_STALAGMITE = new SpikeConfig((class_4651)class_4651.method_38432((class_2248)class_2246.field_10340), (class_6017)class_6019.method_35017((int)4, (int)7), (class_6017)class_6019.method_35017((int)3, (int)4), false);
    protected int size;
    protected int height;
    protected static final Predicate<class_1959> highlands = biome -> false;

    public TrollCaveMainComponent(class_6625 ctx, class_2487 nbt) {
        this(TrollCavePieces.TFTCMai, nbt);
    }

    public TrollCaveMainComponent(class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
        this.size = nbt.method_10550("size");
        this.height = nbt.method_10550("height");
    }

    public TrollCaveMainComponent(class_3773 type, TFFeature feature, int i, int x, int y, int z) {
        super(type, feature, i, x, y, z);
        this.method_14926(class_2350.field_11035);
        this.size = 30;
        this.height = 20;
        int radius = this.size / 2;
        this.field_15315 = feature.getComponentToAddBoundingBox(x, y, z, -radius, -this.height, -radius, this.size, this.height, this.size, class_2350.field_11035);
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10569("size", this.size);
        tagCompound.method_10569("height", this.height);
    }

    public void method_14918(class_3443 parent, class_6130 list, Random rand) {
        for (class_2470 caveRotation : RotationUtil.ROTATIONS) {
            class_2338 dest = this.getValidOpening(rand, caveRotation);
            this.makeSmallerCave(list, rand, this.method_14923() + 1, dest.method_10263(), dest.method_10264(), dest.method_10260(), 18, 15, caveRotation);
        }
        CloudCastleComponent castle = new CloudCastleComponent(this.getFeatureType(), this.method_14923() + 1, this.field_15315.method_35415() + (this.field_15315.method_35418() - this.field_15315.method_35415()) / 2, 168, this.field_15315.method_35417() + (this.field_15315.method_35420() - this.field_15315.method_35417()) / 2);
        list.method_35462((class_3443)castle);
        castle.method_14918(this, list, rand);
        TrollVaultComponent vault = new TrollVaultComponent(this.getFeatureType(), this.method_14923() + 1, this.field_15315.method_35415() + (this.field_15315.method_35418() - this.field_15315.method_35415()) / 2, this.field_15315.method_35416(), this.field_15315.method_35417() + (this.field_15315.method_35420() - this.field_15315.method_35417()) / 2);
        list.method_35462((class_3443)vault);
        vault.method_14918(this, list, rand);
    }

    protected boolean makeSmallerCave(class_6130 list, Random rand, int index, int x, int y, int z, int caveSize, int caveHeight, class_2470 rotation) {
        class_2350 direction = this.getStructureRelativeRotation(rotation);
        class_2338 dest = this.offsetTowerCCoords(x, y, z, caveSize, direction);
        TrollCaveConnectComponent cave = new TrollCaveConnectComponent(this.getFeatureType(), index, dest.method_10263(), dest.method_10264(), dest.method_10260(), caveSize, caveHeight, direction);
        class_3443 intersect = list.method_35461(cave.method_14935());
        if (intersect == null || intersect == this) {
            list.method_35462((class_3443)cave);
            cave.method_14918(this, list, rand);
            return true;
        }
        return false;
    }

    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, Random rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        class_2338.class_2339 dest;
        int i;
        Random decoRNG = new Random(world.method_8412() + (long)this.field_15315.method_35415() * 321534781L ^ (long)this.field_15315.method_35417() * 756839L);
        this.hollowCaveMiddle(world, sbb, rand, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        for (i = 0; i < 128; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, STONE_STALACTITE, (class_2382)dest.method_33096(this.height), sbb);
        }
        for (i = 0; i < 32; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, STONE_STALAGMITE, (class_2382)dest.method_33096(0), sbb);
        }
        for (i = 0; i < 32; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateAtSurface(world, generator, TFConfiguredFeatures.UBEROUS_SOIL_PATCH_BIG, decoRNG, dest.method_10263(), dest.method_10260(), sbb);
        }
    }

    protected class_2338.class_2339 getCoordsInCave(Random rand) {
        return new class_2338.class_2339(rand.nextInt(this.size - 1), rand.nextInt(this.height - 1), rand.nextInt(this.size - 1));
    }

    protected void hollowCaveMiddle(class_5281 world, class_3341 boundingBox, Random rand, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int threshold = this.size / 5;
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int ez;
                    int ey;
                    int ex = Math.min(x - minX, maxX - x);
                    double dist = Math.sqrt(ex * (ey = Math.min((y - minY) * 2, maxY - y)) * (ez = Math.min(z - minZ, maxZ - z)));
                    if (dist > (double)threshold) {
                        this.method_14917(world, class_2246.field_10124.method_9564(), x, y, z, boundingBox);
                        continue;
                    }
                    if (dist != (double)threshold || rand.nextInt(4) != 0 || !this.method_14929((class_1922)world, x, y, z, boundingBox).method_26164(class_3481.field_25806)) continue;
                    this.method_14917(world, ((class_2248)TFBlocks.TROLLSTEINN.get()).method_9564(), x, y, z, boundingBox);
                }
            }
        }
    }

    public class_2338 getValidOpening(Random rand, class_2470 direction) {
        int offset = this.size / 4;
        int wLength = this.size - offset * 2;
        if (direction == class_2470.field_11467 || direction == class_2470.field_11464) {
            int rx = direction == class_2470.field_11467 ? this.size - 1 : 0;
            int rz = offset + rand.nextInt(wLength);
            int ry = 0;
            return new class_2338(rx, ry, rz);
        }
        if (direction == class_2470.field_11463 || direction == class_2470.field_11465) {
            int rx = offset + rand.nextInt(wLength);
            int rz = direction == class_2470.field_11463 ? this.size - 1 : 0;
            int ry = rand.nextInt(offset) - rand.nextInt(offset);
            return new class_2338(rx, ry, rz);
        }
        return null;
    }

    @Override
    protected class_2338 offsetTowerCCoords(int x, int y, int z, int towerSize, class_2350 direction) {
        int dx = this.method_14928(x, z);
        int dy = this.method_14924(y);
        int dz = this.method_14941(x, z);
        if (direction == class_2350.field_11035) {
            return new class_2338(dx - 1, dy - 1, dz - towerSize / 2);
        }
        if (direction == class_2350.field_11039) {
            return new class_2338(dx + towerSize / 2, dy - 1, dz - 1);
        }
        if (direction == class_2350.field_11043) {
            return new class_2338(dx + 1, dy - 1, dz + towerSize / 2);
        }
        if (direction == class_2350.field_11034) {
            return new class_2338(dx - towerSize / 2, dy - 1, dz + 1);
        }
        return new class_2338(x, y, z);
    }

    protected void generateBlockSpike(class_5281 world, SpikeConfig config, class_2382 pos, class_3341 sbb) {
        this.generateBlockSpike(world, config, pos.method_10263(), pos.method_10264(), pos.method_10260(), sbb);
    }

    protected void generateBlockSpike(class_5281 world, SpikeConfig config, int x, int y, int z, class_3341 sbb) {
        int dz;
        int dy;
        int dx = this.method_14928(x, z);
        class_2338 pos = new class_2338(dx, dy = this.method_14924(y), dz = this.method_14941(x, z));
        if (sbb.method_14662((class_2382)pos)) {
            Random stalRNG = new Random(world.method_8412() + (long)dx * (long)dz);
            BlockSpikeFeature.startSpike(world, pos, config, stalRNG);
        }
    }

    protected <FC extends class_3037> void generateAtSurface(class_5281 world, class_2794 generator, class_6880<class_2975<FC, ?>> feature, Random rand, int x, int z, class_3341 sbb) {
        int dx = this.method_14928(x, z);
        int dz = this.method_14941(x, z);
        class_2338.class_2339 pos = new class_2338.class_2339(dx, WorldUtil.getSeaLevel(Objects.requireNonNull(WorldUtil.getChunkGenerator((class_1936)world))) + 15, dz);
        for (int i = 0; i < 15; ++i) {
            pos.method_10100(0, 1, 0);
            if (!sbb.method_14662((class_2382)pos) || !world.method_8320(pos.method_10084()).method_26215()) continue;
            ((class_2975)feature.comp_349()).method_12862(world, generator, rand, (class_2338)pos);
            break;
        }
    }

    protected void makeTreasureCrate(class_5281 world, class_3341 sbb) {
        int mid = this.size / 2;
        this.method_14940(world, sbb, mid - 2, 0, mid - 2, mid + 1, 3, mid + 1, class_2246.field_10540.method_9564(), class_2246.field_10540.method_9564(), false);
        this.method_14942(world, sbb, mid - 1, 1, mid - 1, mid, 2, mid);
        this.placeTreasureAtCurrentPosition(world, mid, 1, mid, TFTreasure.TROLL_GARDEN, false, sbb);
    }

    @Override
    public class_5847 method_33882() {
        return class_5847.field_28923;
    }
}

