/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_5425;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import twilightforest.TwilightForestMod;
import twilightforest.util.ArrayUtil;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerRevampPieces;
import twilightforest.world.components.structures.lichtowerrevamp.SideTowerCover;

public final class SideTowerRoom
extends TwilightTemplateStructurePiece {
    private static final List<String> SMALL_ROOMS = ImmutableList.of((Object)"empty_small", (Object)"library_steps_small");
    private static final List<String> MEDIUM_ROOMS = ImmutableList.of((Object)"empty_medium", (Object)"stacked_library_elbow_medium");
    private static final List<String> LARGE_ROOMS = ImmutableList.of((Object)"empty_large", (Object)"illegal_blockstate_kitchen", (Object)"library_plus_large");
    private static final EnumMap<class_2470, class_2338> OFFSETS = new EnumMap(class_2470.class);
    private final int squareDiameter;
    private final class_2470 externalRotation;

    public SideTowerRoom(class_6625 ctx, class_2487 compoundTag) {
        super(LichTowerRevampPieces.SIDE_TOWER_ROOM, compoundTag, ctx, SideTowerRoom.readSettings(compoundTag));
        this.squareDiameter = compoundTag.method_10550("square_diameter");
        this.externalRotation = ArrayUtil.wrapped(class_2470.values(), compoundTag.method_10550("ext_rotation"));
    }

    private SideTowerRoom(class_3485 structureManager, class_2470 roomRotation, class_2470 exteriorRotation, String name, class_2338 startPosition, int squareDiameter) {
        this(structureManager, TwilightForestMod.prefix("lich_tower/side_tower_rooms/" + name), SideTowerRoom.makeSettings(roomRotation), startPosition.method_10081((class_2382)OFFSETS.get(roomRotation).method_35830(squareDiameter - 1)).method_10081((class_2382)OFFSETS.get(exteriorRotation).method_35830(1 - squareDiameter)), squareDiameter, exteriorRotation);
    }

    private SideTowerRoom(class_3485 structureManager, class_2960 templateLocation, class_3492 placeSettings, class_2338 startPosition, int squareDiameter, class_2470 externalRotation) {
        super(LichTowerRevampPieces.SIDE_TOWER_ROOM, 0, structureManager, templateLocation, placeSettings, startPosition);
        this.squareDiameter = squareDiameter;
        this.externalRotation = externalRotation;
    }

    public static SideTowerRoom smallRoom(class_3485 structureManager, class_2470 exteriorRotation, class_2338 startPosition, Random random) {
        return new SideTowerRoom(structureManager, class_2470.method_16548((Random)random), exteriorRotation, "small/" + (String)class_156.method_32309(SMALL_ROOMS, (Random)random), startPosition, 5);
    }

    public static SideTowerRoom mediumRoom(class_3485 structureManager, class_2470 exteriorRotation, class_2338 startPosition, Random random) {
        return new SideTowerRoom(structureManager, class_2470.method_16548((Random)random), exteriorRotation, "medium/" + (String)class_156.method_32309(MEDIUM_ROOMS, (Random)random), startPosition, 7);
    }

    public static SideTowerRoom largeRoom(class_3485 structureManager, class_2470 exteriorRotation, class_2338 startPosition, Random random) {
        return new SideTowerRoom(structureManager, class_2470.method_16548((Random)random), exteriorRotation, "large/" + (String)class_156.method_32309(LARGE_ROOMS, (Random)random), startPosition, 9);
    }

    public void method_14918(class_3443 parent, class_6130 structureStart, Random random) {
        super.method_14918(parent, structureStart, random);
        class_2338 center = this.field_15315.method_22874();
        class_2338 offset = new class_2338(-(this.squareDiameter - 1 >> 1), -4, (this.squareDiameter - 1 >> 1) + 1);
        this.placeCover(structureStart, center, offset, random, class_2470.field_11465);
        this.placeCover(structureStart, center, offset, random, class_2470.field_11467);
        this.placeCover(structureStart, center, offset, random, class_2470.field_11463);
    }

    private void placeCover(class_6130 structureStart, class_2338 center, class_2338 offset, Random random, class_2470 rotation) {
        class_2470 relativeRotation = this.externalRotation.method_10501(rotation);
        class_2338 pos = center.method_10081((class_2382)offset.method_10070(relativeRotation));
        switch (this.squareDiameter) {
            case 9: {
                SideTowerCover largeCover = SideTowerCover.largeCover(this.structureManager, relativeRotation, pos, random);
                largeCover.method_14918((class_3443)this, structureStart, random);
                structureStart.method_35462((class_3443)largeCover);
                break;
            }
            case 7: {
                SideTowerCover mediumCover = SideTowerCover.mediumCover(this.structureManager, relativeRotation, pos, random);
                mediumCover.method_14918((class_3443)this, structureStart, random);
                structureStart.method_35462((class_3443)mediumCover);
                break;
            }
            case 5: {
                SideTowerCover smallCover = SideTowerCover.smallCover(this.structureManager, relativeRotation, pos, random);
                smallCover.method_14918((class_3443)this, structureStart, random);
                structureStart.method_35462((class_3443)smallCover);
            }
        }
    }

    protected void method_15026(String label, class_2338 pPos, class_5425 pLevel, Random pRandom, class_3341 pSbb) {
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 structureTag) {
        super.method_14943(ctx, structureTag);
        structureTag.method_10569("square_diameter", this.squareDiameter);
        structureTag.method_10569("ext_rotation", this.externalRotation.ordinal());
    }

    static {
        OFFSETS.put(class_2470.field_11467, class_2338.field_10980);
        OFFSETS.put(class_2470.field_11463, new class_2338(1, 0, 0));
        OFFSETS.put(class_2470.field_11464, new class_2338(1, 0, 1));
        OFFSETS.put(class_2470.field_11465, new class_2338(0, 0, 1));
    }
}

