/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_5425;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import twilightforest.TwilightForestMod;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerRevampPieces;
import twilightforest.world.components.structures.lichtowerrevamp.SideTowerRoom;

public final class CentralTowerAttachment
extends TwilightTemplateStructurePiece {
    private final int width;
    private final int length = 2;

    public CentralTowerAttachment(class_6625 ctx, class_2487 compoundTag) {
        super(LichTowerRevampPieces.CENTRAL_TO_SIDE_TOWER, compoundTag, ctx, TwilightTemplateStructurePiece.readSettings(compoundTag));
        this.width = compoundTag.method_10550("width");
    }

    private CentralTowerAttachment(class_3485 structureManager, class_2470 rotation, String name, class_2338 startPosition, int width) {
        this(structureManager, TwilightForestMod.prefix("lich_tower/attachments/central/" + name), CentralTowerAttachment.makeSettings(rotation), startPosition.method_10079(rotation.method_10503(class_2350.field_11034), -(width - 5 >> 1)), width);
    }

    private CentralTowerAttachment(class_3485 structureManager, class_2960 templateLocation, class_3492 placeSettings, class_2338 startPosition, int width) {
        super(LichTowerRevampPieces.CENTRAL_TO_SIDE_TOWER, 0, structureManager, templateLocation, placeSettings, startPosition);
        this.width = width;
    }

    public static CentralTowerAttachment startRandomAttachment(class_3485 structureManager, class_2470 rotation, class_2338 startPosition, Random random) {
        float weight = random.nextFloat() * random.nextFloat();
        if (weight < 0.33333334f) {
            return CentralTowerAttachment.smallAttachment(structureManager, rotation, startPosition);
        }
        if (weight < 0.6666667f) {
            return CentralTowerAttachment.mediumAttachment(structureManager, rotation, startPosition);
        }
        return CentralTowerAttachment.largeAttachment(structureManager, rotation, startPosition);
    }

    public static CentralTowerAttachment smallAttachment(class_3485 structureManager, class_2470 rotation, class_2338 startPosition) {
        return new CentralTowerAttachment(structureManager, rotation, "central_to_small", startPosition, 5);
    }

    public static CentralTowerAttachment mediumAttachment(class_3485 structureManager, class_2470 rotation, class_2338 startPosition) {
        return new CentralTowerAttachment(structureManager, rotation, "central_to_medium", startPosition, 7);
    }

    public static CentralTowerAttachment largeAttachment(class_3485 structureManager, class_2470 rotation, class_2338 startPosition) {
        return new CentralTowerAttachment(structureManager, rotation, "central_to_large", startPosition, 9);
    }

    public void method_14918(class_3443 parent, class_6130 structureStart, Random random) {
        super.method_14918(parent, structureStart, random);
        class_2350 dir = this.field_15313.method_10503(class_2350.field_11035);
        class_2338 placement = this.field_15432.method_10069(dir.method_10148() * this.length, 1, dir.method_10165() * this.length);
        switch (this.width) {
            case 9: {
                SideTowerRoom largeRoom = SideTowerRoom.largeRoom(this.structureManager, this.field_15313, placement, random);
                largeRoom.method_14918((class_3443)this, structureStart, random);
                structureStart.method_35462((class_3443)largeRoom);
                break;
            }
            case 7: {
                SideTowerRoom mediumRoom = SideTowerRoom.mediumRoom(this.structureManager, this.field_15313, placement, random);
                mediumRoom.method_14918((class_3443)this, structureStart, random);
                structureStart.method_35462((class_3443)mediumRoom);
                break;
            }
            case 5: {
                SideTowerRoom smallRoom = SideTowerRoom.smallRoom(this.structureManager, this.field_15313, placement, random);
                smallRoom.method_14918((class_3443)this, structureStart, random);
                structureStart.method_35462((class_3443)smallRoom);
            }
        }
    }

    protected void method_15026(String label, class_2338 pos, class_5425 levelAccessor, Random random, class_3341 boundingBox) {
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 structureTag) {
        super.method_14943(ctx, structureTag);
        structureTag.method_10569("width", this.width);
    }
}

