/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.finalcastle;

import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6625;
import twilightforest.block.TFBlocks;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.finalcastle.FinalCastlePieces;
import twilightforest.world.registration.TFFeature;

public class FinalCastleMuralComponent
extends TFStructureComponentOld {
    private int height;
    private int width;
    private byte[][] mural;

    public FinalCastleMuralComponent(class_6625 ctx, class_2487 nbt) {
        super(FinalCastlePieces.TFFCMur, nbt);
    }

    public FinalCastleMuralComponent(TFFeature feature, int i, int x, int y, int z, int width, int height, class_2350 direction) {
        super(FinalCastlePieces.TFFCMur, feature, i, x, y, z);
        this.method_14926(direction);
        this.field_15315 = TFStructureComponentOld.getComponentToAddBoundingBox2(x, y, z, 0, -height / 2, -width / 2, 1, height - 1, width - 1, direction);
    }

    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, Random rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        this.height = this.field_15315.method_14660();
        this.width = this.method_14934() == class_2350.field_11035 || this.method_14934() == class_2350.field_11043 ? this.field_15315.method_14663() : this.field_15315.method_35414();
        Random decoRNG = new Random(world.method_8412() + (long)this.field_15315.method_35415() * 321534781L ^ (long)this.field_15315.method_35417() * 756839L);
        if (this.mural == null) {
            this.mural = new byte[this.width][this.height];
            int startX = this.width / 2 - 1;
            int startY = 2;
            for (int x = -1; x < 2; ++x) {
                for (int y = -1; y < 2; ++y) {
                    this.mural[startX + x][startY + y] = 1;
                }
            }
            this.makeHorizontalTree(decoRNG, this.mural, startX + 1, startY, decoRNG.nextInt(this.width / 6) + this.width / 6, true);
            this.makeHorizontalTree(decoRNG, this.mural, startX - 1, startY, decoRNG.nextInt(this.width / 6) + this.width / 6, false);
            this.makeVerticalTree(decoRNG, this.mural, startX, startY + 1, decoRNG.nextInt(this.height / 6) + this.height / 6, true);
            this.makeStripes(decoRNG, this.mural);
        }
        class_2680 castleMagic = ((class_2248)TFBlocks.BLUE_CASTLE_RUNE_BRICK.get()).method_9564();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.mural[x][y] <= 0) continue;
                this.method_14917(world, castleMagic, 0, y, x, sbb);
            }
        }
    }

    private void makeHorizontalTree(Random decoRNG, byte[][] mural, int centerX, int centerY, int branchLength, boolean positive) {
        this.fillHorizontalLine(mural, centerX, centerY, branchLength, positive);
        this.makeHorizontalBranch(mural, decoRNG, centerX, centerY, branchLength, positive, true);
        this.makeHorizontalBranch(mural, decoRNG, centerX, centerY, branchLength, positive, false);
    }

    private void makeVerticalTree(Random decoRNG, byte[][] mural, int centerX, int centerY, int branchLength, boolean positive) {
        this.fillVerticalLine(mural, centerX, centerY, branchLength, positive);
        this.makeVerticalBranch(mural, decoRNG, centerX, centerY, branchLength, positive, true);
        this.makeVerticalBranch(mural, decoRNG, centerX, centerY, branchLength, positive, false);
    }

    private boolean makeHorizontalBranch(byte[][] mural, Random rand, int sx, int sy, int length, boolean plusX, boolean plusY) {
        int downLine = length / 2 + 1 + rand.nextInt(Math.max(length / 2, 2));
        int branchLength = rand.nextInt(this.width / 8) + this.width / 8;
        boolean clear = true;
        for (int i = 0; i <= branchLength; ++i) {
            int cx = sx + (plusX ? downLine - 1 + i : -(downLine - 1 + i));
            int cy = sy + (plusY ? 2 : -2);
            if (cx >= 0 && cx < this.width && cy >= 0 && cy < this.height && mural[cx][cy] <= 0) continue;
            clear = false;
            break;
        }
        if (clear) {
            int bx = sx + (plusX ? downLine : -downLine);
            int by = sy;
            this.fillVerticalLine(mural, bx, by, 1, plusY);
            this.fillHorizontalLine(mural, bx, by += plusY ? 2 : -2, branchLength, plusX);
            if (bx > 0 && bx < this.width && by > 0 && by < this.height) {
                if (!(this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, true) || this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, true) || this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, true))) {
                    this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, true);
                }
                if (!(this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, false) || this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, false) || this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, false))) {
                    this.makeHorizontalBranch(mural, rand, bx, by, branchLength, plusX, false);
                }
            }
            return true;
        }
        return false;
    }

    private boolean makeVerticalBranch(byte[][] mural, Random rand, int sx, int sy, int length, boolean plusY, boolean plusX) {
        int downLine = length / 2 + 1 + rand.nextInt(Math.max(length / 2, 2));
        int branchLength = rand.nextInt(this.height / 8) + this.height / 8;
        boolean clear = true;
        for (int i = 0; i <= branchLength; ++i) {
            int cx = sx + (plusX ? 2 : -2);
            int cy = sy + (plusY ? downLine - 1 + i : -(downLine - 1 + i));
            if (cx >= 0 && cx < this.width && cy >= 0 && cy < this.height && mural[cx][cy] <= 0) continue;
            clear = false;
            break;
        }
        if (clear) {
            int bx = sx;
            int by = sy + (plusY ? downLine : -downLine);
            this.fillHorizontalLine(mural, bx, by, 1, plusX);
            this.fillVerticalLine(mural, bx += plusX ? 2 : -2, by, branchLength, plusY);
            if (bx > 0 && bx < this.width && by > 0 && by < this.height) {
                if (!(this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, true) || this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, true) || this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, true))) {
                    this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, true);
                }
                if (!(this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, false) || this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, false) || this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, false))) {
                    this.makeVerticalBranch(mural, rand, bx, by, branchLength, plusY, false);
                }
            }
            return true;
        }
        return false;
    }

    private void fillHorizontalLine(byte[][] mural, int sx, int sy, int length, boolean positive) {
        int x = sx;
        int y = sy;
        for (int i = 0; i <= length; ++i) {
            if (x < 0 || x >= this.width || y < 0 || y >= this.height) continue;
            mural[x][y] = (byte)(positive ? 1 : 4);
            x += positive ? 1 : -1;
        }
    }

    private void fillVerticalLine(byte[][] mural, int sx, int sy, int length, boolean positive) {
        int x = sx;
        int y = sy;
        for (int i = 0; i <= length; ++i) {
            if (x < 0 || x >= this.width || y < 0 || y >= this.height) continue;
            mural[x][y] = (byte)(positive ? 2 : 3);
            y += positive ? 1 : -1;
        }
    }

    private void makeStripes(Random decoRNG, byte[][] mural2) {
        for (int y = this.height - 2; y > this.height / 3; y -= 2 + decoRNG.nextInt(2)) {
            this.makeSingleStripe(mural2, y);
        }
    }

    private void makeSingleStripe(byte[][] mural2, int y) {
        int x;
        for (x = 0; x < this.width - 2 && this.mural[x + 1][y] == 0 && this.mural[x + 1][y + 1] == 0; ++x) {
            this.mural[x][y] = 1;
        }
        for (x = this.width - 1; x > 2 && this.mural[x - 1][y] == 0 && this.mural[x - 1][y + 1] == 0; --x) {
            this.mural[x][y] = 1;
        }
    }
}

