/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3773;
import net.minecraft.class_4651;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6625;
import twilightforest.entity.TFEntities;
import twilightforest.loot.TFTreasure;
import twilightforest.world.components.feature.BlockSpikeFeature;
import twilightforest.world.components.feature.config.SpikeConfig;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.registration.TFFeature;

public class HollowHillComponent
extends TFStructureComponentOld {
    private static final int[] stalactitesForSizes = new int[]{0, 128, 256, 512};
    private static final int[] spawnersForSizes = new int[]{0, 1, 4, 9};
    private static final int[] chestsForSizes = new int[]{0, 2, 6, 12};
    protected static final SpikeConfig STONE_STALACTITE = new SpikeConfig((class_4651)class_4651.method_38433((class_2680)class_2246.field_10340.method_9564()), (class_6017)class_6019.method_35017((int)5, (int)11), (class_6017)class_6019.method_35017((int)4, (int)5), true);
    protected static final SpikeConfig STONE_STALAGMITE = new SpikeConfig((class_4651)class_4651.method_38433((class_2680)class_2246.field_10340.method_9564()), (class_6017)class_6019.method_35017((int)5, (int)10), (class_6017)class_6019.method_35017((int)4, (int)5), false);
    private final int hillSize;
    final int radius;
    final int hdiam;

    public HollowHillComponent(class_6625 ctx, class_2487 nbt) {
        this(TFFeature.TFHill, nbt);
    }

    public HollowHillComponent(class_3773 piece, class_2487 nbt) {
        super(piece, nbt);
        this.hillSize = nbt.method_10550("hillSize");
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.hdiam = (this.hillSize * 2 + 1) * 16;
    }

    public HollowHillComponent(class_3773 piece, TFFeature feature, int i, int size, int x, int y, int z) {
        super(piece, feature, i, x, y, z);
        this.method_14926(class_2350.field_11035);
        this.hillSize = size;
        this.radius = (this.hillSize * 2 + 1) * 8 - 6;
        this.hdiam = (this.hillSize * 2 + 1) * 16;
        this.field_15315 = feature.getComponentToAddBoundingBox(x, y, z, -this.radius, -(3 + this.hillSize), -this.radius, this.radius * 2, this.radius / (this.hillSize == 1 ? 2 : this.hillSize), this.radius * 2, class_2350.field_11035);
    }

    @Override
    protected void method_14943(class_6625 ctx, class_2487 tagCompound) {
        super.method_14943(ctx, tagCompound);
        tagCompound.method_10569("hillSize", this.hillSize);
    }

    public void method_14931(class_5281 world, class_5138 manager, class_2794 generator, Random rand, class_3341 sbb, class_1923 chunkPosIn, class_2338 blockPos) {
        class_2338.class_2339 dest;
        int i;
        int stalactiteCount = stalactitesForSizes[this.hillSize];
        for (i = 0; i < stalactiteCount; ++i) {
            dest = this.randomCeilingCoordinates(rand, this.radius);
            this.generateOreStalactite(world, (class_2382)dest.method_10100(0, 1, 0), sbb);
        }
        for (i = 0; i < stalactiteCount; ++i) {
            dest = this.randomCeilingCoordinates(rand, this.radius);
            this.generateBlockSpike(world, STONE_STALACTITE, dest.method_10263(), dest.method_10264(), dest.method_10260(), sbb);
        }
        for (i = 0; i < stalactiteCount; ++i) {
            dest = this.randomFloorCoordinates(rand, this.radius);
            this.generateBlockSpike(world, STONE_STALAGMITE, dest.method_10263(), dest.method_10264(), dest.method_10260(), sbb);
        }
        for (i = 0; i < spawnersForSizes[this.hillSize]; ++i) {
            dest = this.randomFloorCoordinates(rand, this.radius);
            class_1299<?> mobID = this.getMobID(rand);
            this.setSpawner(world, (class_2382)dest.method_10100(0, 1, 0), sbb, mobID);
        }
        for (i = 0; i < chestsForSizes[this.hillSize]; ++i) {
            dest = this.randomFloorCoordinates(rand, this.radius);
            this.generateTreasureChest(world, (class_2382)dest.method_10100(0, 1, 0), sbb);
        }
    }

    protected void generateTreasureChest(class_5281 world, class_2382 pos, class_3341 sbb) {
        this.generateTreasureChest(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), sbb);
    }

    protected void generateTreasureChest(class_5281 world, int x, int y, int z, class_3341 sbb) {
        Random chestRNG = new Random(world.method_8412() + (long)x * (long)z);
        this.placeTreasureAtCurrentPosition(world, x, y, z, this.hillSize == 3 ? TFTreasure.LARGE_HOLLOW_HILL : (this.hillSize == 2 ? TFTreasure.MEDIUM_HOLLOW_HILL : TFTreasure.SMALL_HOLLOW_HILL), sbb);
        this.method_14917(world, class_2246.field_10445.method_9564(), x, y - 1, z, sbb);
    }

    protected void generateOreStalactite(class_5281 world, class_2382 pos, class_3341 sbb) {
        this.generateOreStalactite(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), sbb);
    }

    protected void generateOreStalactite(class_5281 world, int x, int y, int z, class_3341 sbb) {
        int dz;
        int dy;
        int dx = this.method_14928(x, z);
        class_2338 pos = new class_2338(dx, dy = this.method_14924(y), dz = this.method_14941(x, z));
        if (sbb.method_14662((class_2382)pos) && world.method_8320(pos).method_26204() != class_2246.field_10260) {
            Random stalRNG = new Random(world.method_8412() + (long)dx * (long)dz);
            SpikeConfig stalag = BlockSpikeFeature.makeRandomOreStalactite(stalRNG, this.hillSize);
            BlockSpikeFeature.startSpike(world, pos, stalag, stalRNG);
        }
    }

    protected void generateBlockSpike(class_5281 world, SpikeConfig config, int x, int y, int z, class_3341 sbb) {
        int dz;
        int dy;
        int dx = this.method_14928(x, z);
        class_2338 pos = new class_2338(dx, dy = this.method_14924(y), dz = this.method_14941(x, z));
        if (sbb.method_14662((class_2382)pos) && world.method_8320(pos).method_26204() != class_2246.field_10260) {
            Random stalRNG = new Random(world.method_8412() + (long)dx * (long)dz);
            BlockSpikeFeature.startSpike(world, pos, config, stalRNG);
        }
    }

    boolean isInHill(int cx, int cz) {
        int dx = this.radius - cx;
        int dz = this.radius - cz;
        return class_3532.method_15355((float)(dx * dx + dz * dz)) < (float)this.radius;
    }

    @Deprecated
    int[] randomCoordinatesInHill2D(Random rand) {
        return this.randomCoordinatesInHill2D(rand, this.radius);
    }

    @Deprecated
    int[] randomCoordinatesInHill2D(Random rand, int maximumRadius) {
        class_2338.class_2339 pos = this.randomFloorCoordinates(rand, maximumRadius);
        return new int[]{pos.method_10263(), pos.method_10260()};
    }

    class_2338.class_2339 randomFloorCoordinates(Random rand, float maximumRadius) {
        float degree = rand.nextFloat() * ((float)Math.PI * 2);
        float radius = rand.nextFloat() * 0.9f * maximumRadius;
        float dist = class_3532.method_15355((float)(radius * radius));
        float height = (float)(this.hillSize * 2) - class_3532.method_15362((float)(dist / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 20.0f) + 1.0f;
        return new class_2338.class_2339((double)(maximumRadius - class_3532.method_15362((float)degree) * radius), (double)height, (double)(maximumRadius - class_3532.method_15374((float)degree) * radius));
    }

    class_2338.class_2339 randomCeilingCoordinates(Random rand, float maximumRadius) {
        float degree = rand.nextFloat() * ((float)Math.PI * 2);
        float radius = rand.nextFloat() * 0.9f * maximumRadius;
        float dist = class_3532.method_15355((float)(radius * radius));
        float height = class_3532.method_15362((float)(dist / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 4.0f);
        return new class_2338.class_2339((double)(maximumRadius - class_3532.method_15362((float)degree) * radius), (double)height, (double)(maximumRadius - class_3532.method_15374((float)degree) * radius));
    }

    protected class_1299<?> getMobID(Random rand) {
        return this.getMobID(rand, this.hillSize);
    }

    protected class_1299<?> getMobID(Random rand, int level) {
        if (level == 1) {
            return this.getLevel1Mob(rand);
        }
        if (level == 2) {
            return this.getLevel2Mob(rand);
        }
        if (level == 3) {
            return this.getLevel3Mob(rand);
        }
        return class_1299.field_6079;
    }

    public class_1299<?> getLevel1Mob(Random rand) {
        return switch (rand.nextInt(10)) {
            case 3, 4, 5 -> class_1299.field_6079;
            case 6, 7 -> class_1299.field_6051;
            case 8 -> class_1299.field_6125;
            case 9 -> (class_1299)TFEntities.REDCAP.get();
            default -> (class_1299)TFEntities.SWARM_SPIDER.get();
        };
    }

    public class_1299<?> getLevel2Mob(Random rand) {
        return switch (rand.nextInt(10)) {
            case 3, 4, 5 -> class_1299.field_6051;
            case 6, 7 -> class_1299.field_6137;
            case 8 -> (class_1299)TFEntities.SWARM_SPIDER.get();
            case 9 -> class_1299.field_6084;
            default -> (class_1299)TFEntities.REDCAP.get();
        };
    }

    public class_1299<?> getLevel3Mob(Random rand) {
        return switch (rand.nextInt(11)) {
            case 0 -> (class_1299)TFEntities.SLIME_BEETLE.get();
            case 1 -> (class_1299)TFEntities.FIRE_BEETLE.get();
            case 2 -> (class_1299)TFEntities.PINCH_BEETLE.get();
            case 3, 4, 5 -> class_1299.field_6137;
            case 6, 7, 8 -> class_1299.field_6084;
            case 9 -> class_1299.field_6046;
            default -> (class_1299)TFEntities.WRAITH.get();
        };
    }
}

