/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import twilightforest.enums.StructureWoodVariant;
import twilightforest.util.ArrayUtil;
import twilightforest.world.registration.TFStructureProcessors;

public final class CobblePlankSwizzler
extends class_3491 {
    private final StructureWoodVariant OAK_SWIZZLE;
    private final StructureWoodVariant SPRUCE_SWIZZLE;
    private final StructureWoodVariant BIRCH_SWIZZLE;
    public static final Codec<CobblePlankSwizzler> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)StructureWoodVariant.values().length).fieldOf("oak_to_type").orElse((Object)0).forGetter(s -> s.OAK_SWIZZLE.ordinal()), (App)Codec.intRange((int)0, (int)StructureWoodVariant.values().length).fieldOf("spruce_to_type").orElse((Object)1).forGetter(s -> s.SPRUCE_SWIZZLE.ordinal()), (App)Codec.intRange((int)0, (int)StructureWoodVariant.values().length).fieldOf("birch_to_type").orElse((Object)2).forGetter(s -> s.BIRCH_SWIZZLE.ordinal())).apply((Applicative)instance, CobblePlankSwizzler::new));

    private CobblePlankSwizzler(int oakSwizzle, int spruceSwizzle, int birchSwizzle) {
        this.OAK_SWIZZLE = ArrayUtil.wrapped(StructureWoodVariant.values(), oakSwizzle);
        this.SPRUCE_SWIZZLE = ArrayUtil.wrapped(StructureWoodVariant.values(), spruceSwizzle);
        this.BIRCH_SWIZZLE = ArrayUtil.wrapped(StructureWoodVariant.values(), birchSwizzle);
    }

    public CobblePlankSwizzler(Random random) {
        this.OAK_SWIZZLE = StructureWoodVariant.getRandomWeighted(random);
        this.SPRUCE_SWIZZLE = StructureWoodVariant.getRandomWeighted(random);
        this.BIRCH_SWIZZLE = StructureWoodVariant.getRandomWeighted(random);
    }

    @Nullable
    public class_3499.class_3501 method_15110(class_4538 worldIn, class_2338 pos, class_2338 piecepos, class_3499.class_3501 p_215194_3_, class_3499.class_3501 blockInfo, class_3492 settings) {
        class_2680 state = blockInfo.field_15596;
        class_2248 block = state.method_26204();
        StructureWoodVariant type = StructureWoodVariant.getVariantFromBlock(block);
        if (type != null) {
            return switch (type) {
                case StructureWoodVariant.OAK -> new class_3499.class_3501(blockInfo.field_15597, StructureWoodVariant.modifyBlockWithType(state, this.OAK_SWIZZLE), null);
                case StructureWoodVariant.SPRUCE -> new class_3499.class_3501(blockInfo.field_15597, StructureWoodVariant.modifyBlockWithType(state, this.SPRUCE_SWIZZLE), null);
                case StructureWoodVariant.BIRCH -> new class_3499.class_3501(blockInfo.field_15597, StructureWoodVariant.modifyBlockWithType(state, this.BIRCH_SWIZZLE), null);
                default -> blockInfo;
            };
        }
        return blockInfo;
    }

    protected class_3828<?> method_16772() {
        return (class_3828)TFStructureProcessors.COBBLE_PLANK_SWIZZLER.get();
    }
}

