/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.github.fabricators_of_create.porting_lib.util.IPlantable;
import io.github.fabricators_of_create.porting_lib.util.LevelUtil;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import twilightforest.block.TFBlocks;
import twilightforest.util.FeatureLogic;
import twilightforest.util.FeaturePlacers;
import twilightforest.util.FeatureUtil;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;
import twilightforest.world.components.feature.trees.TFTreeGenerator;

public class TFGenCanopyTree
extends TFTreeGenerator<TFTreeFeatureConfig> {
    private final List<class_2338> leaves = Lists.newArrayList();

    public TFGenCanopyTree(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(class_5281 world, Random random, class_2338 pos, BiConsumer<class_2338, class_2680> trunkPlacer, BiConsumer<class_2338, class_2680> leavesPlacer, BiConsumer<class_2338, class_2680> decorationPlacer, TFTreeFeatureConfig config) {
        int treeHeight = config.minHeight;
        if (random.nextInt(config.chanceAddFiveFirst) == 0) {
            treeHeight += random.nextInt(5);
            if (random.nextInt(config.chanceAddFiveSecond) == 0) {
                treeHeight += random.nextInt(5);
            }
        }
        if (world.method_31601(pos.method_10264() + treeHeight)) {
            return false;
        }
        class_2680 state = world.method_8320(pos.method_10074());
        if (!state.method_26204().canSustainPlant(state, (class_1922)world, pos.method_10074(), class_2350.field_11036, (IPlantable)TFBlocks.CANOPY_SAPLING.get())) {
            return false;
        }
        this.leaves.clear();
        this.buildBranch((class_1936)world, pos, trunkPlacer, 0, treeHeight, 0.0, 0.0, true, random, config);
        int numBranches = 3 + random.nextInt(2);
        float offset = random.nextFloat();
        for (int b = 0; b < numBranches; ++b) {
            this.buildBranch((class_1936)world, pos, trunkPlacer, treeHeight - 10 + b, 9.0, 0.3 * (double)b + (double)offset, 0.2, false, random, config);
        }
        if (config.hasLeaves) {
            for (class_2338 leafPos : this.leaves) {
                this.makeLeafBlob((class_3746)world, leavesPlacer, random, leafPos, config);
            }
        }
        if (FeatureUtil.hasAirAround((class_1936)world, pos.method_10074())) {
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, random, pos.method_10074(), config.trunkProvider);
        } else {
            FeaturePlacers.placeIfValidRootPos((class_3746)world, decorationPlacer, random, pos.method_10074(), config.rootsProvider);
        }
        int numRoots = 3 + random.nextInt(2);
        offset = random.nextFloat();
        for (int b = 0; b < numRoots; ++b) {
            FeaturePlacers.buildRoot((class_1936)world, decorationPlacer, random, pos, offset, b, config.rootsProvider);
        }
        return true;
    }

    private void makeLeafBlob(class_3746 world, BiConsumer<class_2338, class_2680> leafPlacer, Random random, class_2338 leafPos, TFTreeFeatureConfig config) {
        FeaturePlacers.placeCircleOdd(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, random, leafPos.method_10074(), 3.0f, config.leavesProvider);
        FeaturePlacers.placeCircleOdd(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, random, leafPos, 4.0f, config.leavesProvider);
        FeaturePlacers.placeCircleOdd(world, leafPlacer, FeaturePlacers.VALID_TREE_POS, random, leafPos.method_10084(), 2.0f, config.leavesProvider);
    }

    void buildBranch(class_1936 world, class_2338 pos, BiConsumer<class_2338, class_2680> trunkPlacer, int height, double length, double angle, double tilt, boolean trunk, Random treeRNG, TFTreeFeatureConfig config) {
        class_2338 src = pos.method_10086(height);
        class_2338 dest = FeatureLogic.translate(src, length, angle, tilt);
        if (LevelUtil.isAreaLoaded((class_1936)world, (class_2338)dest, (int)5)) {
            if (trunk) {
                FeaturePlacers.drawBresenhamTree((class_3746)world, trunkPlacer, FeaturePlacers.VALID_TREE_POS, src, dest, config.trunkProvider, treeRNG);
            } else {
                FeaturePlacers.drawBresenhamBranch(world, trunkPlacer, treeRNG, src, dest, config.branchProvider);
            }
            if (trunk) {
                FeaturePlacers.addFirefly(world, pos, 3 + treeRNG.nextInt(7), treeRNG.nextDouble());
            }
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10078(), config.branchProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10067(), config.branchProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10072(), config.branchProvider);
            FeaturePlacers.placeIfValidTreePos((class_3746)world, trunkPlacer, treeRNG, dest.method_10095(), config.branchProvider);
            this.leaves.add(dest);
        }
    }
}

