/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators.warp;

import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2794;
import net.minecraft.class_3532;
import net.minecraft.class_5309;
import net.minecraft.class_5310;
import net.minecraft.class_5822;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.warp.NoiseModifier;
import twilightforest.world.components.chunkgenerators.warp.TFBlendedNoise;

public class TFTerrainWarp {
    private final int cellWidth;
    private final int cellHeight;
    private final int cellCountY;
    private final class_1966 biomeSource;
    private final class_5309 noiseSettings;
    private final class_5310 topSlide;
    private final class_5310 bottomSlide;
    private final class_5822 blendedNoise;
    private final double dimensionDensityFactor;
    private final double dimensionDensityOffset;
    public final NoiseModifier caveNoiseModifier;
    protected static final float[] BIOME_WEIGHTS = (float[])class_156.method_654((Object)new float[25], afloat -> {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                float weight;
                afloat[x + 2 + (z + 2) * 5] = weight = 10.0f / class_3532.method_15355((float)((float)(x * x + z * z) + 0.2f));
            }
        }
    });

    public TFTerrainWarp(int width, int height, int yCount, class_1966 source, class_5309 settings, class_5822 blend, NoiseModifier modifier) {
        double d;
        TFBiomeProvider tfsource;
        this.cellWidth = width;
        this.cellHeight = height;
        this.cellCountY = yCount;
        this.biomeSource = source;
        this.noiseSettings = settings;
        this.topSlide = settings.comp_176();
        this.bottomSlide = settings.comp_177();
        this.blendedNoise = blend;
        if (source instanceof TFBiomeProvider) {
            tfsource = (TFBiomeProvider)source;
            v0 = tfsource.getBaseFactor();
        } else {
            v0 = this.dimensionDensityFactor = 1.0;
        }
        if (source instanceof TFBiomeProvider) {
            tfsource = (TFBiomeProvider)source;
            d = tfsource.getBaseOffset();
        } else {
            d = 0.0;
        }
        this.dimensionDensityOffset = d;
        this.caveNoiseModifier = modifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fillNoiseColumn(class_2794 generator, double[] adouble, int x, int z, class_5309 settings, int sealevel, int min, int max) {
        class_1966 class_19662 = this.biomeSource;
        if (!(class_19662 instanceof TFBiomeProvider)) throw new IllegalArgumentException("BiomeSource is not an instance of TFBiomeProvider");
        TFBiomeProvider source = (TFBiomeProvider)class_19662;
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float depth = source.getBiomeDepth(x, sealevel, z, generator.method_38276());
        for (int offX = -2; offX <= 2; ++offX) {
            for (int offZ = -2; offZ <= 2; ++offZ) {
                class_1959 biome = (class_1959)source.method_38109(x + offX, sealevel, z + offZ, generator.method_38276()).comp_349();
                float offD = source.getBiomeDepth(biome);
                float offS = source.getBiomeScale(biome);
                float f6 = offD;
                float f7 = offS;
                float f8 = offD > depth ? 0.5f : 1.0f;
                float f9 = f8 * BIOME_WEIGHTS[offX + 2 + (offZ + 2) * 5] / (f6 + 2.0f);
                f += f7 * f9;
                f1 += f6 * f9;
                f2 += f9;
            }
        }
        float f10 = f1 / f2;
        float f11 = f / f2;
        double d6 = f10 * 0.5f - 0.125f;
        double d8 = f11 * 0.9f + 0.1f;
        double d0 = d6 * 0.265625;
        double d1 = 96.0 / d8;
        double scaleXZ = 684.412 * settings.comp_175().comp_503();
        double scaleY = 684.412 * settings.comp_175().comp_504();
        double factorXZ = scaleXZ / settings.comp_175().comp_505();
        double factorY = scaleY / settings.comp_175().comp_506();
        double density = -0.46875;
        class_5822 class_58222 = this.blendedNoise;
        if (!(class_58222 instanceof TFBlendedNoise)) throw new IllegalArgumentException("BlendedNoise is not an instance of TFBlendedNoise");
        TFBlendedNoise blend = (TFBlendedNoise)class_58222;
        for (int index = 0; index <= max; ++index) {
            int y = index + min;
            double noise = blend.sampleAndClampNoise(x, y, z, scaleXZ, scaleY, factorXZ, factorY);
            double totaldensity = this.computeInitialDensity(y, d0, d1, density) + noise;
            totaldensity = this.caveNoiseModifier.modifyNoise(totaldensity, y * this.cellHeight, z * this.cellWidth, x * this.cellWidth);
            adouble[index] = totaldensity = this.applySlide(totaldensity, y);
        }
    }

    protected double computeInitialDensity(int y, double offset, double factor, double density) {
        double total;
        double base = 1.0 - (double)y * 2.0 / 32.0 + density;
        double factored = base * this.dimensionDensityFactor + this.dimensionDensityOffset;
        return total * (double)((total = (factored + offset) * factor) > 0.0 ? 4 : 1);
    }

    protected double applySlide(double density, int height) {
        int i = class_3532.method_15346((int)this.noiseSettings.comp_173(), (int)this.cellHeight);
        int j = height - i;
        density = this.topSlide.method_38414(density, (double)(this.cellCountY - j));
        density = this.bottomSlide.method_38414(density, (double)j);
        return density;
    }
}

