/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import io.github.fabricators_of_create.porting_lib.enchant.CustomEnchantingBehaviorItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.util.VoxelBresenhamIterator;

public class OreMagnetItem
extends class_1792
implements CustomEnchantingBehaviorItem {
    private static final float WIGGLE = 10.0f;
    private static boolean cacheNeedsBuild = true;
    private static final HashMap<class_2248, class_2248> ORE_TO_BLOCK_REPLACEMENTS = new HashMap();

    protected OreMagnetItem(class_1792.class_1793 props) {
        super(props);
    }

    public boolean method_7870(class_1799 pStack) {
        return false;
    }

    public boolean isBookEnchantable(class_1799 stack, class_1799 book) {
        Map enchants = class_1890.method_8222((class_1799)book);
        for (class_1887 ench : enchants.keySet()) {
            if (!Objects.equals(class_2378.field_11160.method_10221((Object)ench), class_2378.field_11160.method_10221((Object)class_1893.field_9119))) continue;
            return super.isBookEnchantable(stack, book);
        }
        return false;
    }

    public boolean canApplyAtEnchantingTable(class_1799 stack, class_1887 enchantment) {
        return false;
    }

    @Nonnull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @Nonnull class_1268 hand) {
        player.method_6019(hand);
        return new class_1271(class_1269.field_5812, (Object)player.method_5998(hand));
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 living, int useRemaining) {
        int useTime = this.method_7881(stack) - useRemaining;
        if (!world.field_9236 && useTime > 10) {
            int moved = this.doMagnet(world, living, 0.0f, 0.0f);
            if (moved == 0) {
                moved = this.doMagnet(world, living, 10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 0.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, -10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, -10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, -10.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 0.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 10.0f, -10.0f);
            }
            if (moved > 0) {
                stack.method_7956(moved, living, user -> user.method_20236(living.method_6058()));
                world.method_8465(null, living.method_23317(), living.method_23318(), living.method_23321(), TFSounds.MAGNET_GRAB, living.method_5634(), 1.0f, 1.0f);
            }
        }
    }

    @Nonnull
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    private int doMagnet(class_1937 world, class_1309 living, float yawOffset, float pitchOffset) {
        double range = 32.0;
        class_243 srcVec = new class_243(living.method_23317(), living.method_23318() + (double)living.method_5751(), living.method_23321());
        class_243 lookVec = this.getOffsetLook(living, yawOffset, pitchOffset);
        class_243 destVec = srcVec.method_1031(lookVec.field_1352 * range, lookVec.field_1351 * range, lookVec.field_1350 * range);
        return OreMagnetItem.doMagnet(world, new class_2338(srcVec), new class_2338(destVec));
    }

    public static int doMagnet(class_1937 world, class_2338 usePos, class_2338 destPos) {
        OreMagnetItem.initOre2BlockMap();
        int blocksMoved = 0;
        class_2680 attactedOreBlock = class_2246.field_10124.method_9564();
        class_2680 replacementBlock = class_2246.field_10124.method_9564();
        class_2338 foundPos = null;
        class_2338 basePos = null;
        for (class_2338 coord : new VoxelBresenhamIterator(usePos, destPos)) {
            class_2680 searchState = world.method_8320(coord);
            if (basePos == null) {
                if (!OreMagnetItem.isReplaceable(searchState)) continue;
                basePos = coord;
                continue;
            }
            if (foundPos != null || searchState.method_26204() == class_2246.field_10124 || !OreMagnetItem.isOre(searchState.method_26204()) || world.method_8321(coord) != null) continue;
            attactedOreBlock = searchState;
            replacementBlock = ORE_TO_BLOCK_REPLACEMENTS.getOrDefault(attactedOreBlock.method_26204(), class_2246.field_10340).method_9564();
            foundPos = coord;
        }
        if (basePos != null && foundPos != null && attactedOreBlock.method_26204() != class_2246.field_10124) {
            HashSet<class_2338> veinBlocks = new HashSet<class_2338>();
            OreMagnetItem.findVein(world, foundPos, attactedOreBlock, veinBlocks);
            int offX = basePos.method_10263() - foundPos.method_10263();
            int offY = basePos.method_10264() - foundPos.method_10264();
            int offZ = basePos.method_10260() - foundPos.method_10260();
            for (class_2338 coord : veinBlocks) {
                class_2338 replacePos = coord.method_10069(offX, offY, offZ);
                class_2680 replaceState = world.method_8320(replacePos);
                if (!OreMagnetItem.isReplaceable(replaceState) && !replaceState.method_26207().method_15800() && !replaceState.method_26215()) continue;
                world.method_8652(coord, replacementBlock, 2);
                world.method_8652(replacePos, attactedOreBlock, 2);
                ++blocksMoved;
            }
        }
        return blocksMoved;
    }

    private class_243 getOffsetLook(class_1309 living, float yawOffset, float pitchOffset) {
        float var2 = class_3532.method_15362((float)(-(living.method_36454() + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var3 = class_3532.method_15374((float)(-(living.method_36454() + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var4 = -class_3532.method_15362((float)(-(living.method_36455() + pitchOffset) * ((float)Math.PI / 180)));
        float var5 = class_3532.method_15374((float)(-(living.method_36455() + pitchOffset) * ((float)Math.PI / 180)));
        return new class_243((double)(var3 * var4), (double)var5, (double)(var2 * var4));
    }

    @Deprecated
    private static boolean isReplaceable(class_2680 state) {
        return state.method_26164(BlockTagGenerator.ORE_MAGNET_SAFE_REPLACE_BLOCK);
    }

    private static boolean findVein(class_1937 world, class_2338 here, class_2680 oreState, Set<class_2338> veinBlocks) {
        if (veinBlocks.contains(here)) {
            return false;
        }
        if (veinBlocks.size() >= 24) {
            return false;
        }
        if (world.method_8320(here) == oreState) {
            veinBlocks.add(here);
            for (class_2350 e : class_2350.values()) {
                OreMagnetItem.findVein(world, here.method_10093(e), oreState, veinBlocks);
            }
            return true;
        }
        return false;
    }

    private static boolean isOre(class_2248 ore) {
        return ORE_TO_BLOCK_REPLACEMENTS.containsKey(ore);
    }

    private static void initOre2BlockMap() {
        if (!cacheNeedsBuild) {
            return;
        }
        TwilightForestMod.LOGGER.info("GENERATING ORE TO BLOCK MAPPING");
        for (class_6862 tag : class_2378.field_11146.method_40273().filter(location -> location.comp_327().method_12836().equals("c")).collect(Collectors.toList())) {
            if (!tag.comp_327().method_12832().contains("ores_in_ground/")) continue;
            String oreground = tag.comp_327().method_12832().substring(15);
            if (!class_2378.field_11146.method_40273().filter(location -> location.comp_327().method_12836().equals("c")).anyMatch(blockTagKey -> blockTagKey.comp_327().method_12832().equals("ore_bearing_ground/" + oreground))) continue;
            ((class_6885.class_6888)Objects.requireNonNull(class_2378.field_11146.method_40266(class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)new class_2960("c", "ore_bearing_ground/" + oreground)))).get()).forEach(groundHolder -> ((class_6885.class_6888)Objects.requireNonNull(class_2378.field_11146.method_40266(tag)).get()).forEach(oreHolder -> {
                if (!oreHolder.method_40220(BlockTagGenerator.ORE_MAGNET_IGNORE)) {
                    ORE_TO_BLOCK_REPLACEMENTS.put((class_2248)oreHolder.comp_349(), (class_2248)groundHolder.comp_349());
                }
            }));
        }
        cacheNeedsBuild = false;
    }

    public static void buildOreMagnetCache() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new IdentifiableResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("twilightforest", "ore_magnet");
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                if (!cacheNeedsBuild) {
                    ORE_TO_BLOCK_REPLACEMENTS.clear();
                    cacheNeedsBuild = true;
                }
                return stage.method_18352(null).thenRun(() -> {});
            }
        });
    }
}

