/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import io.github.fabricators_of_create.porting_lib.entity.MultiPartEntity;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2610;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5532;
import twilightforest.TFSounds;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.block.TwilightChest;
import twilightforest.entity.TFPart;
import twilightforest.entity.boss.NagaSegment;
import twilightforest.loot.TFTreasure;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.ThrowPlayerPacket;
import twilightforest.util.EntityUtil;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TFGenerationSettings;

public class Naga
extends class_1588
implements MultiPartEntity {
    private static final int TICKS_BEFORE_HEALING = 600;
    private static final int MAX_SEGMENTS = 12;
    private static final int LEASH_X = 46;
    private static final int LEASH_Y = 7;
    private static final int LEASH_Z = 46;
    private static final double DEFAULT_SPEED = 0.3;
    private int currentSegmentCount = 0;
    private final float healthPerSegment;
    private final NagaSegment[] bodySegments = new NagaSegment[12];
    private AIMovementPattern movementAI;
    private int ticksSinceDamaged = 0;
    private final List<class_3222> hurtBy = new ArrayList<class_3222>();
    private final class_3213 bossInfo = new class_3213(this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5791);
    private final class_1322 slowSpeed = new class_1322("Naga Slow Speed", 0.25, class_1322.class_1323.field_6328);
    private final class_1322 fastSpeed = new class_1322("Naga Fast Speed", 0.5, class_1322.class_1323.field_6328);
    private static final class_2940<Boolean> DATA_DAZE = class_2945.method_12791(Naga.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_CHARGE = class_2945.method_12791(Naga.class, (class_2941)class_2943.field_13323);

    public Naga(class_1299<? extends Naga> type, class_1937 world) {
        super(type, world);
        this.field_6013 = 2.0f;
        this.healthPerSegment = this.method_6063() / 10.0f;
        this.field_6194 = 217;
        this.field_5985 = true;
        for (int i = 0; i < this.bodySegments.length; ++i) {
            this.bodySegments[i] = new NagaSegment(this);
        }
        this.goNormal();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_DAZE, (Object)false);
        this.field_6011.method_12784(DATA_CHARGE, (Object)false);
    }

    public boolean isDazed() {
        return (Boolean)this.field_6011.method_12789(DATA_DAZE);
    }

    protected void setDazed(boolean daze) {
        this.field_6011.method_12778(DATA_DAZE, (Object)daze);
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(DATA_CHARGE);
    }

    protected void setCharging(boolean charge) {
        this.field_6011.method_12778(DATA_CHARGE, (Object)charge);
    }

    private float getMaxHealthPerDifficulty() {
        return switch (this.field_6002.method_8407()) {
            case class_1267.field_5805 -> 120.0f;
            case class_1267.field_5807 -> 250.0f;
            default -> 200.0f;
        };
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    public boolean method_5974(double p_213397_1_) {
        return false;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new AIAttack(this));
        this.field_6201.method_6277(3, (class_1352)new AISmash(this));
        this.movementAI = new AIMovementPattern(this);
        this.field_6201.method_6277(4, (class_1352)this.movementAI);
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 1.0, 1){

            public void method_6269() {
                Naga.this.goNormal();
                super.method_6269();
            }

            protected class_243 method_6302() {
                return class_5532.method_31510((class_1314)this.field_6566, (int)30, (int)7);
            }
        });
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
        this.field_6207 = new NagaMoveHelper((class_1308)this);
    }

    public void method_6007() {
        int maxz;
        int maxy;
        int maxx;
        class_2338 max;
        int minz;
        int miny;
        super.method_6007();
        if (this.field_6002.field_9236 || !this.field_6002.method_8450().method_8355(class_1928.field_19388)) {
            return;
        }
        class_238 bb = this.method_5829();
        int minx = class_3532.method_15357((double)(bb.field_1323 - 0.75));
        class_2338 min = new class_2338(minx, miny = class_3532.method_15357((double)(bb.field_1322 + 1.01)), minz = class_3532.method_15357((double)(bb.field_1321 - 0.75)));
        if (this.field_6002.method_22343(min, max = new class_2338(maxx = class_3532.method_15357((double)(bb.field_1320 + 0.75)), maxy = class_3532.method_15357((double)(bb.field_1325 + 0.0)), maxz = class_3532.method_15357((double)(bb.field_1324 + 0.75))))) {
            for (class_2338 pos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
                class_2680 state = this.field_6002.method_8320(pos);
                if (state.method_26207() != class_3614.field_15923 || !EntityUtil.canDestroyBlock(this.field_6002, pos, state, (class_1297)this)) continue;
                this.field_6002.method_22352(pos, true);
            }
        }
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 200.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23717, 80.0);
    }

    private void setSegmentsPerHealth() {
        int newSegments;
        int oldSegments = this.currentSegmentCount;
        this.currentSegmentCount = newSegments = class_3532.method_15340((int)((int)(this.method_6032() / this.healthPerSegment + (float)(this.method_6032() > 0.0f ? 2 : 0))), (int)0, (int)12);
        if (newSegments < oldSegments) {
            for (int i = newSegments; i < oldSegments; ++i) {
                this.bodySegments[i].selfDestruct();
            }
        } else if (newSegments > oldSegments) {
            this.activateBodySegments();
        }
        if (!this.field_6002.field_9236) {
            double newSpeed = 0.3 - (double)((float)newSegments * -0.016666668f);
            if (newSpeed < 0.0) {
                newSpeed = 0.0;
            }
            this.method_5996(class_5134.field_23719).method_6192(newSpeed);
        }
    }

    public boolean method_21749() {
        return false;
    }

    public boolean method_5771() {
        return false;
    }

    public void method_5773() {
        if (this.field_6213 > 0) {
            for (int k = 0; k < 5; ++k) {
                double d = this.field_5974.nextGaussian() * 0.02;
                double d1 = this.field_5974.nextGaussian() * 0.02;
                double d2 = this.field_5974.nextGaussian() * 0.02;
                this.field_6002.method_8406((class_2394)(this.field_5974.nextBoolean() ? class_2398.field_11221 : class_2398.field_11236), this.method_23317() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.field_5974.nextFloat() * this.method_17682()), this.method_23321() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), d, d1, d2);
            }
        }
        ++this.ticksSinceDamaged;
        if (!this.field_6002.field_9236 && this.ticksSinceDamaged > 600 && this.ticksSinceDamaged % 20 == 0) {
            this.method_6025(1.0f);
        }
        this.setSegmentsPerHealth();
        super.method_5773();
        this.moveSegments();
    }

    protected void method_5958() {
        class_243 vec3d;
        super.method_5958();
        if (this.method_5968() != null && (this.method_5858((class_1297)this.method_5968()) > 6400.0 || !this.isEntityWithinHomeArea((class_1297)this.method_5968()))) {
            this.method_5980(null);
        }
        double d = this.method_17681() * 4.0f;
        class_243 class_2432 = vec3d = this.method_6150() ? this.method_5942().method_6345().method_49((class_1297)this) : null;
        while (vec3d != null && vec3d.method_1028(this.method_23317(), vec3d.field_1351, this.method_23321()) < d * d) {
            this.method_5942().method_6345().method_44();
            if (this.method_5942().method_6345().method_46()) {
                vec3d = null;
                continue;
            }
            vec3d = this.method_5942().method_6345().method_49((class_1297)this);
        }
        if (!this.method_18411()) {
            this.method_5980(null);
            this.method_5942().method_6334(this.method_5942().method_6348(this.method_18412(), 0), 1.0);
        }
        this.bossInfo.method_5408(this.method_6032() / this.method_6063());
    }

    protected class_3414 method_5994() {
        return TFSounds.NAGA_HISS;
    }

    protected class_3414 method_6011(class_1282 source) {
        return TFSounds.NAGA_HURT;
    }

    protected class_3414 method_6002() {
        return TFSounds.NAGA_HURT;
    }

    private void crumbleBelowTarget(int range) {
        if (!this.field_6002.method_8450().method_8355(class_1928.field_19388)) {
            return;
        }
        int targetY = (int)this.method_5968().method_5829().field_1322;
        int floor = (int)this.method_5829().field_1322;
        if (targetY > floor) {
            class_2338 pos;
            int dx = (int)this.method_5968().method_23317() + this.field_5974.nextInt(range) - this.field_5974.nextInt(range);
            int dz = (int)this.method_5968().method_23321() + this.field_5974.nextInt(range) - this.field_5974.nextInt(range);
            int dy = targetY - this.field_5974.nextInt(range) + this.field_5974.nextInt(range > 1 ? range - 1 : range);
            if (dy <= floor) {
                dy = targetY;
            }
            if (EntityUtil.canDestroyBlock(this.field_6002, pos = new class_2338(dx, dy, dz), (class_1297)this)) {
                this.field_6002.method_22352(pos, true);
                for (int k = 0; k < 20; ++k) {
                    double d = this.field_5974.nextGaussian() * 0.02;
                    double d1 = this.field_5974.nextGaussian() * 0.02;
                    double d2 = this.field_5974.nextGaussian() * 0.02;
                    this.field_6002.method_8406((class_2394)class_2398.field_11205, this.method_23317() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.field_5974.nextFloat() * this.method_17682()), this.method_23321() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), d, d1, d2);
                }
            }
        }
    }

    private void goSlow() {
        this.method_5996(class_5134.field_23719).method_6202(this.slowSpeed);
        this.method_5996(class_5134.field_23719).method_6202(this.fastSpeed);
        this.method_5996(class_5134.field_23719).method_26835(this.slowSpeed);
    }

    private void goNormal() {
        this.method_5996(class_5134.field_23719).method_6202(this.slowSpeed);
        this.method_5996(class_5134.field_23719).method_6202(this.fastSpeed);
    }

    private void goFast() {
        this.method_5996(class_5134.field_23719).method_6202(this.slowSpeed);
        this.method_5996(class_5134.field_23719).method_6202(this.fastSpeed);
        this.method_5996(class_5134.field_23719).method_26835(this.fastSpeed);
    }

    public boolean method_5810() {
        return false;
    }

    private class_2338 findCirclePoint(boolean clockwise, double radius, double rotation) {
        class_1309 toCircle = this.method_5968();
        double vecx = this.method_23317() - toCircle.method_23317();
        double vecz = this.method_23321() - toCircle.method_23321();
        float rangle = (float)Math.atan2(vecz, vecx);
        rangle = (float)((double)rangle + (clockwise ? rotation : -rotation));
        double dx = (double)class_3532.method_15362((float)rangle) * radius;
        double dz = (double)class_3532.method_15374((float)rangle) * radius;
        double dy = Math.min(this.method_5829().field_1322, toCircle.method_23318());
        return new class_2338(toCircle.method_23317() + dx, dy, toCircle.method_23321() + dz);
    }

    public boolean method_5679(class_1282 src) {
        return src.method_5529() != null && !this.isEntityWithinHomeArea(src.method_5529()) || src.method_5526() != null && !this.isEntityWithinHomeArea(src.method_5526()) || src.method_5534() || src.method_5535() || super.method_5679(src);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source != class_1282.field_5868 && super.method_5643(source, amount)) {
            class_3222 player;
            this.ticksSinceDamaged = 0;
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_3222 && !this.hurtBy.contains(player = (class_3222)class_12972)) {
                this.hurtBy.add(player);
            }
            return true;
        }
        return false;
    }

    public boolean method_6121(class_1297 toAttack) {
        if (this.movementAI.movementState == MovementState.CHARGE && toAttack instanceof class_1309 && ((class_1309)toAttack).method_6039()) {
            class_243 motion = this.method_18798();
            toAttack.method_5762(motion.field_1352 * 1.25, 0.5, motion.field_1350 * 1.25);
            this.method_18800(motion.field_1352 * -1.5, motion.field_1351 + 0.5, motion.field_1350 * -1.5);
            if (toAttack instanceof class_3222) {
                TFPacketHandler.CHANNEL.sendToClient((S2CPacket)new ThrowPlayerPacket((float)toAttack.method_18798().method_10216(), (float)toAttack.method_18798().method_10214(), (float)toAttack.method_18798().method_10215()), (class_3222)toAttack);
            }
            this.method_5643(class_1282.field_5869, 4.0f);
            this.field_6002.method_8396(null, toAttack.method_24515(), class_3417.field_15150, class_3419.field_15248, 1.0f, 0.8f + this.field_6002.field_9229.nextFloat() * 0.4f);
            this.movementAI.doDaze();
            return false;
        }
        if (!this.isDazed()) {
            boolean result = super.method_6121(toAttack);
            if (result) {
                toAttack.method_5762((double)(-class_3532.method_15374((float)(this.method_36454() * 3.141593f / 180.0f)) * 2.0f), (double)0.4f, (double)(class_3532.method_15362((float)(this.method_36454() * 3.141593f / 180.0f)) * 2.0f));
            }
            return result;
        }
        return false;
    }

    public float method_6149(class_2338 pos) {
        if (!this.method_18407(pos)) {
            return Float.MIN_VALUE;
        }
        return 0.0f;
    }

    public void method_5982() {
        if (this.field_6002.method_8407() == class_1267.field_5801) {
            if (this.method_18412() != class_2338.field_10980) {
                this.field_6002.method_8501(this.method_18412(), ((class_2248)TFBlocks.NAGA_BOSS_SPAWNER.get()).method_9564());
            }
            this.method_31472();
        } else {
            super.method_5982();
        }
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        if (this.field_6002 instanceof class_3218) {
            for (NagaSegment seg : this.bodySegments) {
                seg.method_5650(class_1297.class_5529.field_26998);
            }
        }
    }

    public boolean method_18407(class_2338 pos) {
        if (this.method_18413() == -1.0f) {
            return true;
        }
        int distX = Math.abs(this.method_18412().method_10263() - pos.method_10263());
        int distY = Math.abs(this.method_18412().method_10264() - pos.method_10264());
        int distZ = Math.abs(this.method_18412().method_10260() - pos.method_10260());
        return distX <= 46 && distY <= 7 && distZ <= 46;
    }

    private boolean isEntityWithinHomeArea(class_1297 entity) {
        return this.method_18407(entity.method_24515());
    }

    private void activateBodySegments() {
        for (int i = 0; i < this.currentSegmentCount; ++i) {
            NagaSegment segment = this.bodySegments[i];
            segment.activate();
            segment.method_5808(this.method_23317() + 0.1 * (double)i, this.method_23318() + 0.5, this.method_23321() + 0.1 * (double)i, this.field_5974.nextFloat() * 360.0f, 0.0f);
            for (int j = 0; j < 20; ++j) {
                double d0 = this.field_5974.nextGaussian() * 0.02;
                double d1 = this.field_5974.nextGaussian() * 0.02;
                double d2 = this.field_5974.nextGaussian() * 0.02;
                this.field_6002.method_8406((class_2394)class_2398.field_11236, segment.method_23317() + (double)(this.field_5974.nextFloat() * segment.method_17681() * 2.0f) - (double)segment.method_17681() - d0 * 10.0, segment.method_23318() + (double)(this.field_5974.nextFloat() * segment.method_17682()) - d1 * 10.0, segment.method_23321() + (double)(this.field_5974.nextFloat() * segment.method_17681() * 2.0f) - (double)segment.method_17681() - d2 * 10.0, d0, d1, d2);
            }
        }
    }

    private void moveSegments() {
        for (int i = 0; i < this.bodySegments.length; ++i) {
            this.bodySegments[i].method_5773();
            Naga leader = i == 0 ? this : this.bodySegments[i - 1];
            double followX = leader.method_23317();
            double followY = leader.method_23318();
            double followZ = leader.method_23321();
            float angle = (leader.method_36454() + 180.0f) * 3.141593f / 180.0f;
            double straightenForce = 0.05 + 1.0 / (double)(i + 1) * 0.5;
            double idealX = (double)(-class_3532.method_15374((float)angle)) * straightenForce;
            double idealZ = (double)class_3532.method_15362((float)angle) * straightenForce;
            double groundY = this.bodySegments[i].method_5757() ? followY + 2.0 : followY;
            double idealY = (groundY - followY) * straightenForce;
            class_243 diff = new class_243(this.bodySegments[i].method_23317() - followX, this.bodySegments[i].method_23318() - followY, this.bodySegments[i].method_23321() - followZ);
            diff = diff.method_1029();
            diff = diff.method_1031(idealX, idealY, idealZ).method_1029();
            double f = 2.0;
            double destX = followX + f * diff.field_1352;
            double destY = followY + f * diff.field_1351;
            double destZ = followZ + f * diff.field_1350;
            this.bodySegments[i].method_5814(destX, destY, destZ);
            double distance = class_3532.method_15355((float)((float)(diff.field_1352 * diff.field_1352 + diff.field_1350 * diff.field_1350)));
            if (i == 0) {
                diff = diff.method_1031(0.0, -0.15, 0.0);
            }
            this.bodySegments[i].method_5710((float)(Math.atan2(diff.field_1350, diff.field_1352) * 180.0 / Math.PI) + 90.0f, -((float)(Math.atan2(diff.field_1351, distance) * 180.0 / Math.PI)));
        }
    }

    public void method_5652(class_2487 compound) {
        if (this.method_18412() != class_2338.field_10980) {
            class_2338 home = this.method_18412();
            compound.method_10566("Home", (class_2520)new class_2495(new int[]{home.method_10263(), home.method_10264(), home.method_10260()}));
        }
        super.method_5652(compound);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("Home", 11)) {
            int[] home = compound.method_10561("Home");
            this.method_18408(new class_2338(home[0], home[1], home[2]), 20);
        } else {
            this.method_18410();
        }
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        if (!this.field_6002.field_9236) {
            TFGenerationSettings.markStructureConquered(this.field_6002, new class_2338((class_2382)this.method_24515()), TFFeature.NAGA_COURTYARD);
            for (class_3222 player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
            }
            TFTreasure.entityDropsIntoContainer((class_1309)this, this.method_16079(true, cause).method_309(class_173.field_1173), this.field_5974.nextBoolean() ? ((TwilightChest)((Object)TFBlocks.TWILIGHT_OAK_CHEST.get())).method_9564() : ((TwilightChest)((Object)TFBlocks.CANOPY_CHEST.get())).method_9564(), EntityUtil.bossChestLocation((class_1308)this));
        }
    }

    protected boolean method_27071() {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public void method_33579(class_2610 p_147206_) {
        super.method_33579(p_147206_);
        TFPart.assignPartIDs((class_1297)this);
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return this.bodySegments;
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossInfo.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    protected boolean method_5860(class_1297 entityIn) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected float method_6120() {
        return 1.0f;
    }

    public boolean method_5822() {
        return false;
    }

    static class AIAttack
    extends class_1352 {
        private final Naga taskOwner;
        private int attackTick = 20;

        AIAttack(Naga taskOwner) {
            this.taskOwner = taskOwner;
        }

        public boolean method_6264() {
            class_1309 target = this.taskOwner.method_5968();
            return target != null && target.method_5829().field_1325 > this.taskOwner.method_5829().field_1322 - 2.5 && target.method_5829().field_1322 < this.taskOwner.method_5829().field_1325 + 2.5 && this.taskOwner.method_5858((class_1297)target) <= 4.0 && this.taskOwner.method_5985().method_6369((class_1297)target);
        }

        public void method_6268() {
            if (this.attackTick > 0) {
                --this.attackTick;
            }
        }

        public void method_6270() {
            this.attackTick = 20;
        }

        public void method_6269() {
            this.taskOwner.method_6121((class_1297)this.taskOwner.method_5968());
            this.attackTick = 20;
        }
    }

    static class AISmash
    extends class_1352 {
        private final Naga taskOwner;

        AISmash(Naga taskOwner) {
            this.taskOwner = taskOwner;
        }

        public boolean method_6264() {
            return this.taskOwner.field_5976 && this.taskOwner.field_6002.method_8450().method_8355(class_1928.field_19388);
        }

        public void method_6269() {
            int maxz;
            int maxy;
            int maxx;
            class_2338 max;
            int minz;
            int miny;
            if (this.taskOwner.field_6002.field_9236) {
                return;
            }
            class_238 bb = this.taskOwner.method_5829();
            int minx = class_3532.method_15357((double)(bb.field_1323 - 0.75));
            class_2338 min = new class_2338(minx, miny = class_3532.method_15357((double)(bb.field_1322 + 1.01)), minz = class_3532.method_15357((double)(bb.field_1321 - 0.75)));
            if (this.taskOwner.field_6002.method_22343(min, max = new class_2338(maxx = class_3532.method_15357((double)(bb.field_1320 + 0.75)), maxy = class_3532.method_15357((double)(bb.field_1325 + 0.0)), maxz = class_3532.method_15357((double)(bb.field_1324 + 0.75))))) {
                for (class_2338 pos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
                    if (!EntityUtil.canDestroyBlock(this.taskOwner.field_6002, pos, (class_1297)this.taskOwner)) continue;
                    this.taskOwner.field_6002.method_22352(pos, true);
                }
            }
        }
    }

    static class AIMovementPattern
    extends class_1352 {
        private final Naga taskOwner;
        private MovementState movementState;
        private int stateCounter;
        private boolean clockwise;

        AIMovementPattern(Naga taskOwner) {
            this.taskOwner = taskOwner;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            this.method_6270();
        }

        public boolean method_6264() {
            return this.taskOwner.method_5968() != null;
        }

        public void method_6270() {
            this.movementState = MovementState.CIRCLE;
            this.stateCounter = 15;
            this.clockwise = false;
        }

        public void method_6268() {
            if (!this.taskOwner.method_5942().method_6357()) {
                this.taskOwner.setDazed(false);
                return;
            }
            switch (this.movementState) {
                case INTIMIDATE: {
                    this.taskOwner.method_5942().method_6340();
                    this.taskOwner.method_5988().method_6226((class_1297)this.taskOwner.method_5968(), 30.0f, 30.0f);
                    this.taskOwner.method_5951((class_1297)this.taskOwner.method_5968(), 30.0f, 30.0f);
                    this.taskOwner.field_6250 = 0.1f;
                    break;
                }
                case CRUMBLE: {
                    this.taskOwner.method_5942().method_6340();
                    this.taskOwner.crumbleBelowTarget(2);
                    this.taskOwner.crumbleBelowTarget(3);
                    break;
                }
                case CHARGE: {
                    class_2338 tpoint = this.taskOwner.findCirclePoint(this.clockwise, 14.0, Math.PI);
                    this.taskOwner.method_5942().method_6337((double)tpoint.method_10263(), (double)tpoint.method_10264(), (double)tpoint.method_10260(), 1.0);
                    this.taskOwner.setCharging(true);
                    break;
                }
                case CIRCLE: {
                    double radius = this.stateCounter % 2 == 0 ? 12.0 : 14.0;
                    double rotation = 1.0;
                    if (this.stateCounter == 2) {
                        radius = 16.0;
                    }
                    if (this.stateCounter == 1) {
                        rotation = 0.1;
                    }
                    class_2338 tpoint = this.taskOwner.findCirclePoint(this.clockwise, radius, rotation);
                    this.taskOwner.method_5942().method_6337((double)tpoint.method_10263(), (double)tpoint.method_10264(), (double)tpoint.method_10260(), 1.0);
                    break;
                }
                case DAZE: {
                    this.taskOwner.setDazed(true);
                    this.taskOwner.setCharging(false);
                }
            }
            --this.stateCounter;
            if (this.stateCounter <= 0) {
                this.transitionState();
            }
        }

        private void transitionState() {
            this.taskOwner.setDazed(false);
            this.taskOwner.setCharging(false);
            switch (this.movementState) {
                case INTIMIDATE: {
                    boolean bl = this.clockwise = !this.clockwise;
                    if (this.taskOwner.method_5968().method_5829().field_1322 > this.taskOwner.method_5829().field_1325) {
                        this.doCrumblePlayer();
                        break;
                    }
                    this.doCharge();
                    break;
                }
                case CRUMBLE: {
                    this.doCharge();
                    break;
                }
                case CHARGE: 
                case DAZE: {
                    this.doCircle();
                    break;
                }
                case CIRCLE: {
                    this.doIntimidate();
                }
            }
        }

        private void doDaze() {
            this.movementState = MovementState.DAZE;
            this.taskOwner.method_5942().method_6340();
            this.stateCounter = 60 + this.taskOwner.field_5974.nextInt(40);
        }

        private void doCircle() {
            this.movementState = MovementState.CIRCLE;
            this.stateCounter += 10 + this.taskOwner.field_5974.nextInt(10);
            this.taskOwner.goNormal();
        }

        private void doCrumblePlayer() {
            this.movementState = MovementState.CRUMBLE;
            this.stateCounter = 20 + this.taskOwner.field_5974.nextInt(20);
            this.taskOwner.goSlow();
        }

        private void doCharge() {
            this.movementState = MovementState.CHARGE;
            this.stateCounter = 3;
            this.taskOwner.goFast();
        }

        private void doIntimidate() {
            this.movementState = MovementState.INTIMIDATE;
            this.taskOwner.method_5783(TFSounds.NAGA_RATTLE, this.taskOwner.method_6107() * 4.0f, this.taskOwner.method_6017());
            this.stateCounter += 15 + this.taskOwner.field_5974.nextInt(10);
            this.taskOwner.goSlow();
        }
    }

    static class NagaMoveHelper
    extends class_1335 {
        public NagaMoveHelper(class_1308 naga) {
            super(naga);
        }

        public void method_6240() {
            MovementState currentState = ((Naga)this.field_6371).movementAI.movementState;
            this.field_6371.field_6212 = currentState == MovementState.DAZE ? 0.0f : (currentState != MovementState.CHARGE && currentState != MovementState.INTIMIDATE ? class_3532.method_15362((float)((float)this.field_6371.field_6012 * 0.3f)) * 0.6f : (this.field_6371.field_6212 *= 0.8f));
            super.method_6240();
        }
    }

    static enum MovementState {
        INTIMIDATE,
        CRUMBLE,
        CHARGE,
        CIRCLE,
        DAZE;

    }
}

