/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import io.github.fabricators_of_create.porting_lib.mixin.common.accessor.MobAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import twilightforest.TFSounds;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.entity.NoClipMoveHelper;
import twilightforest.entity.ai.PhantomAttackStartGoal;
import twilightforest.entity.ai.PhantomThrowWeaponGoal;
import twilightforest.entity.ai.PhantomUpdateFormationAndMoveGoal;
import twilightforest.entity.ai.PhantomWatchAndAttackGoal;
import twilightforest.item.TFItems;
import twilightforest.loot.TFTreasure;
import twilightforest.util.TFDamageSources;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TFGenerationSettings;

public class KnightPhantom
extends class_1307
implements class_1569 {
    private static final class_2940<Boolean> FLAG_CHARGING = class_2945.method_12791(KnightPhantom.class, (class_2941)class_2943.field_13323);
    private static final class_1322 CHARGING_MODIFIER = new class_1322("Charging attack boost", 7.0, class_1322.class_1323.field_6328);
    private int number;
    private int ticksProgress;
    private Formation currentFormation;
    private class_2338 chargePos = class_2338.field_10980;
    private final List<class_3222> hurtBy = new ArrayList<class_3222>();
    private class_2338 homePosition = class_2338.field_10980;
    private float maximumHomeDistance = -1.0f;

    public KnightPhantom(class_1299<? extends KnightPhantom> type, class_1937 world) {
        super(type, world);
        this.field_5960 = true;
        this.method_5753();
        this.currentFormation = Formation.HOVER;
        this.field_6194 = 93;
        this.field_6207 = new NoClipMoveHelper((class_1308)this);
    }

    @Nullable
    public class_1315 method_5943(class_5425 worldIn, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnDataIn, @Nullable class_2487 dataTag) {
        class_1315 data = super.method_5943(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.method_5964(difficulty);
        this.method_5984(difficulty);
        return data;
    }

    protected void method_5964(class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_SWORD.get()));
        this.method_5673(class_1304.field_6174, new class_1799((class_1935)TFItems.PHANTOM_CHESTPLATE.get()));
        this.method_5673(class_1304.field_6169, new class_1799((class_1935)TFItems.PHANTOM_HELMET.get()));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FLAG_CHARGING, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new PhantomWatchAndAttackGoal(this));
        this.field_6201.method_6277(1, (class_1352)new PhantomUpdateFormationAndMoveGoal(this));
        this.field_6201.method_6277(2, (class_1352)new PhantomAttackStartGoal(this));
        this.field_6201.method_6277(3, (class_1352)new PhantomThrowWeaponGoal(this));
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
    }

    public static class_5132.class_5133 registerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 35.0).method_26868(class_5134.field_23721, 1.0);
    }

    public Formation getCurrentFormation() {
        return this.currentFormation;
    }

    public class_2338 getChargePos() {
        return this.chargePos;
    }

    public void setChargePos(class_2338 pos) {
        this.chargePos = pos;
    }

    public boolean method_5974(double p_213397_1_) {
        return false;
    }

    public boolean method_5679(class_1282 src) {
        return src == class_1282.field_5855 || super.method_5679(src);
    }

    public void method_5982() {
        if (this.field_6002.method_8407() == class_1267.field_5801) {
            if (this.hasHome() && this.getNumber() == 0) {
                this.field_6002.method_8501(this.method_18412(), ((class_2248)TFBlocks.KNIGHT_PHANTOM_BOSS_SPAWNER.get()).method_9564());
            }
            this.method_31472();
        } else {
            super.method_5982();
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.isChargingAtPlayer()) {
            for (int i = 0; i < 4; ++i) {
                class_1792 particleID = this.field_5974.nextBoolean() ? (class_1792)TFItems.PHANTOM_HELMET.get() : (class_1792)TFItems.KNIGHTMETAL_SWORD.get();
                this.field_6002.method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)particleID)), this.method_23317() + ((double)this.field_5974.nextFloat() - 0.5) * (double)this.method_17681(), this.method_23318() + (double)this.field_5974.nextFloat() * ((double)this.method_17682() - 0.75) + 0.5, this.method_23321() + ((double)this.field_5974.nextFloat() - 0.5) * (double)this.method_17681(), 0.0, -0.1, 0.0);
                this.field_6002.method_8406((class_2394)class_2398.field_11251, this.method_23317() + ((double)this.field_5974.nextFloat() - 0.5) * (double)this.method_17681(), this.method_23318() + (double)this.field_5974.nextFloat() * ((double)this.method_17682() - 0.75) + 0.5, this.method_23321() + ((double)this.field_5974.nextFloat() - 0.5) * (double)this.method_17681(), 0.0, 0.1, 0.0);
            }
        }
    }

    protected void method_6108() {
        super.method_6108();
        for (int i = 0; i < 20; ++i) {
            double d0 = this.field_5974.nextGaussian() * 0.02;
            double d1 = this.field_5974.nextGaussian() * 0.02;
            double d2 = this.field_5974.nextGaussian() * 0.02;
            this.field_6002.method_8406((class_2394)class_2398.field_11236, this.method_23317() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.field_5974.nextFloat() * this.method_17682()), this.method_23321() + (double)(this.field_5974.nextFloat() * this.method_17681() * 2.0f) - (double)this.method_17681(), d0, d1, d2);
        }
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.getNearbyKnights().isEmpty() && cause != class_1282.field_5849) {
                class_2338 treasurePos = this.hasHome() ? this.method_18412().method_10074() : new class_2338((class_2382)this.method_24515());
                TFTreasure.STRONGHOLD_BOSS.generateChest((class_5281)serverLevel, treasurePos, class_2350.field_11043, false);
                class_1297 class_12972 = cause.method_5529();
                if (class_12972 instanceof class_3222) {
                    class_3222 player = (class_3222)class_12972;
                    TFAdvancements.KILL_ALL_PHANTOMS.trigger(player);
                }
                TFGenerationSettings.markStructureConquered(this.field_6002, treasurePos, TFFeature.KNIGHT_STRONGHOLD);
                for (class_3222 player : this.hurtBy) {
                    TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
                }
                for (class_3222 player : this.field_6002.method_18467(class_3222.class, new class_238(this.homePosition).method_1014(10.0))) {
                    TFAdvancements.HURT_BOSS.trigger(player, (class_1297)this);
                }
            }
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_3222 player;
        class_1297 class_12972;
        if (this.method_6061(source)) {
            this.method_5783(class_3417.field_15150, 1.0f, 0.8f + this.field_6002.field_9229.nextFloat() * 0.4f);
        }
        if ((class_12972 = source.method_5529()) instanceof class_3222 && !this.hurtBy.contains(player = (class_3222)class_12972)) {
            this.hurtBy.add(player);
        }
        return super.method_5643(source, amount);
    }

    public boolean method_6121(class_1297 entity) {
        boolean flag;
        int i;
        float f = (float)this.method_26825(class_5134.field_23721);
        float f1 = (float)this.method_26825(class_5134.field_23722);
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            f += class_1890.method_8218((class_1799)this.method_6047(), (class_1310)living.method_6046());
            f1 += (float)class_1890.method_8205((class_1309)this);
        }
        if ((i = class_1890.method_8199((class_1309)this)) > 0) {
            entity.method_5639(i * 4);
        }
        if (flag = entity.method_5643(TFDamageSources.haunt((class_1309)this), f)) {
            if (f1 > 0.0f && entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                living.method_6005((double)(f1 * 0.5f), (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
                this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
            }
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                ((MobAccessor)this).port_lib$maybeDisableShield(player, this.method_6047(), player.method_6115() ? player.method_6030() : class_1799.field_8037);
            }
            this.method_5723((class_1309)this, entity);
            this.method_6114(entity);
        }
        return flag;
    }

    public boolean method_5810() {
        return true;
    }

    public void method_6005(double damage, double xRatio, double zRatio) {
        this.field_6007 = true;
        float f = class_3532.method_15355((float)((float)(xRatio * xRatio + zRatio * zRatio)));
        float distance = 0.2f;
        this.method_18799(new class_243(this.method_18798().method_10216() / 2.0, this.method_18798().method_10214() / 2.0, this.method_18798().method_10215() / 2.0));
        this.method_18799(new class_243(this.method_18798().method_10216() - xRatio / (double)f * (double)distance, this.method_18798().method_10214() + (double)distance, this.method_18798().method_10215() - zRatio / (double)f * (double)distance));
        if (this.method_18798().method_10214() > (double)0.4f) {
            this.method_18800(this.method_18798().method_10216(), 0.4f, this.method_18798().method_10215());
        }
    }

    public List<KnightPhantom> getNearbyKnights() {
        return this.field_6002.method_8390(KnightPhantom.class, new class_238(this.method_23317(), this.method_23318(), this.method_23321(), this.method_23317() + 1.0, this.method_23318() + 1.0, this.method_23321() + 1.0).method_1009(32.0, 8.0, 32.0), class_1309::method_5805);
    }

    private void updateMyNumber() {
        ArrayList nums = Lists.newArrayList();
        List<KnightPhantom> knights = this.getNearbyKnights();
        for (KnightPhantom knight : knights) {
            if (knight == this) continue;
            nums.add(knight.getNumber());
            if (knight.getNumber() != 0) continue;
            this.method_18408(knight.method_18412(), 20);
        }
        if (nums.isEmpty()) {
            return;
        }
        int[] n = Ints.toArray((Collection)nums);
        Arrays.sort(n);
        int smallest = n[0];
        int largest = knights.size() + 1;
        int smallestUnused = largest + 1;
        if (smallest > 0) {
            smallestUnused = 0;
        } else {
            for (int i = 1; i < largest; ++i) {
                if (Arrays.binarySearch(n, i) >= 0) continue;
                smallestUnused = i;
                break;
            }
        }
        if (this.number > smallestUnused || nums.contains(this.number)) {
            this.setNumber(smallestUnused);
        }
    }

    public boolean isChargingAtPlayer() {
        return (Boolean)this.field_6011.method_12789(FLAG_CHARGING);
    }

    private void setChargingAtPlayer(boolean flag) {
        this.field_6011.method_12778(FLAG_CHARGING, (Object)flag);
        if (!this.field_6002.field_9236) {
            if (flag) {
                if (!this.method_5996(class_5134.field_23721).method_6196(CHARGING_MODIFIER)) {
                    this.method_5996(class_5134.field_23721).method_26835(CHARGING_MODIFIER);
                }
            } else {
                this.method_5996(class_5134.field_23721).method_6202(CHARGING_MODIFIER);
            }
        }
    }

    protected class_3414 method_5994() {
        return TFSounds.PHANTOM_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return TFSounds.PHANTOM_HURT;
    }

    protected class_3414 method_6002() {
        return TFSounds.PHANTOM_DEATH;
    }

    private void switchToFormationByNumber(int formationNumber) {
        this.currentFormation = Formation.values()[formationNumber];
        this.ticksProgress = 0;
    }

    public void switchToFormation(Formation formation) {
        this.currentFormation = formation;
        this.ticksProgress = 0;
        this.updateMyNumber();
        this.setChargingAtPlayer(this.currentFormation == Formation.ATTACK_PLAYER_START || this.currentFormation == Formation.ATTACK_PLAYER_ATTACK);
    }

    private int getFormationAsNumber() {
        return this.currentFormation.ordinal();
    }

    public int getTicksProgress() {
        return this.ticksProgress;
    }

    public void setTicksProgress(int ticksProgress) {
        this.ticksProgress = ticksProgress;
    }

    public int getMaxTicksForFormation() {
        return this.currentFormation.duration;
    }

    public boolean isSwordKnight() {
        return this.method_6047().method_7909() == TFItems.KNIGHTMETAL_SWORD.get();
    }

    public boolean isAxeKnight() {
        return this.method_6047().method_7909() == TFItems.KNIGHTMETAL_AXE.get();
    }

    public boolean isPickKnight() {
        return this.method_6047().method_7909() == TFItems.KNIGHTMETAL_PICKAXE.get();
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        switch (number % 3) {
            case 0: {
                this.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_SWORD.get()));
                break;
            }
            case 1: {
                this.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_AXE.get()));
                break;
            }
            case 2: {
                this.method_5673(class_1304.field_6173, new class_1799((class_1935)TFItems.KNIGHTMETAL_PICKAXE.get()));
            }
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.hasHome()) {
            class_2338 home = this.method_18412();
            compound.method_10566("Home", (class_2520)this.method_5846(new double[]{home.method_10263(), home.method_10264(), home.method_10260()}));
        }
        compound.method_10569("MyNumber", this.getNumber());
        compound.method_10569("Formation", this.getFormationAsNumber());
        compound.method_10569("TicksProgress", this.getTicksProgress());
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("Home", 9)) {
            class_2499 nbttaglist = compound.method_10554("Home", 6);
            int hx = (int)nbttaglist.method_10611(0);
            int hy = (int)nbttaglist.method_10611(1);
            int hz = (int)nbttaglist.method_10611(2);
            this.method_18408(new class_2338(hx, hy, hz), 20);
        } else {
            this.method_18410();
        }
        this.setNumber(compound.method_10550("MyNumber"));
        this.switchToFormationByNumber(compound.method_10550("Formation"));
        this.setTicksProgress(compound.method_10550("TicksProgress"));
    }

    protected boolean method_5860(class_1297 entityIn) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected float method_6120() {
        return 1.0f;
    }

    public boolean method_5822() {
        return false;
    }

    public boolean method_18411() {
        return this.method_18407(new class_2338((class_2382)this.method_24515()));
    }

    public boolean method_18407(class_2338 pos) {
        return this.maximumHomeDistance == -1.0f || this.homePosition.method_10262((class_2382)pos) < (double)(this.maximumHomeDistance * this.maximumHomeDistance);
    }

    public void method_18408(class_2338 pos, int distance) {
        this.homePosition = this.chargePos = pos;
        this.maximumHomeDistance = distance;
    }

    public class_2338 method_18412() {
        return this.homePosition;
    }

    public float method_18413() {
        return this.maximumHomeDistance;
    }

    public boolean method_18410() {
        this.maximumHomeDistance = -1.0f;
        return false;
    }

    public boolean hasHome() {
        return this.maximumHomeDistance != -1.0f;
    }

    public static enum Formation {
        HOVER(90),
        LARGE_CLOCKWISE(180),
        SMALL_CLOCKWISE(90),
        LARGE_ANTICLOCKWISE(180),
        SMALL_ANTICLOCKWISE(90),
        CHARGE_PLUSX(180),
        CHARGE_MINUSX(180),
        CHARGE_PLUSZ(180),
        CHARGE_MINUSZ(180),
        WAITING_FOR_LEADER(10),
        ATTACK_PLAYER_START(50),
        ATTACK_PLAYER_ATTACK(50);

        final int duration;

        private Formation(int duration) {
            this.duration = duration;
        }
    }
}

