/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraftforge.common.data.ExistingFileHelper;
import oshi.util.tuples.Pair;
import twilightforest.TwilightForestMod;
import twilightforest.item.recipe.TFRecipes;

public abstract class TransformationPowderProvider
implements class_2405 {
    private final class_2403 generator;
    private final String modId;
    private final ExistingFileHelper helper;
    protected final Map<String, Pair<class_1299<?>, class_1299<?>>> builders = Maps.newLinkedHashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public TransformationPowderProvider(class_2403 generator, String modId, ExistingFileHelper helper) {
        this.generator = generator;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerTransforms();

    public void method_10319(class_2408 cache) throws IOException {
        this.builders.clear();
        this.registerTransforms();
        this.builders.forEach((name, transform) -> {
            List list = this.builders.keySet().stream().filter(s -> class_2378.field_11145.method_10250(class_2378.field_11145.method_10221((Object)((class_1299)transform.getA())))).filter(s -> class_2378.field_11145.method_10250(class_2378.field_11145.method_10221((Object)((class_1299)transform.getB())))).filter(s -> !this.builders.containsKey(s)).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Duplicate Transformation Powder Transformations: %s", list.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }
            JsonObject obj = this.serializeToJson((class_1299)transform.getA(), (class_1299)transform.getB());
            Path path = this.createPath(new class_2960(this.modId, name));
            try {
                String s2 = GSON.toJson((JsonElement)obj);
                String s1 = field_11280.hashUnencodedChars((CharSequence)s2).toString();
                if (!Objects.equals(cache.method_10323(path), s1) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedwriter.write(s2);
                    }
                }
                cache.method_10325(path, s1);
            }
            catch (IOException ioexception) {
                TwilightForestMod.LOGGER.error("Couldn't save Transformation Powder recipe to {}", (Object)path, (Object)ioexception);
            }
        });
    }

    private boolean missing(String name) {
        return this.helper == null || !this.helper.exists(new class_2960(this.modId, name), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(class_3264.field_14190, ".json", "crumble_horn/"));
    }

    private Path createPath(class_2960 name) {
        return this.generator.method_10313().resolve("data/" + name.method_12836() + "/recipes/transformation_powder/" + name.method_12832() + ".json");
    }

    private JsonObject serializeToJson(class_1299<?> transformFrom, class_1299<?> transformTo) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", class_2378.field_17598.method_10221((Object)((class_1865)TFRecipes.TRANSFORMATION_SERIALIZER.get())).toString());
        jsonobject.addProperty("from", class_2378.field_11145.method_10221(transformFrom).toString());
        jsonobject.addProperty("to", class_2378.field_11145.method_10221(transformTo).toString());
        return jsonobject;
    }

    public String method_10321() {
        return this.modId + " Transformation Powder Transformations";
    }

    public void addSingleTransform(class_1299<?> from, class_1299<?> to) {
        this.builders.put(class_2378.field_11145.method_10221(from).method_12832() + "_to_" + class_2378.field_11145.method_10221(to).method_12832(), new Pair(from, to));
    }

    public void addTwoWayTransform(class_1299<?> from, class_1299<?> to) {
        this.builders.put(class_2378.field_11145.method_10221(from).method_12832() + "_to_" + class_2378.field_11145.method_10221(to).method_12832(), new Pair(from, to));
        this.builders.put(class_2378.field_11145.method_10221(to).method_12832() + "_to_" + class_2378.field_11145.method_10221(from).method_12832(), new Pair(to, from));
    }
}

