/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1068;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2484;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5544;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_607;
import net.minecraft.class_827;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.SkullCandleBlockEntity;

public class SkullCandleTileEntityRenderer<T extends SkullCandleBlockEntity>
implements class_827<T> {
    private final Map<class_2484.class_2485, class_5598> modelByType;
    public static final Map<class_2484.class_2485, class_2960> SKIN_BY_TYPE = (Map)class_156.method_654((Object)Maps.newHashMap(), p_112552_ -> {
        p_112552_.put(class_2484.class_2486.field_11512, new class_2960("textures/entity/skeleton/skeleton.png"));
        p_112552_.put(class_2484.class_2486.field_11513, new class_2960("textures/entity/skeleton/wither_skeleton.png"));
        p_112552_.put(class_2484.class_2486.field_11508, new class_2960("textures/entity/zombie/zombie.png"));
        p_112552_.put(class_2484.class_2486.field_11507, new class_2960("textures/entity/creeper/creeper.png"));
        p_112552_.put(class_2484.class_2486.field_11510, class_1068.method_4649());
    });

    public static Map<class_2484.class_2485, class_5598> createSkullRenderers(class_5599 p_173662_) {
        ImmutableMap.Builder var1 = ImmutableMap.builder();
        var1.put((Object)class_2484.class_2486.field_11512, (Object)new class_607(p_173662_.method_32072(class_5602.field_27653)));
        var1.put((Object)class_2484.class_2486.field_11513, (Object)new class_607(p_173662_.method_32072(class_5602.field_27634)));
        var1.put((Object)class_2484.class_2486.field_11510, (Object)new class_607(p_173662_.method_32072(class_5602.field_27578)));
        var1.put((Object)class_2484.class_2486.field_11508, (Object)new class_607(p_173662_.method_32072(class_5602.field_27640)));
        var1.put((Object)class_2484.class_2486.field_11507, (Object)new class_607(p_173662_.method_32072(class_5602.field_27548)));
        return var1.build();
    }

    public SkullCandleTileEntityRenderer(class_5614.class_5615 renderer) {
        this.modelByType = SkullCandleTileEntityRenderer.createSkullRenderers(renderer.method_32142());
    }

    public void render(SkullCandleBlockEntity tile, float ticks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_2680 state = tile.method_11010();
        boolean flag = state.method_26204() instanceof WallSkullCandleBlock;
        class_2350 dir = flag ? (class_2350)state.method_11654((class_2769)WallSkullCandleBlock.FACING) : null;
        float offset = 22.5f * (float)(flag ? (2 + dir.method_10161()) * 4 : (Integer)state.method_11654((class_2769)SkullCandleBlock.ROTATION));
        class_2484.class_2485 type = ((AbstractSkullCandleBlock)state.method_26204()).getType();
        class_5598 base = this.modelByType.get(type);
        class_1921 render = SkullCandleTileEntityRenderer.getRenderType(type, tile.method_11334());
        SkullCandleTileEntityRenderer.renderSkull(dir, offset, 0.0f, ms, buffer, light, base, render);
        if (dir != null) {
            ms.method_22904((double)(-((float)dir.method_10148()) * 0.25f), 0.0, (double)(-((float)dir.method_10165()) * 0.25f));
        }
        ms.method_22904(0.0, flag ? 0.75 : (double)0.45f, 0.0);
        if (tile.candleAmount <= 0) {
            tile.candleAmount = 1;
        }
        class_310.method_1551().method_1541().method_3353((class_2680)((class_2680)AbstractSkullCandleBlock.candleColorToCandle(AbstractSkullCandleBlock.CandleColors.colorFromInt(tile.candleColor).method_15434()).method_9564().method_11657((class_2769)class_5544.field_27174, (Comparable)Integer.valueOf(tile.candleAmount))).method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(state.method_11654((class_2769)AbstractSkullCandleBlock.LIGHTING) == AbstractLightableBlock.Lighting.NORMAL)), ms, buffer, light, overlay);
    }

    public static void renderSkull(@Nullable class_2350 dir, float ticks, float animTime, class_4587 ms, class_4597 buffer, int light, class_5598 base, class_1921 render) {
        ms.method_22903();
        if (dir == null) {
            ms.method_22904(0.5, 0.0, 0.5);
        } else {
            ms.method_22904((double)(0.5f - (float)dir.method_10148() * 0.25f), 0.25, (double)(0.5f - (float)dir.method_10165() * 0.25f));
        }
        ms.method_22905(-1.0f, -1.0f, 1.0f);
        class_4588 consumer = buffer.getBuffer(render);
        base.method_2821(animTime, ticks, 0.0f);
        base.method_2828(ms, consumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        ms.method_22909();
    }

    public static class_1921 getRenderType(class_2484.class_2485 pSkullType, @Nullable GameProfile pGameProfile) {
        class_2960 resourcelocation = SKIN_BY_TYPE.get(pSkullType);
        if (pSkullType == class_2484.class_2486.field_11510 && pGameProfile != null) {
            class_310 minecraft = class_310.method_1551();
            Map map = minecraft.method_1582().method_4654(pGameProfile);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? class_1921.method_23580((class_2960)minecraft.method_1582().method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : class_1921.method_23578((class_2960)class_1068.method_4648((UUID)class_1657.method_7271((GameProfile)pGameProfile)));
        }
        return class_1921.method_28116((class_2960)resourcelocation);
    }
}

