/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.block.TrophyBlock;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.util.PlayerHelper;
import twilightforest.util.TFStats;
import twilightforest.world.registration.TFGenerationSettings;

public class TrophyPedestalBlock
extends class_2248
implements class_3737 {
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"active");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 BOTTOM = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
    private static final class_265 MID = class_2248.method_9541((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private static final class_265 TOP = class_2248.method_9541((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final class_265 CORNER1 = class_2248.method_9541((double)1.0, (double)12.0, (double)1.0, (double)4.0, (double)13.0, (double)4.0);
    private static final class_265 CORNER2 = class_2248.method_9541((double)12.0, (double)12.0, (double)1.0, (double)15.0, (double)13.0, (double)4.0);
    private static final class_265 CORNER3 = class_2248.method_9541((double)1.0, (double)12.0, (double)12.0, (double)4.0, (double)13.0, (double)15.0);
    private static final class_265 CORNER4 = class_2248.method_9541((double)12.0, (double)12.0, (double)12.0, (double)15.0, (double)13.0, (double)15.0);
    private static final class_265 FINAL = class_259.method_17786((class_265)BOTTOM, (class_265[])new class_265[]{MID, TOP, CORNER1, CORNER2, CORNER3, CORNER4});

    public TrophyPedestalBlock(class_4970.class_2251 props) {
        super(props);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidstate = context.method_8045().method_8316(context.method_8037());
        boolean flag = fluidstate.method_15772() == class_3612.field_15910;
        return (class_2680)super.method_9605(context).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (((Boolean)stateIn.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            worldIn.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)worldIn));
        }
        return super.method_9559(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ACTIVE, WATERLOGGED});
    }

    @Deprecated
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return FINAL;
    }

    @Deprecated
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        world.method_8455(pos, (class_2248)this);
        if (world.field_9236 || ((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue() || !this.isTrophyOnTop(world, pos)) {
            return;
        }
        if (TFGenerationSettings.isProgressionEnforced(world)) {
            if (this.areNearbyPlayersEligible(world, pos)) {
                this.doPedestalEffect(world, pos, state);
            }
            this.warnIneligiblePlayers(world, pos);
        } else {
            this.doPedestalEffect(world, pos, state);
        }
        this.rewardNearbyPlayers(world, pos);
    }

    private boolean isTrophyOnTop(class_1937 world, class_2338 pos) {
        return world.method_8320(pos.method_10084()).method_26164(BlockTagGenerator.TROPHIES);
    }

    private void warnIneligiblePlayers(class_1937 world, class_2338 pos) {
        for (class_1657 player : world.method_18467(class_1657.class, new class_238(pos).method_1014(16.0))) {
            if (this.isPlayerEligible(player)) continue;
            player.method_7353((class_2561)new class_2588("twilightforest.trophy_pedestal.ineligible"), true);
        }
    }

    private boolean areNearbyPlayersEligible(class_1937 world, class_2338 pos) {
        for (class_1657 player : world.method_18467(class_1657.class, new class_238(pos).method_1014(16.0))) {
            if (!this.isPlayerEligible(player)) continue;
            return true;
        }
        return false;
    }

    private boolean isPlayerEligible(class_1657 player) {
        return PlayerHelper.doesPlayerHaveRequiredAdvancements(player, TwilightForestMod.prefix("progress_lich"));
    }

    private void doPedestalEffect(class_1937 world, class_2338 pos, class_2680 state) {
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(true)));
        this.removeNearbyShields(world, pos);
        world.method_8396(null, pos, TFSounds.PEDESTAL_ACTIVATE, class_3419.field_15245, 4.0f, 0.1f);
    }

    private void rewardNearbyPlayers(class_1937 world, class_2338 pos) {
        for (class_3222 player : world.method_18467(class_3222.class, new class_238(pos).method_1014(16.0))) {
            TFAdvancements.PLACED_TROPHY_ON_PEDESTAL.trigger(player);
            player.method_7281((class_2960)TFStats.TROPHY_PEDESTALS_ACTIVATED.get());
        }
    }

    private void removeNearbyShields(class_1937 world, class_2338 pos) {
        for (int sx = -5; sx <= 5; ++sx) {
            for (int sy = -5; sy <= 5; ++sy) {
                for (int sz = -5; sz <= 5; ++sz) {
                    if (world.method_8320(pos.method_10069(sx, sy, sz)).method_26204() != TFBlocks.STRONGHOLD_SHIELD.get()) continue;
                    world.method_22352(pos.method_10069(sx, sy, sz), false);
                }
            }
        }
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 worldIn, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)ACTIVE) != false ? super.method_9594(state, player, worldIn, pos) : -1.0f;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 blockState, class_1937 worldIn, class_2338 pos) {
        class_2248 trophy = worldIn.method_8320(pos.method_10084()).method_26204();
        if (trophy instanceof TrophyBlock) {
            return ((TrophyBlock)trophy).getComparatorValue();
        }
        return 0;
    }

    public class_3619 method_9527(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)ACTIVE) != false ? class_3619.field_15974 : class_3619.field_15972;
    }
}

