/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type.addon;

import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.block.AncientFabricBlock;
import org.dimdev.dimdoors.block.FabricBlock;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.PocketColor;
import org.dimdev.dimdoors.world.pocket.type.PrivatePocket;
import org.dimdev.dimdoors.world.pocket.type.addon.AddonProvider;
import org.dimdev.dimdoors.world.pocket.type.addon.PocketAddon;

public class DyeableAddon
implements PocketAddon {
    public static class_2960 ID = new class_2960("dimdoors", "dyeable");
    private static final int BLOCKS_PAINTED_PER_DYE = 1000000;
    protected PocketColor dyeColor = PocketColor.WHITE;
    private PocketColor nextDyeColor = PocketColor.NONE;
    private int count = 0;

    private static int amountOfDyeRequiredToColor(Pocket pocket) {
        int outerVolume = pocket.getBox().method_14660() * pocket.getBox().method_14663() * pocket.getBox().method_14663();
        int innerVolume = (pocket.getBox().method_14660() - 5) * (pocket.getBox().method_14663() - 5) * (pocket.getBox().method_14663() - 5);
        return Math.max((outerVolume - innerVolume) / 1000000, 1);
    }

    private void repaint(Pocket pocket, class_1767 dyeColor) {
        class_3218 serverWorld = DimensionalDoorsInitializer.getWorld(pocket.getWorld());
        class_2680 innerWall = ModBlocks.fabricFromDye(dyeColor).method_9564();
        class_2680 outerWall = ModBlocks.ancientFabricFromDye(dyeColor).method_9564();
        class_2338.method_23627((class_3341)pocket.getBox()).forEach(pos -> {
            if (serverWorld.method_8320(pos).method_26204() instanceof AncientFabricBlock) {
                serverWorld.method_8501(pos, outerWall);
            } else if (serverWorld.method_8320(pos).method_26204() instanceof FabricBlock) {
                serverWorld.method_8501(pos, innerWall);
            }
        });
    }

    public boolean addDye(Pocket pocket, class_1297 entity, class_1767 dyeColor) {
        PocketColor color = PocketColor.from(dyeColor);
        int maxDye = DyeableAddon.amountOfDyeRequiredToColor(pocket);
        if (this.dyeColor == color) {
            EntityUtils.chat(entity, (class_2561)new class_2588("dimdoors.pockets.dyeAlreadyAbsorbed"));
            return false;
        }
        if (this.nextDyeColor != PocketColor.NONE && this.nextDyeColor == color) {
            if (this.count + 1 > maxDye) {
                this.repaint(pocket, dyeColor);
                this.dyeColor = color;
                this.nextDyeColor = PocketColor.NONE;
                this.count = 0;
                EntityUtils.chat(entity, (class_2561)new class_2588("dimdoors.pocket.pocketHasBeenDyed", new Object[]{dyeColor}));
            } else {
                ++this.count;
                EntityUtils.chat(entity, (class_2561)new class_2588("dimdoors.pocket.remainingNeededDyes", new Object[]{this.count, maxDye, color}));
            }
        } else {
            this.nextDyeColor = color;
            this.count = 1;
            EntityUtils.chat(entity, (class_2561)new class_2588("dimdoors.pocket.remainingNeededDyes", new Object[]{this.count, maxDye, color}));
        }
        return true;
    }

    @Override
    public boolean applicable(Pocket pocket) {
        return pocket instanceof PrivatePocket;
    }

    @Override
    public PocketAddon fromNbt(class_2487 nbt) {
        this.dyeColor = PocketColor.from(nbt.method_10550("dyeColor"));
        this.nextDyeColor = PocketColor.from(nbt.method_10550("nextDyeColor"));
        this.count = nbt.method_10550("count");
        return this;
    }

    @Override
    public class_2487 toNbt(class_2487 nbt) {
        PocketAddon.super.toNbt(nbt);
        nbt.method_10569("dyeColor", this.dyeColor.getId().intValue());
        nbt.method_10569("nextDyeColor", this.nextDyeColor.getId().intValue());
        nbt.method_10569("count", this.count);
        return nbt;
    }

    @Override
    public PocketAddon.PocketAddonType<? extends PocketAddon> getType() {
        return PocketAddon.PocketAddonType.DYEABLE_ADDON;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    public static interface DyeablePocket
    extends AddonProvider {
        default public boolean addDye(class_1297 entity, class_1767 dyeColor) {
            this.ensureIsPocket();
            if (!this.hasAddon(ID)) {
                DyeableAddon addon = new DyeableAddon();
                this.addAddon(addon);
                return addon.addDye((Pocket)((Object)this), entity, dyeColor);
            }
            return ((DyeableAddon)this.getAddon(ID)).addDye((Pocket)((Object)this), entity, dyeColor);
        }
    }

    public static class DyeableBuilderAddon
    implements PocketAddon.PocketBuilderAddon<DyeableAddon> {
        private PocketColor dyeColor = PocketColor.NONE;

        @Override
        public void apply(Pocket pocket) {
            DyeableAddon addon = new DyeableAddon();
            addon.dyeColor = this.dyeColor;
            pocket.addAddon(addon);
        }

        @Override
        public class_2960 getId() {
            return ID;
        }

        @Override
        public PocketAddon.PocketBuilderAddon<DyeableAddon> fromNbt(class_2487 nbt) {
            this.dyeColor = PocketColor.from(nbt.method_10550("dye_color"));
            return this;
        }

        @Override
        public class_2487 toNbt(class_2487 nbt) {
            PocketAddon.PocketBuilderAddon.super.toNbt(nbt);
            nbt.method_10569("dye_color", this.dyeColor.getId().intValue());
            return nbt;
        }

        @Override
        public PocketAddon.PocketAddonType<DyeableAddon> getType() {
            return PocketAddon.PocketAddonType.DYEABLE_ADDON;
        }
    }

    public static interface DyeablePocketBuilder<T extends Pocket.PocketBuilder<T, ?>>
    extends PocketAddon.PocketBuilderExtension<T> {
        default public T dyeColor(PocketColor dyeColor) {
            ((DyeableBuilderAddon)this.getAddon((class_2960)DyeableAddon.ID)).dyeColor = dyeColor;
            return this.getSelf();
        }
    }
}

