/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_5321;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.addon.AddonProvider;
import org.dimdev.dimdoors.world.pocket.type.addon.PocketAddon;

public class Pocket
extends AbstractPocket<Pocket>
implements AddonProvider {
    public static String KEY = "pocket";
    private final Map<class_2960, PocketAddon> addons = new HashMap<class_2960, PocketAddon>();
    private int range = -1;
    private class_3341 box;
    public VirtualLocation virtualLocation;

    public Pocket(int id, class_5321<class_1937> world, int x, int z) {
        super(id, world);
        int gridSize = DimensionalRegistry.getPocketDirectory(world).getGridSize() * 16;
        this.box = class_3341.method_34390((class_2382)new class_2382(x * gridSize, 0, z * gridSize), (class_2382)new class_2382((x + 1) * gridSize, 0, (z + 1) * gridSize));
        this.virtualLocation = new VirtualLocation(world, x, z, 0);
    }

    protected Pocket() {
    }

    @Override
    public boolean hasAddon(class_2960 id) {
        return this.addons.containsKey(id);
    }

    @Override
    public <C extends PocketAddon> boolean addAddon(C addon) {
        if (addon.applicable(this)) {
            addon.addAddon(this.addons);
            return true;
        }
        return false;
    }

    @Override
    public <C extends PocketAddon> C getAddon(class_2960 id) {
        return (C)this.addons.get(id);
    }

    public <T> List<T> getAddonsInstanceOf(Class<T> clazz) {
        return this.addons.values().stream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
    }

    public boolean isInBounds(class_2338 pos) {
        return this.box.method_14662((class_2382)pos);
    }

    public class_2338 getOrigin() {
        return new class_2338(this.box.method_35415(), this.box.method_35416(), this.box.method_35417());
    }

    public void offsetOrigin(class_2382 vec) {
        this.box.method_29299(vec);
    }

    public void offsetOrigin(int x, int y, int z) {
        this.box.method_14661(x, y, z);
    }

    public void setSize(class_2382 size) {
        this.setSize(size.method_10263(), size.method_10264(), size.method_10260());
    }

    public void setSize(int x, int y, int z) {
        this.box = class_3341.method_34390((class_2382)new class_2382(this.box.method_35415(), this.box.method_35416(), this.box.method_35417()), (class_2382)new class_2382(this.box.method_35415() + x - 1, this.box.method_35416() + y - 1, this.box.method_35417() + z - 1));
    }

    public void setRange(int range) {
        if (this.range > 0) {
            throw new UnsupportedOperationException("Cannot set range of Pocket that has already been initialized.");
        }
        this.range = range;
    }

    public int getRange() {
        if (this.range < 1) {
            throw new UnsupportedOperationException("Range of pocket has not been initialized yet.");
        }
        return this.range;
    }

    public class_2382 getSize() {
        return this.box.method_14659();
    }

    @Override
    public class_2487 toNbt(class_2487 nbt) {
        super.toNbt(nbt);
        nbt.method_10569("range", this.range);
        nbt.method_10539("box", IntStream.of(this.box.method_35415(), this.box.method_35416(), this.box.method_35417(), this.box.method_35418(), this.box.method_35419(), this.box.method_35420()).toArray());
        nbt.method_10566("virtualLocation", (class_2520)VirtualLocation.toNbt(this.virtualLocation));
        class_2499 addonsTag = new class_2499();
        addonsTag.addAll((Collection)this.addons.values().stream().map(addon -> addon.toNbt(new class_2487())).collect(Collectors.toList()));
        if (addonsTag.size() > 0) {
            nbt.method_10566("addons", (class_2520)addonsTag);
        }
        return nbt;
    }

    @Override
    public AbstractPocket.AbstractPocketType<?> getType() {
        return AbstractPocket.AbstractPocketType.POCKET;
    }

    @Override
    public Pocket fromNbt(class_2487 nbt) {
        super.fromNbt(nbt);
        this.range = nbt.method_10550("range");
        int[] box = nbt.method_10561("box");
        this.box = class_3341.method_34390((class_2382)new class_2382(box[0], box[1], box[2]), (class_2382)new class_2382(box[3], box[4], box[5]));
        this.virtualLocation = VirtualLocation.fromNbt(nbt.method_10562("virtualLocation"));
        if (nbt.method_10573("addons", 9)) {
            for (class_2520 addonTag : nbt.method_10554("addons", 10)) {
                PocketAddon addon = PocketAddon.deserialize((class_2487)addonTag);
                this.addons.put(addon.getId(), addon);
            }
        }
        return this;
    }

    public Map<class_2338, class_2586> getBlockEntities() {
        class_3218 serverWorld = DimensionalDoorsInitializer.getWorld(this.getWorld());
        HashMap<class_2338, class_2586> blockEntities = new HashMap<class_2338, class_2586>();
        class_1923.method_19281((class_1923)new class_1923(new class_2338(this.box.method_35415(), this.box.method_35416(), this.box.method_35417())), (class_1923)new class_1923(new class_2338(this.box.method_35418(), this.box.method_35419(), this.box.method_35420()))).forEach(chunkPos -> serverWorld.method_8497(chunkPos.field_9181, chunkPos.field_9180).method_12214().forEach((blockPos, blockEntity) -> {
            if (this.box.method_14662((class_2382)blockPos)) {
                blockEntities.put((class_2338)blockPos, (class_2586)blockEntity);
            }
        }));
        return blockEntities;
    }

    public class_3341 getBox() {
        return this.box;
    }

    @Override
    public Map<String, Double> toVariableMap(Map<String, Double> variableMap) {
        variableMap = super.toVariableMap(variableMap);
        variableMap.put("originX", Double.valueOf(this.box.method_35415()));
        variableMap.put("originY", Double.valueOf(this.box.method_35416()));
        variableMap.put("originZ", Double.valueOf(this.box.method_35417()));
        variableMap.put("width", Double.valueOf(this.box.method_14659().method_10263()));
        variableMap.put("height", Double.valueOf(this.box.method_14659().method_10264()));
        variableMap.put("length", Double.valueOf(this.box.method_14659().method_10260()));
        variableMap.put("depth", Double.valueOf(this.virtualLocation.getDepth()));
        return variableMap;
    }

    @Override
    public Pocket getReferencedPocket() {
        return this;
    }

    public void expand(int amount) {
        this.box.method_35410(amount);
    }

    public static PocketBuilder<?, Pocket> builder() {
        return new PocketBuilder(AbstractPocket.AbstractPocketType.POCKET);
    }

    protected void setBox(class_3341 box) {
        this.box = box;
    }

    public static class PocketBuilder<P extends PocketBuilder<P, T>, T extends Pocket>
    extends AbstractPocket.AbstractPocketBuilder<P, T> {
        private final Map<class_2960, PocketAddon.PocketBuilderAddon<?>> addons = new HashMap();
        private class_2382 origin = new class_2382(0, 0, 0);
        private class_2382 size = new class_2382(0, 0, 0);
        private class_2382 expected = new class_2382(0, 0, 0);
        private VirtualLocation virtualLocation;
        private int range = -1;

        protected PocketBuilder(AbstractPocket.AbstractPocketType<T> type) {
            super(type);
            this.initAddons();
        }

        public void initAddons() {
        }

        @Override
        public P fromNbt(class_2487 nbt) {
            if (nbt.method_10573("addons", 9)) {
                for (class_2520 addonTag : nbt.method_10554("addons", 10)) {
                    PocketAddon.PocketBuilderAddon<?> addon = PocketAddon.deserializeBuilder((class_2487)addonTag);
                    this.addons.put(addon.getId(), addon);
                }
            }
            return (P)((PocketBuilder)this.getSelf());
        }

        @Override
        public class_2487 toNbt(class_2487 nbt) {
            class_2499 addonsTag = new class_2499();
            addonsTag.addAll((Collection)this.addons.values().stream().map(addon -> addon.toNbt(new class_2487())).collect(Collectors.toList()));
            if (addonsTag.size() > 0) {
                nbt.method_10566("addons", (class_2520)addonsTag);
            }
            return nbt;
        }

        public boolean hasAddon(class_2960 id) {
            return this.addons.containsKey(id);
        }

        protected <C extends PocketAddon.PocketBuilderAddon<?>> boolean addAddon(C addon) {
            if (addon.applicable(this)) {
                addon.addAddon(this.addons);
                return true;
            }
            return false;
        }

        public <C extends PocketAddon.PocketBuilderAddon<?>> C getAddon(class_2960 id) {
            return (C)this.addons.get(id);
        }

        @Override
        public class_2382 getExpectedSize() {
            return this.expected;
        }

        @Override
        public T build() {
            if (this.range < 1) {
                throw new RuntimeException("Cannot create pocket with range < 1");
            }
            Pocket instance = (Pocket)super.build();
            instance.setRange(this.range);
            instance.setBox(class_3341.method_34390((class_2382)new class_2382(this.origin.method_10263(), this.origin.method_10264(), this.origin.method_10260()), (class_2382)new class_2382(this.origin.method_10263() + this.size.method_10263(), this.origin.method_10264() + this.size.method_10264(), this.origin.method_10260() + this.size.method_10260())));
            instance.virtualLocation = this.virtualLocation;
            this.addons.values().forEach(addon -> addon.apply(instance));
            return (T)instance;
        }

        public P offsetOrigin(class_2382 offset) {
            this.origin = new class_2382(this.origin.method_10263() + offset.method_10263(), this.origin.method_10264() + offset.method_10264(), this.origin.method_10260() + offset.method_10260());
            return (P)((PocketBuilder)this.getSelf());
        }

        public P expand(class_2382 expander) {
            this.size = new class_2382(this.size.method_10263() + expander.method_10263(), this.size.method_10264() + expander.method_10264(), this.size.method_10260() + expander.method_10260());
            this.expected = new class_2382(this.expected.method_10263() + expander.method_10263(), this.expected.method_10264() + expander.method_10264(), this.expected.method_10260() + expander.method_10260());
            return (P)((PocketBuilder)this.getSelf());
        }

        public P expandExpected(class_2382 expander) {
            this.expected = new class_2382(this.expected.method_10263() + expander.method_10263(), this.expected.method_10264() + expander.method_10264(), this.expected.method_10260() + expander.method_10260());
            return (P)((PocketBuilder)this.getSelf());
        }

        public P virtualLocation(VirtualLocation virtualLocation) {
            this.virtualLocation = virtualLocation;
            return (P)((PocketBuilder)this.getSelf());
        }

        public P range(int range) {
            this.range = range;
            return (P)((PocketBuilder)this.getSelf());
        }
    }
}

