/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type;

import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_3341;
import org.dimdev.dimdoors.api.util.BlockBoxUtil;
import org.dimdev.dimdoors.pockets.generator.LazyPocketGenerator;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.world.level.component.ChunkLazilyGeneratedComponent;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class LazyGenerationPocket
extends Pocket {
    public static String KEY = "lazy_gen_pocket";
    private LazyPocketGenerator generator;
    private int toBeGennedChunkCount = 0;

    public void chunkLoaded(class_2791 chunk) {
        if (this.isDoneGenerating()) {
            return;
        }
        ChunkLazilyGeneratedComponent lazyGenned = ChunkLazilyGeneratedComponent.get(chunk);
        if (lazyGenned.hasBeenLazyGenned()) {
            return;
        }
        class_3341 chunkBox = BlockBoxUtil.getBox(chunk);
        if (!chunkBox.method_14657(this.getBox())) {
            return;
        }
        this.generator.generateChunk(this, chunk);
        lazyGenned.setGenned();
        --this.toBeGennedChunkCount;
        if (this.isDoneGenerating()) {
            this.generator = null;
        }
    }

    public boolean isDoneGenerating() {
        return this.toBeGennedChunkCount == 0;
    }

    public void attachGenerator(LazyPocketGenerator generator) {
        this.generator = generator;
    }

    public void init() {
        class_3341 box = this.getBox();
        this.toBeGennedChunkCount = (Math.floorDiv(box.method_35418(), 16) - Math.floorDiv(box.method_35415(), 16) + 1) * (Math.floorDiv(box.method_35420(), 16) - Math.floorDiv(box.method_35417(), 16) + 1);
    }

    @Override
    public class_2487 toNbt(class_2487 nbt) {
        super.toNbt(nbt);
        if (this.generator != null) {
            nbt.method_10566("generator", (class_2520)this.generator.toNbt(new class_2487()));
        }
        if (this.toBeGennedChunkCount > 0) {
            nbt.method_10569("to_be_genned_chunks", this.toBeGennedChunkCount);
        }
        return nbt;
    }

    @Override
    public AbstractPocket.AbstractPocketType<?> getType() {
        return AbstractPocket.AbstractPocketType.LAZY_GENERATION_POCKET;
    }

    public static String getKEY() {
        return KEY;
    }

    @Override
    public Pocket fromNbt(class_2487 nbt) {
        super.fromNbt(nbt);
        if (nbt.method_10573("generator", 10)) {
            this.generator = (LazyPocketGenerator)PocketGenerator.deserialize(nbt.method_10562("generator"));
        }
        if (nbt.method_10573("to_be_genned_chunks", 3)) {
            this.toBeGennedChunkCount = nbt.method_10550("to_be_genned_chunks");
        }
        return this;
    }

    @Override
    public Map<class_2338, class_2586> getBlockEntities() {
        return super.getBlockEntities();
    }

    public static LazyGenerationPocketBuilder<?, LazyGenerationPocket> builderLazyGenerationPocket() {
        return new LazyGenerationPocketBuilder(AbstractPocket.AbstractPocketType.LAZY_GENERATION_POCKET);
    }

    public static class LazyGenerationPocketBuilder<P extends LazyGenerationPocketBuilder<P, T>, T extends LazyGenerationPocket>
    extends Pocket.PocketBuilder<P, T> {
        protected LazyGenerationPocketBuilder(AbstractPocket.AbstractPocketType<T> type) {
            super(type);
        }
    }
}

