/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class VirtualLocation {
    public static Codec<VirtualLocation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1937.field_25178.fieldOf("world").forGetter(virtualLocation -> virtualLocation.world), (App)Codec.INT.fieldOf("x").forGetter(virtualLocation -> virtualLocation.x), (App)Codec.INT.fieldOf("z").forGetter(virtualLocation -> virtualLocation.z), (App)Codec.INT.fieldOf("depth").forGetter(virtualLocation -> virtualLocation.depth)).apply((Applicative)instance, VirtualLocation::new));
    private final class_5321<class_1937> world;
    private final int x;
    private final int z;
    private final int depth;

    public VirtualLocation(class_5321<class_1937> world, int x, int z, int depth) {
        this.world = world;
        this.x = x;
        this.z = z;
        this.depth = depth;
    }

    public static class_2487 toNbt(VirtualLocation virtualLocation) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("world", virtualLocation.world.method_29177().toString());
        nbt.method_10569("x", virtualLocation.x);
        nbt.method_10569("z", virtualLocation.z);
        nbt.method_10569("depth", virtualLocation.depth);
        return nbt;
    }

    public static VirtualLocation fromNbt(class_2487 nbt) {
        return new VirtualLocation((class_5321<class_1937>)class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(nbt.method_10558("world"))), nbt.method_10550("x"), nbt.method_10550("z"), nbt.method_10550("depth"));
    }

    public static VirtualLocation fromLocation(Location location) {
        VirtualLocation virtualLocation = null;
        if (ModDimensions.isPocketDimension(location.world)) {
            Pocket pocket = DimensionalRegistry.getPocketDirectory(location.world).getPocketAt(location.pos);
            virtualLocation = pocket != null ? pocket.virtualLocation : null;
        } else if (ModDimensions.isLimboDimension((class_1937)location.getWorld())) {
            virtualLocation = new VirtualLocation(location.world, location.getX(), location.getZ(), DimensionalDoorsInitializer.getConfig().getDungeonsConfig().maxDungeonDepth);
        }
        if (virtualLocation == null) {
            return new VirtualLocation((class_5321<class_1937>)class_1937.field_25179, location.getX(), location.getZ(), 5);
        }
        return new VirtualLocation(location.getWorldId(), location.getX(), location.getZ(), virtualLocation.getDepth());
    }

    public Location projectToWorld(boolean acceptLimbo) {
        class_3218 world = DimensionalDoorsInitializer.getServer().method_3847(this.world);
        if (!acceptLimbo && ModDimensions.isLimboDimension((class_1937)world)) {
            world = world.method_8503().method_30002();
        }
        float spread = DimensionalDoorsInitializer.getConfig().getGeneralConfig().depthSpreadFactor * this.depth;
        int newX = (int)((double)this.x + (double)(spread * 2.0f) * (Math.random() - 0.5));
        int newZ = (int)((double)this.z + (double)(spread * 2.0f) * (Math.random() - 0.5));
        class_2338 pos = VirtualLocation.getTopPos((class_1937)world, newX, newZ).method_10084();
        return new Location(world, pos);
    }

    public static class_2338 getTopPos(class_1937 world, int x, int z) {
        int topHeight = world.method_8497(class_4076.method_18675((int)x), class_4076.method_18675((int)z)).method_12005(class_2902.class_2903.field_13197, x, z);
        return new class_2338(x, topHeight, z);
    }

    public class_5321<class_1937> getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("world", this.world).add("x", this.x).add("z", this.z).add("depth", this.depth).toString();
    }
}

