/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.level.registry;

import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_31;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import org.dimdev.dimdoors.DimensionalDoorsComponents;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.rift.registry.RiftRegistry;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.RiftSchemas;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.PrivateRegistry;

public class DimensionalRegistry
implements ComponentV3 {
    public static final int RIFT_DATA_VERSION = 1;
    private Map<class_5321<class_1937>, PocketDirectory> pocketRegistry = new HashMap<class_5321<class_1937>, PocketDirectory>();
    private RiftRegistry riftRegistry = new RiftRegistry();
    private PrivateRegistry privateRegistry = new PrivateRegistry();

    public void readFromNbt(class_2487 nbt) {
        int riftDataVersion = nbt.method_10550("RiftDataVersion");
        if (riftDataVersion < 1) {
            nbt = RiftSchemas.update(riftDataVersion, nbt);
        } else if (1 < riftDataVersion) {
            throw new UnsupportedOperationException("Downgrading is not supported!");
        }
        class_2487 pocketRegistryNbt = nbt.method_10562("pocket_registry");
        CompletableFuture<Map> futurePocketRegistry = CompletableFuture.supplyAsync(() -> ((Stream)pocketRegistryNbt.method_10541().stream().map(key -> {
            class_2487 pocketDirectoryNbt = pocketRegistryNbt.method_10562(key);
            return CompletableFuture.supplyAsync(() -> new class_3545((Object)class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)class_2960.method_12829((String)key)), (Object)PocketDirectory.readFromNbt(key, pocketDirectoryNbt)));
        }).parallel()).map(CompletableFuture::join).collect(Collectors.toConcurrentMap(class_3545::method_15442, class_3545::method_15441)));
        class_2487 privateRegistryNbt = nbt.method_10562("private_registry");
        CompletableFuture<PrivateRegistry> futurePrivateRegistry = CompletableFuture.supplyAsync(() -> {
            PrivateRegistry privateRegistry = new PrivateRegistry();
            privateRegistry.fromNbt(privateRegistryNbt);
            return privateRegistry;
        });
        this.pocketRegistry = futurePocketRegistry.join();
        class_2487 riftRegistryNbt = nbt.method_10562("rift_registry");
        CompletableFuture<RiftRegistry> futureRiftRegistry = CompletableFuture.supplyAsync(() -> RiftRegistry.fromNbt(this.pocketRegistry, riftRegistryNbt));
        this.riftRegistry = futureRiftRegistry.join();
        this.privateRegistry = futurePrivateRegistry.join();
    }

    public void writeToNbt(class_2487 nbt) {
        CompletableFuture<class_2520> futurePocketRegistryNbt = CompletableFuture.supplyAsync(() -> {
            ArrayList futurePocketRegistryNbts = new ArrayList();
            this.pocketRegistry.forEach((key, value) -> futurePocketRegistryNbts.add(CompletableFuture.supplyAsync(() -> new class_3545((Object)key.method_29177().toString(), (Object)value.writeToNbt()))));
            class_2487 pocketRegistryNbt = new class_2487();
            ((Stream)futurePocketRegistryNbts.parallelStream().unordered()).map(CompletableFuture::join).collect(Collectors.toConcurrentMap(class_3545::method_15442, class_3545::method_15441)).forEach((arg_0, arg_1) -> ((class_2487)pocketRegistryNbt).method_10566(arg_0, arg_1));
            return pocketRegistryNbt;
        });
        CompletableFuture<class_2520> futureRiftRegistryNbt = CompletableFuture.supplyAsync(this.riftRegistry::toNbt);
        CompletableFuture<class_2520> futurePrivateRegistryNbt = CompletableFuture.supplyAsync(() -> this.privateRegistry.toNbt(new class_2487()));
        nbt.method_10566("pocket_registry", futurePocketRegistryNbt.join());
        nbt.method_10566("rift_registry", futureRiftRegistryNbt.join());
        nbt.method_10566("private_registry", futurePrivateRegistryNbt.join());
        nbt.method_10569("RiftDataVersion", 1);
    }

    public static DimensionalRegistry instance() {
        return (DimensionalRegistry)DimensionalDoorsComponents.DIMENSIONAL_REGISTRY_COMPONENT_KEY.get((Object)((class_31)DimensionalDoorsInitializer.getServer().method_27728()));
    }

    public static RiftRegistry getRiftRegistry() {
        return DimensionalRegistry.instance().riftRegistry;
    }

    public static PrivateRegistry getPrivateRegistry() {
        return DimensionalRegistry.instance().privateRegistry;
    }

    public static PocketDirectory getPocketDirectory(class_5321<class_1937> key) {
        if (!ModDimensions.isPocketDimension(key)) {
            throw new UnsupportedOperationException("PocketRegistry is only available for pocket dimensions!");
        }
        return DimensionalRegistry.instance().pocketRegistry.computeIfAbsent(key, PocketDirectory::new);
    }
}

