/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1301;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.network.ExtendedServerPlayNetworkHandler;
import org.dimdev.dimdoors.network.packet.s2c.RenderBreakBlockS2CPacket;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.decay.DecayPattern;

public final class LimboDecay {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<class_5321<class_1937>, Set<DecayTask>> DECAY_QUEUE = new HashMap<class_5321<class_1937>, Set<DecayTask>>();
    private static final int DECAY_DELAY = 40;
    private static final Random RANDOM = new Random();

    public static void applySpreadDecay(class_3218 world, class_2338 pos) {
        if (RANDOM.nextDouble() < DimensionalDoorsInitializer.getConfig().getLimboConfig().decaySpreadChance) {
            class_2680 origin = world.method_8320(pos);
            int decayAmount = RANDOM.nextInt(5) + 1;
            ArrayList<class_2350> directions = new ArrayList<class_2350>(Arrays.asList(class_2350.values()));
            for (int i = 0; i < decayAmount; ++i) {
                LimboDecay.decayBlock(world, pos.method_10093((class_2350)directions.remove(RANDOM.nextInt(5 - i))), origin);
            }
        }
    }

    private static void decayBlock(class_3218 world, class_2338 pos, class_2680 origin) {
        class_2680 target = world.method_8320(pos);
        Collection<DecayPattern> patterns = DecayLoader.getInstance().getPatterns(target.method_26204());
        if (patterns == null || patterns.isEmpty()) {
            return;
        }
        for (DecayPattern pattern : patterns) {
            if (!pattern.test((class_1937)world, pos, origin, target)) continue;
            world.method_18766(class_1301.method_5909((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)100.0)).forEach(player -> ExtendedServerPlayNetworkHandler.get(player.field_13987).getDimDoorsPacketHandler().sendPacket(new RenderBreakBlockS2CPacket(pos, 5)));
            world.method_8465(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), ModSoundEvents.TEARING, class_3419.field_15245, 0.5f, 1.0f);
            LimboDecay.queueDecay(world, pos, origin, pattern, 40);
            break;
        }
    }

    public static void queueDecay(class_3218 world, class_2338 pos, class_2680 origin, DecayPattern pattern, int delay) {
        DecayTask task = new DecayTask(pos, origin, pattern, delay);
        if (delay <= 0) {
            task.process(world);
        } else {
            DECAY_QUEUE.computeIfAbsent((class_5321<class_1937>)world.method_27983(), k -> new HashSet()).add(task);
        }
    }

    public static void tick(class_3218 world) {
        class_5321 key = world.method_27983();
        if (DECAY_QUEUE.containsKey(key)) {
            Set<DecayTask> tasks = DECAY_QUEUE.get(key);
            Set<DecayTask> tasksToRun = tasks.stream().filter(DecayTask::reduceDelayIsDone).collect(Collectors.toSet());
            tasks.removeAll(tasksToRun);
            tasksToRun.forEach(task -> task.process(world));
        }
    }

    public static class DecayLoader
    implements SimpleSynchronousResourceReloadListener {
        private static final Logger LOGGER = LogManager.getLogger();
        private static final DecayLoader INSTANCE = new DecayLoader();
        private final Map<class_2248, List<DecayPattern>> patterns = new HashMap<class_2248, List<DecayPattern>>();

        private DecayLoader() {
        }

        public static DecayLoader getInstance() {
            return INSTANCE;
        }

        public void method_14491(class_3300 manager) {
            this.patterns.clear();
            CompletableFuture futurePatternList = ResourceUtil.loadResourcePathToCollection(manager, "decay_patterns", ".json", new ArrayList(), ResourceUtil.NBT_READER.andThenReader(this::loadPattern));
            for (DecayPattern pattern : (List)futurePatternList.join()) {
                for (class_2248 block : pattern.constructApplicableBlocks()) {
                    this.patterns.computeIfAbsent(block, b -> new ArrayList());
                    this.patterns.get(block).add(pattern);
                }
            }
        }

        private DecayPattern loadPattern(class_2520 nbt, class_2960 ignored) {
            return DecayPattern.deserialize((class_2487)nbt);
        }

        public Collection<DecayPattern> getPatterns(class_2248 block) {
            return this.patterns.get(block);
        }

        public class_2960 getFabricId() {
            return new class_2960("dimdoors", "decay_pattern");
        }
    }

    private static class DecayTask {
        private final class_2338 pos;
        private final class_2680 origin;
        private final DecayPattern processor;
        private int delay;

        public DecayTask(class_2338 pos, class_2680 origin, DecayPattern processor, int delay) {
            this.pos = pos;
            this.origin = origin;
            this.processor = processor;
            this.delay = delay;
        }

        public boolean reduceDelayIsDone() {
            return --this.delay <= 0;
        }

        public void process(class_3218 world) {
            class_2680 target = world.method_8320(this.pos);
            if (world.method_22340(this.pos) && this.processor.test((class_1937)world, this.pos, this.origin, target)) {
                world.method_18766(class_1301.method_5909((double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), (double)100.0)).forEach(player -> ExtendedServerPlayNetworkHandler.get(player.field_13987).getDimDoorsPacketHandler().sendPacket(new RenderBreakBlockS2CPacket(this.pos, -1)));
                world.method_8465(null, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), target.method_26231().method_10595(), class_3419.field_15245, 0.5f, 1.0f);
                this.processor.process((class_1937)world, this.pos, this.origin, world.method_8320(this.pos));
            }
        }
    }
}

