/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.decay;

import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import org.dimdev.dimdoors.world.decay.DecayPredicate;
import org.dimdev.dimdoors.world.decay.DecayProcessor;

public class DecayPattern {
    public static final Event<EntropyEvent> ENTROPY_EVENT = EventFactory.createArrayBacked(EntropyEvent.class, (world, pos, entorpy) -> {}, entropyEvents -> (world, pos, entorpy) -> {
        for (EntropyEvent event : entropyEvents) {
            event.entropy(world, pos, entorpy);
        }
    });
    private DecayPredicate predicate;
    private DecayProcessor processor;

    public DecayPattern() {
    }

    public DecayPattern(DecayPredicate predicate, DecayProcessor processor) {
        this.predicate = predicate;
        this.processor = processor;
    }

    public static DecayPattern deserialize(class_2487 nbt) {
        DecayPredicate predicate = DecayPredicate.deserialize(nbt.method_10562("predicate"));
        DecayProcessor processor = DecayProcessor.deserialize(nbt.method_10562("processor"));
        return DecayPattern.builder().predicate(predicate).processor(processor).create();
    }

    public boolean test(class_1937 world, class_2338 pos, class_2680 origin, class_2680 target) {
        return this.predicate.test(world, pos, origin, target);
    }

    public void process(class_1937 world, class_2338 pos, class_2680 origin, class_2680 target) {
        ((EntropyEvent)ENTROPY_EVENT.invoker()).entropy(world, pos, this.processor.process(world, pos, origin, target));
    }

    public Set<class_2248> constructApplicableBlocks() {
        return this.predicate.constructApplicableBlocks();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private DecayPredicate predicate = DecayPredicate.NONE;
        private DecayProcessor processor = DecayProcessor.NONE;

        public Builder predicate(DecayPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder processor(DecayProcessor processor) {
            this.processor = processor;
            return this;
        }

        public DecayPattern create() {
            return new DecayPattern(this.predicate, this.processor);
        }
    }

    private static interface EntropyEvent {
        public void entropy(class_1937 var1, class_2338 var2, int var3);
    }
}

