/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.util.schematic;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_5281;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.util.schematic.RelativeBlockSample;
import org.dimdev.dimdoors.util.schematic.Schematic;

public final class SchematicPlacer {
    public static final Logger LOGGER = LogManager.getLogger();

    private SchematicPlacer() {
    }

    public static void place(Schematic schematic, class_5281 world, class_2338 origin, BlockPlacementType placementType) {
        LOGGER.debug("Placing schematic: {}", (Object)schematic.getMetadata().getName());
        for (String id : schematic.getMetadata().getRequiredMods()) {
            if (FabricLoader.getInstance().isModLoaded(id)) continue;
            LOGGER.warn("Schematic \"" + schematic.getMetadata().getName() + "\" depends on mod \"" + id + "\", which is missing!");
        }
        RelativeBlockSample blockSample = Schematic.getBlockSample(schematic);
        blockSample.place(origin, world, placementType, false);
    }

    public static Map<class_2338, RiftBlockEntity> getAbsoluteRifts(Schematic schematic, class_2338 origin) {
        RelativeBlockSample blockSample = Schematic.getBlockSample(schematic);
        return blockSample.getAbsoluteRifts(origin);
    }

    public static void place(Schematic schematic, class_3218 world, class_2791 chunk, class_2338 origin, BlockPlacementType placementType) {
        LOGGER.debug("Placing schematic: {}", (Object)schematic.getMetadata().getName());
        for (String id : schematic.getMetadata().getRequiredMods()) {
            if (FabricLoader.getInstance().isModLoaded(id)) continue;
            LOGGER.warn("Schematic \"" + schematic.getMetadata().getName() + "\" depends on mod \"" + id + "\", which is missing!");
        }
        RelativeBlockSample blockSample = Schematic.getBlockSample(schematic);
        blockSample.place(origin, world, chunk, placementType, false);
    }

    public static int[][][] getBlockData(Schematic schematic) {
        int width = schematic.getWidth();
        int height = schematic.getHeight();
        int length = schematic.getLength();
        byte[] blockDataIntArray = schematic.getBlockData().array();
        int[][][] blockData = new int[width][height][length];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    blockData[x][y][z] = blockDataIntArray[x + z * width + y * width * length];
                }
            }
        }
        return blockData;
    }

    public static int[][] getBiomeData(Schematic schematic) {
        int width = schematic.getWidth();
        int length = schematic.getLength();
        byte[] biomeDataArray = schematic.getBiomeData().array();
        if (biomeDataArray.length == 0) {
            return new int[0][0];
        }
        int[][] biomeData = new int[width][length];
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                biomeData[x][z] = biomeDataArray[x + z * width];
            }
        }
        return biomeData;
    }

    private static void placeEntities(int originX, int originY, int originZ, Schematic schematic, class_5281 world) {
        List<class_2487> entityNbts = schematic.getEntities();
        for (class_2487 nbt : entityNbts) {
            class_2499 nbtList = Objects.requireNonNull(nbt.method_10554("Pos", 6), "Entity in schematic  \"" + schematic.getMetadata().getName() + "\" did not have a Pos nbt list!");
            SchematicPlacer.processPos(nbtList, originX, originY, originZ, nbt);
            class_1299 entityType = (class_1299)class_1299.method_17684((class_2487)nbt).orElseThrow(AssertionError::new);
            class_1297 e = entityType.method_5883((class_1937)world.method_8410());
            if (e == null) continue;
            e.method_5651(nbt);
            world.method_30771(e);
        }
    }

    public static class_2487 fixEntityId(class_2487 nbt) {
        if (!nbt.method_10545("Id") && nbt.method_10545("id")) {
            nbt.method_10582("Id", nbt.method_10558("id"));
        } else if (nbt.method_10545("Id") && !nbt.method_10545("id")) {
            nbt.method_10582("id", nbt.method_10558("Id"));
        }
        if (!nbt.method_10545("Id") || !nbt.method_10545("id")) {
            System.err.println("An unexpected error occurred parsing this entity");
            System.err.println(nbt.toString());
            throw new IllegalStateException("Entity did not have an 'Id' nbt string, nor an 'id' nbt string!");
        }
        return nbt;
    }

    private static void processPos(class_2499 nbtList, int originX, int originY, int originZ, class_2487 nbt) {
        double x = nbtList.method_10611(0);
        double y = nbtList.method_10611(1);
        double z = nbtList.method_10611(2);
        nbt.method_10551("Pos");
        nbt.method_10566("Pos", class_2509.field_11560.method_10665(Stream.of(class_2489.method_23241((double)(x + (double)originX)), class_2489.method_23241((double)(y + (double)originY)), class_2489.method_23241((double)(z + (double)originZ)))));
    }
}

