/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.util.schematic;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3610;
import net.minecraft.class_5281;
import org.dimdev.dimdoors.api.util.BlockBoxUtil;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.util.schematic.SchematicPlacer;
import org.jetbrains.annotations.Nullable;

public class RelativeBlockSample
implements class_1922,
class_1945 {
    public final Schematic schematic;
    private final int[][][] blockData;
    private final int[][] biomeData;
    private final BiMap<class_2680, Integer> blockPalette;
    private final BiMap<class_1959, Integer> biomePalette;
    private final Map<class_2338, class_2680> blockContainer;
    private final Map<class_2338, class_1959> biomeContainer;
    private final Map<class_2338, class_2487> blockEntityContainer;
    private final BiMap<class_2487, class_243> entityContainer;

    public RelativeBlockSample(Schematic schematic) {
        int x;
        this.schematic = schematic;
        this.blockData = SchematicPlacer.getBlockData(schematic);
        this.biomeData = SchematicPlacer.getBiomeData(schematic);
        this.blockPalette = ImmutableBiMap.copyOf(schematic.getBlockPalette());
        this.biomePalette = ImmutableBiMap.copyOf(schematic.getBiomePalette());
        this.blockContainer = Maps.newHashMap();
        this.biomeContainer = Maps.newHashMap();
        this.blockEntityContainer = Maps.newHashMap();
        int width = schematic.getWidth();
        int height = schematic.getHeight();
        int length = schematic.getLength();
        for (x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    this.method_8652(new class_2338(x, y, z), (class_2680)this.blockPalette.inverse().get((Object)this.blockData[x][y][z]), 2);
                }
            }
        }
        if (this.hasBiomes()) {
            for (x = 0; x < width; ++x) {
                for (int z = 0; z < length; ++z) {
                    this.biomeContainer.put(new class_2338(x, 0, z), (class_1959)this.biomePalette.inverse().get((Object)this.biomeData[x][z]));
                }
            }
        }
        for (class_2487 blockEntityNbt : schematic.getBlockEntities()) {
            int[] arr = blockEntityNbt.method_10561("Pos");
            class_2338 position = new class_2338(arr[0], arr[1], arr[2]);
            this.blockEntityContainer.put(position, blockEntityNbt);
        }
        this.entityContainer = HashBiMap.create();
        for (class_2487 entityNbt : schematic.getEntities()) {
            class_2499 doubles = entityNbt.method_10554("Pos", 6);
            this.entityContainer.put((Object)entityNbt, (Object)new class_243(doubles.method_10611(0), doubles.method_10611(1), doubles.method_10611(2)));
        }
    }

    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        class_2680 blockState = this.method_8320(pos);
        if (blockState.method_26204() instanceof class_2343) {
            return ((class_2343)blockState.method_26204()).method_10123(pos, blockState);
        }
        return null;
    }

    public class_2680 method_8320(class_2338 pos) {
        return this.blockContainer.get(pos);
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.blockContainer.get(pos).method_26227();
    }

    public void place(class_2338 origin, class_5281 world, BlockPlacementType placementType, boolean biomes) {
        this.blockContainer.forEach((pos, state) -> {
            class_2338 actualPos = origin.method_10081((class_2382)pos);
            world.method_30092(actualPos, state, 0, 0);
            if (placementType.shouldMarkForUpdate()) {
                ((class_3218)world).method_14178().method_14128(actualPos);
            }
        });
        for (Map.Entry<class_2338, class_2487> entry : this.blockEntityContainer.entrySet()) {
            class_2586 blockEntity;
            class_2338 pos2 = entry.getKey();
            class_2338 actualPos = origin.method_10081((class_2382)entry.getKey());
            class_2487 nbt = entry.getValue();
            if (nbt.method_10545("Id")) {
                nbt.method_10566("id", nbt.method_10580("Id"));
                nbt.method_10551("Id");
            }
            if ((blockEntity = class_2586.method_11005((class_2338)actualPos, (class_2680)this.method_8320(pos2), (class_2487)nbt)) == null) continue;
            placementType.getBlockEntityPlacer().accept((class_1937)world.method_8410(), blockEntity);
        }
        for (Map.Entry<Object, Object> entry : this.entityContainer.entrySet()) {
            class_2487 nbt = (class_2487)entry.getKey();
            class_2499 doubles = nbt.method_10554("Pos", 6);
            class_243 vec = ((class_243)entry.getValue()).method_1031((double)origin.method_10263(), (double)origin.method_10264(), (double)origin.method_10260());
            doubles.method_10606(0, class_2509.field_11560.method_10652(vec.field_1352));
            doubles.method_10606(1, class_2509.field_11560.method_10652(vec.field_1351));
            doubles.method_10606(2, class_2509.field_11560.method_10652(vec.field_1350));
            nbt.method_10566("Pos", (class_2520)doubles);
            class_1297 entity = (class_1297)class_1299.method_5892((class_2487)nbt, (class_1937)world.method_8410()).orElseThrow(NoSuchElementException::new);
            world.method_8649(entity);
        }
    }

    public void place(class_2338 origin, class_3218 world, class_2791 chunk, BlockPlacementType placementType, boolean biomes) {
        class_1923 pos = chunk.method_12004();
        class_3341 chunkBox = BlockBoxUtil.getBox(chunk);
        class_2382 schemDimensions = new class_2382((int)this.schematic.getWidth(), (int)this.schematic.getHeight(), (int)this.schematic.getLength());
        class_3341 schemBox = class_3341.method_34390((class_2382)origin, (class_2382)origin.method_10081(schemDimensions).method_10069(-1, -1, -1));
        if (!schemBox.method_14657(chunkBox)) {
            return;
        }
        class_3341 intersection = BlockBoxUtil.intersect(schemBox, chunkBox);
        class_3215 serverChunkManager = world.method_14178();
        class_2826[] sections = chunk.method_12006();
        if (placementType.useSection()) {
            class_2338.method_23627((class_3341)intersection).forEach(blockPos -> {
                class_2680 newState;
                int x = Math.floorMod(blockPos.method_10263(), 16);
                int y = Math.floorMod(blockPos.method_10264(), 16);
                int z = Math.floorMod(blockPos.method_10260(), 16);
                int sectionY = chunk.method_31602(blockPos.method_10264());
                class_2826 section = sections[sectionY];
                if (section == null) {
                    sections[sectionY] = section = new class_2826(sectionY, world.method_30349().method_30530(class_2378.field_25114));
                }
                if (section.method_12254(x, y, z).method_26215() && !(newState = this.blockContainer.get(blockPos.method_10059((class_2382)origin))).method_26215()) {
                    section.method_12256(x, y, z, newState, false);
                    if (placementType.shouldMarkForUpdate()) {
                        serverChunkManager.method_14128(blockPos);
                    }
                }
            });
        } else {
            class_2338.method_23627((class_3341)intersection).forEach(blockPos -> {
                class_2680 newState;
                if (chunk.method_8320(blockPos).method_26215() && !(newState = this.blockContainer.get(blockPos.method_10059((class_2382)origin))).method_26215()) {
                    chunk.method_12010(blockPos, newState, false);
                }
            });
        }
        serverChunkManager.method_17293().method_17310(chunk, false);
        this.blockEntityContainer.forEach((blockPos, nbt) -> {
            class_2338 actualPos = blockPos.method_10081((class_2382)origin);
            if (intersection.method_14662((class_2382)actualPos)) {
                class_2586 blockEntity;
                if (nbt.method_10545("Id")) {
                    nbt.method_10566("id", nbt.method_10580("Id"));
                    nbt.method_10551("Id");
                }
                if ((blockEntity = class_2586.method_11005((class_2338)actualPos, (class_2680)this.method_8320((class_2338)blockPos), (class_2487)nbt)) != null && !(blockEntity instanceof RiftBlockEntity)) {
                    chunk.method_12007(blockEntity);
                }
            }
        });
        this.entityContainer.forEach((nbt, vec3d) -> {
            class_2499 doubles = nbt.method_10554("Pos", 6);
            class_243 vec = vec3d.method_1031((double)origin.method_10263(), (double)origin.method_10264(), (double)origin.method_10260());
            if (intersection.method_14662(new class_2382(vec.field_1352, vec.field_1351, vec.field_1350))) {
                doubles.method_10606(0, class_2509.field_11560.method_10652(vec.field_1352));
                doubles.method_10606(1, class_2509.field_11560.method_10652(vec.field_1351));
                doubles.method_10606(2, class_2509.field_11560.method_10652(vec.field_1350));
                nbt.method_10566("Pos", (class_2520)doubles);
                class_1297 entity = (class_1297)class_1299.method_5892((class_2487)nbt, (class_1937)world.method_8410()).orElseThrow(NoSuchElementException::new);
                world.method_8649(entity);
            }
        });
    }

    public Map<class_2338, RiftBlockEntity> getAbsoluteRifts(class_2338 origin) {
        HashMap<class_2338, RiftBlockEntity> rifts = new HashMap<class_2338, RiftBlockEntity>();
        this.blockEntityContainer.forEach((blockPos, nbt) -> {
            class_2680 state;
            class_2586 blockEntity;
            class_2338 actualPos = origin.method_10081((class_2382)blockPos);
            if (nbt.method_10545("Id")) {
                nbt.method_10566("id", nbt.method_10580("Id"));
                nbt.method_10551("Id");
            }
            if ((blockEntity = class_2586.method_11005((class_2338)actualPos, (class_2680)(state = this.method_8320((class_2338)blockPos)), (class_2487)nbt)) instanceof RiftBlockEntity) {
                rifts.put(actualPos, (RiftBlockEntity)blockEntity);
            }
        });
        return rifts;
    }

    public int[][][] getBlockData() {
        return this.blockData;
    }

    public BiMap<class_2680, Integer> getBlockPalette() {
        return this.blockPalette;
    }

    public Map<class_2338, class_2680> getBlockContainer() {
        return this.blockContainer;
    }

    public Map<class_2338, class_2487> getBlockEntityContainer() {
        return this.blockEntityContainer;
    }

    public boolean method_30092(class_2338 pos, class_2680 state, int flags, int maxUpdateDepth) {
        this.blockContainer.put(pos, state);
        return true;
    }

    public boolean method_8650(class_2338 pos, boolean move) {
        return this.method_8652(pos, class_2246.field_10124.method_9564(), 2);
    }

    public boolean method_30093(class_2338 pos, boolean drop, @Nullable class_1297 breakingEntity, int maxUpdateDepth) {
        return this.method_8652(pos, class_2246.field_10124.method_9564(), 2);
    }

    public boolean hasBiomes() {
        return this.biomeData.length != 0;
    }

    public int method_31605() {
        return this.schematic.getHeight();
    }

    public int method_31607() {
        return 0;
    }
}

