/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_2379;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RGBA;
import org.dimdev.dimdoors.pockets.PocketGenerator;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.PrivatePocket;

public class PrivatePocketTarget
extends VirtualTarget
implements EntityTarget {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final RGBA COLOR = new RGBA(0.0f, 1.0f, 0.0f, 1.0f);

    @Override
    public boolean receiveEntity(class_1297 entity, class_243 relativePos, class_2379 relativeAngle, class_243 relativeVelocity) {
        UUID uuid = EntityUtils.getOwner(entity).method_5667();
        VirtualLocation virtualLocation = VirtualLocation.fromLocation(this.location);
        if (uuid != null) {
            PrivatePocket pocket = DimensionalRegistry.getPrivateRegistry().getPrivatePocket(uuid);
            if (pocket == null) {
                Pocket unknownTypePocket = PocketGenerator.generatePrivatePocketV2(new VirtualLocation(virtualLocation.getWorld(), virtualLocation.getX(), virtualLocation.getZ(), -1));
                if (!(unknownTypePocket instanceof PrivatePocket)) {
                    throw new RuntimeException("Pocket generated for private pocket is not of type PrivatePocket");
                }
                pocket = (PrivatePocket)unknownTypePocket;
                DimensionalRegistry.getPrivateRegistry().setPrivatePocketID(uuid, pocket);
                class_2586 be = DimensionalRegistry.getRiftRegistry().getPocketEntrance(pocket).getBlockEntity();
                this.processEntity(pocket, be, entity, uuid, relativePos, relativeAngle, relativeVelocity);
            } else {
                Location destLoc = DimensionalRegistry.getRiftRegistry().getPrivatePocketEntrance(uuid);
                if (destLoc == null) {
                    destLoc = DimensionalRegistry.getRiftRegistry().getPocketEntrance(pocket);
                }
                if (destLoc == null) {
                    LOGGER.info("All entrances are gone, creating a new private pocket!");
                    Pocket unknownTypePocket = PocketGenerator.generatePrivatePocketV2(new VirtualLocation(virtualLocation.getWorld(), virtualLocation.getX(), virtualLocation.getZ(), -1));
                    if (!(unknownTypePocket instanceof PrivatePocket)) {
                        throw new RuntimeException("Pocket generated for private pocket is not of type PrivatePocket");
                    }
                    pocket = (PrivatePocket)unknownTypePocket;
                    DimensionalRegistry.getPrivateRegistry().setPrivatePocketID(uuid, pocket);
                    destLoc = DimensionalRegistry.getRiftRegistry().getPocketEntrance(pocket);
                }
                this.processEntity(pocket, destLoc.getBlockEntity(), entity, uuid, relativePos, relativeAngle, relativeVelocity);
            }
            return true;
        }
        return false;
    }

    private void processEntity(PrivatePocket pocket, class_2586 blockEntity, class_1297 entity, UUID uuid, class_243 relativePos, class_2379 relativeAngle, class_243 relativeVelocity) {
        if (entity instanceof class_1542) {
            class_1792 item = ((class_1542)entity).method_6983().method_7909();
            if (item instanceof class_1769) {
                if (pocket.addDye(EntityUtils.getOwner(entity), ((class_1769)item).method_7802())) {
                    entity.method_5650(class_1297.class_5529.field_26999);
                } else {
                    ((EntityTarget)blockEntity).receiveEntity(entity, relativePos, relativeAngle, relativeVelocity);
                }
            } else {
                ((EntityTarget)blockEntity).receiveEntity(entity, relativePos, relativeAngle, relativeVelocity);
            }
        } else {
            ((EntityTarget)blockEntity).receiveEntity(entity, relativePos, relativeAngle, relativeVelocity);
            DimensionalRegistry.getRiftRegistry().setLastPrivatePocketExit(uuid, this.location);
        }
    }

    @Override
    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return VirtualTarget.VirtualTargetType.PRIVATE;
    }
}

