/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2379;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RGBA;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.PrivatePocket;

public class PrivatePocketExitTarget
extends VirtualTarget
implements EntityTarget {
    public static final RGBA COLOR = new RGBA(0.0f, 1.0f, 0.0f, 1.0f);

    @Override
    public boolean receiveEntity(class_1297 entity, class_243 relativePos, class_2379 relativeAngle, class_243 relativeVelocity) {
        UUID uuid = EntityUtils.getOwner(entity).method_5667();
        if (uuid != null) {
            Location destLoc = DimensionalRegistry.getRiftRegistry().getPrivatePocketExit(uuid);
            PrivatePocket pocket = DimensionalRegistry.getPrivateRegistry().getPrivatePocket(uuid);
            if (ModDimensions.isPrivatePocketDimension((class_1937)this.location.getWorld()) && pocket != null && DimensionalRegistry.getPocketDirectory(pocket.getWorld()).getPocketAt(this.location.pos).equals(pocket)) {
                DimensionalRegistry.getRiftRegistry().setLastPrivatePocketEntrance(uuid, this.location);
            }
            if (destLoc == null || !(destLoc.getBlockEntity() instanceof RiftBlockEntity)) {
                if (destLoc == null) {
                    EntityUtils.chat(entity, (class_2561)new class_2588("rifts.destinations.private_pocket_exit.did_not_use_rift"));
                } else {
                    EntityUtils.chat(entity, (class_2561)new class_2588("rifts.destinations.private_pocket_exit.rift_has_closed"));
                }
                return false;
            }
            ((EntityTarget)destLoc.getBlockEntity()).receiveEntity(entity, relativePos, relativeAngle, relativeVelocity);
            return true;
        }
        return false;
    }

    @Override
    public void register() {
        super.register();
        PocketDirectory privatePocketRegistry = DimensionalRegistry.getPocketDirectory(this.location.world);
        Pocket pocket = privatePocketRegistry.getPocketAt(this.location.pos);
        DimensionalRegistry.getRiftRegistry().addPocketEntrance(pocket, this.location);
    }

    @Override
    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return VirtualTarget.VirtualTargetType.PRIVATE_POCKET_EXIT;
    }
}

