/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import net.minecraft.class_1297;
import net.minecraft.class_2379;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;

public class PocketEntranceMarker
extends VirtualTarget
implements EntityTarget {
    private final float weight;
    private final VirtualTarget ifDestination;
    private final VirtualTarget otherwiseDestination;

    public PocketEntranceMarker() {
        this(1.0f, VirtualTarget.NoneTarget.INSTANCE, VirtualTarget.NoneTarget.INSTANCE);
    }

    public PocketEntranceMarker(float weight, VirtualTarget ifDestination, VirtualTarget otherwiseDestination) {
        this.weight = weight;
        this.ifDestination = ifDestination;
        this.otherwiseDestination = otherwiseDestination;
    }

    public static PocketEntranceMarkerBuilder builder() {
        return new PocketEntranceMarkerBuilder();
    }

    @Override
    public boolean receiveEntity(class_1297 entity, class_243 relativePos, class_2379 relativeAngle, class_243 relativeVelocity) {
        EntityUtils.chat(entity, (class_2561)new class_2588("The entrance of this dungeon has not been converted. If this is a normally generated pocket, please report this bug."));
        return false;
    }

    public float getWeight() {
        return this.weight;
    }

    public VirtualTarget getIfDestination() {
        return this.ifDestination;
    }

    public VirtualTarget getOtherwiseDestination() {
        return this.otherwiseDestination;
    }

    public String toString() {
        return "PocketEntranceMarker(weight=" + this.getWeight() + ", ifDestination=" + this.getIfDestination() + ", otherwiseDestination=" + this.getOtherwiseDestination() + ")";
    }

    public PocketEntranceMarkerBuilder toBuilder() {
        return new PocketEntranceMarkerBuilder().weight(this.weight).ifDestination(this.ifDestination).otherwiseDestination(this.otherwiseDestination);
    }

    @Override
    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return VirtualTarget.VirtualTargetType.POCKET_ENTRANCE;
    }

    public static class_2487 toNbt(PocketEntranceMarker target) {
        class_2487 nbt = new class_2487();
        nbt.method_10548("weight", target.weight);
        nbt.method_10566("ifDestination", (class_2520)VirtualTarget.toNbt(target.ifDestination));
        nbt.method_10566("otherwiseDestination", (class_2520)VirtualTarget.toNbt(target.otherwiseDestination));
        return nbt;
    }

    public static PocketEntranceMarker fromNbt(class_2487 nbt) {
        return PocketEntranceMarker.builder().weight(nbt.method_10583("weight")).ifDestination(nbt.method_10545("ifDestination") ? VirtualTarget.fromNbt(nbt.method_10562("ifDestination")) : VirtualTarget.NoneTarget.INSTANCE).otherwiseDestination(nbt.method_10545("otherwiseDestination") ? VirtualTarget.fromNbt(nbt.method_10562("otherwiseDestination")) : VirtualTarget.NoneTarget.INSTANCE).build();
    }

    public static class PocketEntranceMarkerBuilder {
        private float weight;
        private VirtualTarget ifDestination = VirtualTarget.NoneTarget.INSTANCE;
        private VirtualTarget otherwiseDestination = VirtualTarget.NoneTarget.INSTANCE;

        private PocketEntranceMarkerBuilder() {
        }

        public PocketEntranceMarkerBuilder weight(float weight) {
            this.weight = weight;
            return this;
        }

        public PocketEntranceMarkerBuilder ifDestination(VirtualTarget ifDestination) {
            this.ifDestination = ifDestination;
            return this;
        }

        public PocketEntranceMarkerBuilder otherwiseDestination(VirtualTarget otherwiseDestination) {
            this.otherwiseDestination = otherwiseDestination;
            return this;
        }

        public PocketEntranceMarker build() {
            return new PocketEntranceMarker(this.weight, this.ifDestination, this.otherwiseDestination);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("weight", this.weight).append("ifDestination", (Object)this.ifDestination).append("otherwiseDestination", (Object)this.otherwiseDestination).toString();
        }
    }
}

