/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.rift.target.EntityTarget;
import org.dimdev.dimdoors.api.util.EntityUtils;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.UnravelUtil;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.ModDimensions;

public class EscapeTarget
extends VirtualTarget
implements EntityTarget {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Codec<EscapeTarget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("canEscapeLimbo").forGetter(target -> target.canEscapeLimbo)).apply((Applicative)instance, EscapeTarget::new));
    protected final boolean canEscapeLimbo;

    public EscapeTarget(boolean canEscapeLimbo) {
        this.canEscapeLimbo = canEscapeLimbo;
    }

    @Override
    public boolean receiveEntity(class_1297 entity, class_243 relativePos, class_2379 relativeAngle, class_243 relativeVelocity) {
        if (!ModDimensions.isPocketDimension(entity.field_6002) && !ModDimensions.isLimboDimension(entity.field_6002)) {
            EntityUtils.chat(entity, (class_2561)new class_2588("rifts.destinations.escape.not_in_pocket_dim"));
            return false;
        }
        if (ModDimensions.isLimboDimension(entity.field_6002) && !this.canEscapeLimbo) {
            EntityUtils.chat(entity, (class_2561)new class_2588("rifts.destinations.escape.cannot_escape_limbo"));
            return false;
        }
        if (entity.method_5770().field_9236) {
            return false;
        }
        UUID uuid = entity.method_5667();
        if (uuid != null) {
            if (entity.field_6002.method_18470(uuid) == null) {
                LOGGER.log(Level.ERROR, "Tried to get player for escape target from uuid, but player does not exist, uh oh");
                return false;
            }
            LOGGER.log(Level.INFO, "sending player from limbo to their spawnpoint, good luck!");
            Location destLoc = ((class_3222)entity.field_6002.method_18470(uuid)).method_26280() != null ? new Location((class_5321<class_1937>)((class_3222)entity.field_6002.method_18470(uuid)).method_26281(), ((class_3222)entity.field_6002.method_18470(uuid)).method_26280()) : new Location(DimensionalDoorsInitializer.getServer().method_30002(), DimensionalDoorsInitializer.getServer().method_30002().method_27911());
            if (destLoc != null && this.canEscapeLimbo) {
                Location location = destLoc;
                entity = TeleportUtil.teleport(entity, (class_1937)location.getWorld(), location.getBlockPos(), relativeAngle, relativeVelocity);
                entity.field_6017 = 0.0f;
                Random random = new Random();
                class_2338.method_25996((class_2338)location.pos.method_10069(0, -3, 0), (int)3, (int)2, (int)3).forEach(pos1 -> {
                    if (random.nextFloat() < 1.0f / (float)location.pos.method_10262((class_2382)pos1) * DimensionalDoorsInitializer.getConfig().getLimboConfig().limboBlocksCorruptingOverworldAmount) {
                        class_2248 block = location.getWorld().method_8320(pos1).method_26204();
                        if (UnravelUtil.unravelBlocksMap.containsKey(block)) {
                            location.getWorld().method_8501(pos1, UnravelUtil.unravelBlocksMap.get(block).method_9564());
                        } else if (UnravelUtil.whitelistedBlocksForLimboRemoval.contains(block)) {
                            location.getWorld().method_8501(pos1, ModBlocks.UNRAVELLED_FABRIC.method_9564());
                        }
                    }
                });
            } else {
                if (destLoc == null) {
                    EntityUtils.chat(entity, (class_2561)new class_2588("rifts.destinations.escape.did_not_use_rift"));
                } else {
                    EntityUtils.chat(entity, (class_2561)new class_2588("rifts.destinations.escape.rift_has_closed"));
                }
                if (ModDimensions.LIMBO_DIMENSION != null) {
                    entity = TeleportUtil.teleport(entity, (class_1937)ModDimensions.LIMBO_DIMENSION, new class_2338(this.location.getX(), this.location.getY(), this.location.getZ()), relativeAngle, relativeVelocity);
                    entity.field_6017 = 0.0f;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return VirtualTarget.VirtualTargetType.ESCAPE;
    }

    public static class_2487 toNbt(EscapeTarget virtualTarget) {
        class_2487 nbt = new class_2487();
        nbt.method_10556("canEscapeLimbo", virtualTarget.canEscapeLimbo);
        return nbt;
    }

    public static EscapeTarget fromNbt(class_2487 nbt) {
        return new EscapeTarget(nbt.method_10577("canEscapeLimbo"));
    }
}

