/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.rift.targets;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.dimdev.dimdoors.api.rift.target.Target;
import org.dimdev.dimdoors.pockets.PocketGenerator;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.targets.GlobalReference;
import org.dimdev.dimdoors.rift.targets.RandomTarget;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.pocket.VirtualLocation;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class DungeonTarget
extends RandomTarget {
    private final class_2960 dungeonGroup;

    public DungeonTarget(float newRiftWeight, double weightMaximum, double coordFactor, double positiveDepthFactor, double negativeDepthFactor, Set<Integer> acceptedGroups, boolean noLink, boolean noLinkBack, class_2960 dungeonGroup) {
        super(newRiftWeight, weightMaximum, coordFactor, positiveDepthFactor, negativeDepthFactor, acceptedGroups, noLink, noLinkBack);
        this.dungeonGroup = dungeonGroup;
    }

    @Override
    protected Pocket generatePocket(VirtualLocation location, GlobalReference linkTo, LinkProperties props) {
        return PocketGenerator.generateDungeonPocketV2(location, linkTo, props, this.dungeonGroup);
    }

    public static class_2487 toNbt(DungeonTarget target) {
        class_2487 nbt = RandomTarget.toNbt(target);
        nbt.method_10582("dungeonGroup", target.dungeonGroup.toString());
        return nbt;
    }

    public static DungeonTargetBuilder builder() {
        return new DungeonTargetBuilder();
    }

    public static DungeonTarget fromNbt(class_2487 nbt) {
        return new DungeonTarget(nbt.method_10583("newRiftWeight"), nbt.method_10574("weightMaximum"), nbt.method_10574("coordFactor"), nbt.method_10574("positiveDepthFactor"), nbt.method_10574("negativeDepthFactor"), Arrays.stream(nbt.method_10561("acceptedGroups")).boxed().collect(Collectors.toSet()), nbt.method_10577("noLink"), nbt.method_10577("noLinkBack"), new class_2960(nbt.method_10558("dungeonGroup")));
    }

    @Override
    public VirtualTarget.VirtualTargetType<? extends VirtualTarget> getType() {
        return VirtualTarget.VirtualTargetType.DUNGEON;
    }

    @Override
    public Target receiveOther() {
        return super.receiveOther();
    }

    public static class DungeonTargetBuilder
    extends RandomTarget.RandomTargetBuilder {
        private class_2960 dungeonGroup = PocketGenerator.ALL_DUNGEONS;

        DungeonTargetBuilder() {
        }

        public void dungeonGroup(class_2960 dungeonGroup) {
            this.dungeonGroup = dungeonGroup;
        }

        @Override
        public DungeonTargetBuilder newRiftWeight(float newRiftWeight) {
            return (DungeonTargetBuilder)super.newRiftWeight(newRiftWeight);
        }

        @Override
        public DungeonTargetBuilder weightMaximum(double weightMaximum) {
            return (DungeonTargetBuilder)super.weightMaximum(weightMaximum);
        }

        @Override
        public DungeonTargetBuilder coordFactor(double coordFactor) {
            return (DungeonTargetBuilder)super.coordFactor(coordFactor);
        }

        @Override
        public DungeonTargetBuilder positiveDepthFactor(double positiveDepthFactor) {
            return (DungeonTargetBuilder)super.positiveDepthFactor(positiveDepthFactor);
        }

        @Override
        public DungeonTargetBuilder negativeDepthFactor(double negativeDepthFactor) {
            return (DungeonTargetBuilder)super.negativeDepthFactor(negativeDepthFactor);
        }

        @Override
        public DungeonTargetBuilder acceptedGroups(Set<Integer> acceptedGroups) {
            return (DungeonTargetBuilder)super.acceptedGroups(acceptedGroups);
        }

        @Override
        public DungeonTargetBuilder noLink(boolean noLink) {
            return (DungeonTargetBuilder)super.noLink(noLink);
        }

        @Override
        public DungeonTargetBuilder noLinkBack(boolean noLinkBack) {
            return (DungeonTargetBuilder)super.noLinkBack(noLinkBack);
        }

        @Override
        public DungeonTarget build() {
            return new DungeonTarget(this.newRiftWeight, this.weightMaximum, this.coordFactor, this.positiveDepthFactor, this.negativeDepthFactor, this.acceptedGroups, this.noLink, this.noLinkBack, this.dungeonGroup);
        }
    }
}

