/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.virtual.reference;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2791;
import net.minecraft.class_3193;
import net.minecraft.class_3738;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.generator.LazyPocketGenerator;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.pockets.modifier.LazyCompatibleModifier;
import org.dimdev.dimdoors.pockets.modifier.LazyModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.pockets.virtual.ImplementedVirtualPocket;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public abstract class PocketGeneratorReference
implements ImplementedVirtualPocket {
    private static final Logger LOGGER = LogManager.getLogger();
    protected String weight;
    protected Equation weightEquation;
    protected Boolean setupLoot;
    protected final List<Modifier> modifierList = Lists.newArrayList();
    protected final List<class_2487> addons = new ArrayList<class_2487>();

    private void parseWeight() {
        try {
            this.weightEquation = Equation.parse(this.weight);
        }
        catch (Equation.EquationParseException e) {
            LOGGER.debug("Defaulting to default weight equation for {}", (Object)this);
            LOGGER.debug("Exception Stacktrace", (Throwable)e);
            try {
                this.weightEquation = Equation.parse(DimensionalDoorsInitializer.getConfig().getPocketsConfig().defaultWeightEquation);
            }
            catch (Equation.EquationParseException equationParseException) {
                LOGGER.debug("Defaulting to default weight equation for {}", (Object)this);
                LOGGER.debug("Exception Stacktrace", (Throwable)e);
                this.weightEquation = stringDoubleMap -> DimensionalDoorsInitializer.getConfig().getPocketsConfig().fallbackWeight;
            }
        }
    }

    @Override
    public ImplementedVirtualPocket fromNbt(class_2487 nbt) {
        int i;
        if (nbt.method_10545("weight")) {
            this.weight = nbt.method_10558("weight");
            this.parseWeight();
        }
        if (nbt.method_10545("setup_loot")) {
            this.setupLoot = nbt.method_10577("setup_loot");
        }
        if (nbt.method_10545("modifiers")) {
            class_2499 modifiersNbt = nbt.method_10554("modifiers", 10);
            for (i = 0; i < modifiersNbt.size(); ++i) {
                this.modifierList.add(Modifier.deserialize(modifiersNbt.method_10602(i)));
            }
        }
        if (nbt.method_10573("addons", 9)) {
            class_2499 addonsNbt = nbt.method_10554("addons", 10);
            for (i = 0; i < addonsNbt.size(); ++i) {
                this.addons.add(addonsNbt.method_10602(i));
            }
        }
        return this;
    }

    @Override
    public class_2487 toNbt(class_2487 nbt) {
        ImplementedVirtualPocket.super.toNbt(nbt);
        if (this.weight != null) {
            nbt.method_10582("weight", this.weight);
        }
        if (this.setupLoot != null) {
            nbt.method_10556("setup_loot", this.setupLoot.booleanValue());
        }
        class_2499 modifiersNbt = new class_2499();
        for (Modifier modifier : this.modifierList) {
            modifiersNbt.add((Object)modifier.toNbt(new class_2487()));
        }
        if (modifiersNbt.size() > 0) {
            nbt.method_10566("modifiers", (class_2520)modifiersNbt);
        }
        class_2499 addonsNbt = new class_2499();
        addonsNbt.addAll(this.addons);
        if (addonsNbt.size() > 0) {
            nbt.method_10566("addons", (class_2520)addonsNbt);
        }
        return nbt;
    }

    @Override
    public double getWeight(PocketGenerationContext parameters) {
        try {
            return this.weightEquation != null ? this.weightEquation.apply(parameters.toVariableMap(Maps.newHashMap())) : this.peekReferencedPocketGenerator(parameters).getWeight(parameters);
        }
        catch (RuntimeException e) {
            LOGGER.error(this.toString());
            throw new AssertionError((Object)e);
        }
    }

    public void applyModifiers(PocketGenerationContext parameters, RiftManager manager) {
        for (Modifier modifier : this.modifierList) {
            modifier.apply(parameters, manager);
        }
    }

    public void applyModifiers(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        for (Modifier modifier : this.modifierList) {
            modifier.apply(parameters, builder);
        }
    }

    @Override
    public Pocket prepareAndPlacePocket(PocketGenerationContext parameters) {
        PocketGenerator generator = this.getReferencedPocketGenerator(parameters);
        Object builder = generator.pocketBuilder(parameters).virtualLocation(parameters.sourceVirtualLocation());
        generator.applyModifiers(parameters, (Pocket.PocketBuilder<?, ?>)builder);
        this.applyModifiers(parameters, (Pocket.PocketBuilder<?, ?>)builder);
        LazyPocketGenerator.currentlyGenerating = true;
        Set<class_2791> alreadyLoadedChunks = StreamSupport.stream(parameters.world().method_14178().field_17254.method_17264().spliterator(), false).map(class_3193::method_16144).filter(Objects::nonNull).collect(Collectors.toSet());
        Pocket pocket = generator.prepareAndPlacePocket(parameters, (Pocket.PocketBuilder<?, ?>)builder);
        class_2338 originalOrigin = pocket.getOrigin();
        RiftManager manager = generator.getRiftManager(pocket);
        generator.applyModifiers(parameters, manager);
        this.applyModifiers(parameters, manager);
        if (pocket instanceof LazyGenerationPocket) {
            if (!(generator instanceof LazyPocketGenerator)) {
                throw new RuntimeException("pocket was instance of LazyGenerationPocket but generator was not instance of LazyPocketGenerator");
            }
            LazyGenerationPocket lazyPocket = (LazyGenerationPocket)pocket;
            LazyPocketGenerator clonedGenerator = ((LazyPocketGenerator)generator).cloneWithLazyModifiers(originalOrigin);
            if (this.setupLoot != null) {
                clonedGenerator.setSetupLoot(this.setupLoot);
            }
            this.attachLazyModifiers(clonedGenerator);
            clonedGenerator.attachToPocket(lazyPocket);
            lazyPocket.init();
            alreadyLoadedChunks.forEach(lazyPocket::chunkLoaded);
            LazyPocketGenerator.currentlyGenerating = false;
            while (!LazyPocketGenerator.generationQueue.isEmpty()) {
                class_2791 chunk = LazyPocketGenerator.generationQueue.remove();
                LazyCompatibleModifier.runQueuedModifications(chunk);
                MinecraftServer server = DimensionalDoorsInitializer.getServer();
                DimensionalDoorsInitializer.getServer().method_18858((Runnable)new class_3738(server.method_3780(), () -> lazyPocket.chunkLoaded(chunk)));
            }
            LazyCompatibleModifier.runLeftoverModifications((class_1937)DimensionalDoorsInitializer.getWorld(lazyPocket.getWorld()));
        } else {
            LazyPocketGenerator.currentlyGenerating = false;
            LazyPocketGenerator.generationQueue.clear();
        }
        generator.setup(pocket, manager, parameters, this.setupLoot != null ? this.setupLoot.booleanValue() : generator.isSetupLoot());
        return pocket;
    }

    @Override
    public PocketGeneratorReference peekNextPocketGeneratorReference(PocketGenerationContext parameters) {
        return this;
    }

    @Override
    public PocketGeneratorReference getNextPocketGeneratorReference(PocketGenerationContext parameters) {
        return this;
    }

    public abstract PocketGenerator peekReferencedPocketGenerator(PocketGenerationContext var1);

    public abstract PocketGenerator getReferencedPocketGenerator(PocketGenerationContext var1);

    public abstract String toString();

    public void attachLazyModifiers(LazyPocketGenerator generator) {
        generator.attachLazyModifiers(this.modifierList.stream().filter(LazyModifier.class::isInstance).map(LazyModifier.class::cast).collect(Collectors.toList()));
    }
}

