/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.dimdev.dimdoors.api.util.NbtEquations;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftData;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class RiftDataModifier
implements Modifier {
    public static final String KEY = "rift_data";
    private class_2487 doorData;
    private String doorDataReference;
    private List<Integer> ids;

    @Override
    public Modifier fromNbt(class_2487 nbt) {
        if (nbt.method_10540(KEY) == 8) {
            this.doorDataReference = nbt.method_10558(KEY);
            this.doorData = PocketLoader.getInstance().getDataNbtCompound(this.doorDataReference);
        } else if (nbt.method_10540(KEY) == 10) {
            this.doorData = nbt.method_10562(KEY);
        }
        this.ids = RiftDataModifier.stream(nbt.method_10547("ids")).boxed().collect(Collectors.toList());
        return this;
    }

    public static IntStream stream(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return IntStream.generate(buffer::get).limit(buffer.remaining());
    }

    private static byte[] toByteArray(int[] ints) {
        byte[] bytes = new byte[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            bytes[i] = (byte)ints[i];
        }
        return bytes;
    }

    @Override
    public class_2487 toNbt(class_2487 nbt) {
        Modifier.super.toNbt(nbt);
        if (this.doorDataReference != null) {
            nbt.method_10582(KEY, this.doorDataReference);
        } else if (this.doorData != null) {
            nbt.method_10566(KEY, (class_2520)this.doorData);
        }
        nbt.method_10570("ids", RiftDataModifier.toByteArray(this.ids.stream().mapToInt(Integer::intValue).toArray()));
        return nbt;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return Modifier.ModifierType.RIFT_DATA_MODIFIER_TYPE;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("doorData", (Object)this.doorData).add("doorDataReference", (Object)this.doorDataReference).add("ids", this.ids).toString();
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        Consumer<RiftBlockEntity> riftBlockEntityConsumer;
        Map<String, Double> variableMap = manager.getPocket().toVariableMap(new HashMap<String, Double>());
        if (this.doorData == null) {
            riftBlockEntityConsumer = rift -> rift.setDestination(VirtualTarget.NoneTarget.INSTANCE);
        } else {
            class_2487 solvedDoorData = NbtEquations.solveNbtCompoundEquations(this.doorData, variableMap);
            riftBlockEntityConsumer = rift -> rift.setData(RiftData.fromNbt(solvedDoorData));
        }
        manager.foreachConsume((id, rift) -> {
            if (this.ids.contains(id)) {
                riftBlockEntityConsumer.accept((RiftBlockEntity)rift);
                return true;
            }
            return false;
        });
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
    }
}

