/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.modifier;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.rift.targets.LocalReference;
import org.dimdev.dimdoors.rift.targets.RiftReference;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class RelativeReferenceModifier
implements Modifier {
    public static final String KEY = "relative";
    private int point_a;
    private int point_b;

    @Override
    public Modifier fromNbt(class_2487 nbt) {
        this.point_a = nbt.method_10550("point_a");
        this.point_b = nbt.method_10550("point_b");
        return this;
    }

    @Override
    public class_2487 toNbt(class_2487 nbt) {
        Modifier.super.toNbt(nbt);
        nbt.method_10569("point_a", this.point_a);
        nbt.method_10569("point_b", this.point_b);
        return nbt;
    }

    @Override
    public Modifier.ModifierType<? extends Modifier> getType() {
        return Modifier.ModifierType.RELATIVE_REFERENCE_MODIFIER_TYPE;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public void apply(PocketGenerationContext parameters, RiftManager manager) {
        Optional<Location> riftA = manager.get(this.point_a).map(rift -> new Location((class_3218)rift.method_10997(), rift.method_11016()));
        Optional<Location> riftB = manager.get(this.point_b).map(rift -> new Location((class_3218)rift.method_10997(), rift.method_11016()));
        if (riftA.isPresent() && riftB.isPresent()) {
            RiftReference link1 = LocalReference.tryMakeRelative(riftA.get(), riftB.get());
            RiftReference link2 = LocalReference.tryMakeRelative(riftB.get(), riftA.get());
            manager.consume(this.point_a, rift -> this.addLink((RiftBlockEntity)rift, link1));
            manager.consume(this.point_b, rift -> this.addLink((RiftBlockEntity)rift, link2));
        }
    }

    @Override
    public void apply(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("point_a", this.point_a).add("point_b", this.point_b).toString();
    }

    private boolean addLink(RiftBlockEntity rift, RiftReference link) {
        rift.setDestination(link);
        return true;
    }
}

