/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.generator.LazyPocketGenerator;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class VoidGenerator
extends LazyPocketGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "void";
    private String width;
    private Equation heightEquation;
    private String height;
    private Equation widthEquation;
    private String length;
    private Equation lengthEquation;

    @Override
    public Pocket prepareAndPlacePocket(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        Object pocket = DimensionalRegistry.getPocketDirectory((class_5321<class_1937>)parameters.world().method_27983()).newPocket(builder);
        Map<String, Double> variableMap = parameters.toVariableMap(new HashMap<String, Double>());
        ((Pocket)pocket).setSize((int)this.widthEquation.apply(variableMap), (int)this.heightEquation.apply(variableMap), (int)this.lengthEquation.apply(variableMap));
        return pocket;
    }

    @Override
    public PocketGenerator.PocketGeneratorType<? extends PocketGenerator> getType() {
        return PocketGenerator.PocketGeneratorType.VOID;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public class_2382 getSize(PocketGenerationContext parameters) {
        Map<String, Double> variableMap = parameters.toVariableMap(new HashMap<String, Double>());
        return new class_2382((int)this.widthEquation.apply(variableMap), (int)this.heightEquation.apply(variableMap), (int)this.lengthEquation.apply(variableMap));
    }

    @Override
    public PocketGenerator fromNbt(class_2487 nbt) {
        super.fromNbt(nbt);
        try {
            this.width = nbt.method_10558("width");
            this.widthEquation = Equation.parse(this.width);
            this.height = nbt.method_10558("height");
            this.heightEquation = Equation.parse(this.height);
            this.length = nbt.method_10558("length");
            this.lengthEquation = Equation.parse(this.length);
        }
        catch (Equation.EquationParseException e) {
            LOGGER.error((Object)e);
        }
        return this;
    }

    @Override
    public class_2487 toNbt(class_2487 nbt) {
        super.toNbt(nbt);
        nbt.method_10582("width", this.width);
        nbt.method_10582("height", this.height);
        nbt.method_10582("length", this.length);
        return nbt;
    }

    @Override
    public LazyPocketGenerator cloneWithEmptyModifiers(class_2338 originalOrigin) {
        VoidGenerator generator = (VoidGenerator)super.cloneWithEmptyModifiers(originalOrigin);
        generator.width = this.width;
        generator.height = this.height;
        generator.length = this.length;
        return generator;
    }

    @Override
    public LazyPocketGenerator getNewInstance() {
        return new VoidGenerator();
    }
}

