/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.BlockPlacementType;
import org.dimdev.dimdoors.api.util.Path;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.command.PocketCommand;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.PocketTemplate;
import org.dimdev.dimdoors.pockets.generator.LazyPocketGenerator;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.pockets.modifier.AbsoluteRiftBlockEntityModifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class SchematicGenerator
extends LazyPocketGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY = "schematic";
    private String id;
    private class_2960 templateID;
    private BlockPlacementType placementType = BlockPlacementType.SECTION_NO_UPDATE;
    private final List<RiftBlockEntity> rifts = new ArrayList<RiftBlockEntity>();
    private class_2338 origin;
    private AbsoluteRiftBlockEntityModifier queuedRiftBlockEntities;

    public SchematicGenerator() {
    }

    public SchematicGenerator(String id) {
        this.id = id;
        this.templateID = new class_2960("dimdoors", id);
    }

    public String getId() {
        return this.id;
    }

    public class_2960 getTemplateID() {
        return this.templateID;
    }

    @Override
    public void generateChunk(LazyGenerationPocket pocket, class_2791 chunk) {
        PocketTemplate template = PocketLoader.getInstance().getTemplates().get(Path.stringPath(this.templateID));
        if (template == null) {
            throw new RuntimeException("Pocket template of id " + this.templateID + " not found!");
        }
        template.place(pocket, chunk, this.origin, this.placementType);
        this.setupChunk(pocket, chunk, this.isSetupLoot());
        super.generateChunk(pocket, chunk);
    }

    @Override
    public PocketGenerator fromNbt(class_2487 nbt) {
        super.fromNbt(nbt);
        this.id = nbt.method_10558("id");
        this.templateID = new class_2960("dimdoors", this.id);
        if (nbt.method_10573("origin", 11)) {
            int[] originInts = nbt.method_10561("origin");
            this.origin = new class_2338(originInts[0], originInts[1], originInts[2]);
        }
        if (nbt.method_10573("placement_type", 8)) {
            this.placementType = BlockPlacementType.getFromId(nbt.method_10558("placement_type"));
        }
        return this;
    }

    @Override
    public class_2487 toNbt(class_2487 nbt) {
        super.toNbt(nbt);
        nbt.method_10582("id", this.id);
        if (this.placementType != BlockPlacementType.SECTION_NO_UPDATE) {
            nbt.method_10582("placement_type", this.placementType.getId());
        }
        if (this.origin != null) {
            nbt.method_10539("origin", new int[]{this.origin.method_10263(), this.origin.method_10264(), this.origin.method_10260()});
        }
        return nbt;
    }

    @Override
    public RiftManager getRiftManager(Pocket pocket) {
        RiftManager manager = super.getRiftManager(pocket);
        this.rifts.forEach(manager::add);
        return manager;
    }

    @Override
    public LazyPocketGenerator cloneWithLazyModifiers(class_2338 originalOrigin) {
        LazyPocketGenerator generator = super.cloneWithLazyModifiers(originalOrigin);
        generator.lazyModifierList.add(0, this.queuedRiftBlockEntities);
        return generator;
    }

    @Override
    public LazyPocketGenerator cloneWithEmptyModifiers(class_2338 originalOrigin) {
        SchematicGenerator generator = (SchematicGenerator)super.cloneWithEmptyModifiers(originalOrigin);
        generator.id = this.id;
        generator.templateID = this.templateID;
        generator.origin = originalOrigin;
        return generator;
    }

    @Override
    public LazyPocketGenerator getNewInstance() {
        return new SchematicGenerator();
    }

    @Override
    public Pocket prepareAndPlacePocket(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        class_3218 world = parameters.world();
        Map<String, Double> variableMap = parameters.toVariableMap(new HashMap<String, Double>());
        PocketTemplate template = PocketLoader.getInstance().getTemplates().get(Path.stringPath(this.templateID));
        if (template == null) {
            throw new RuntimeException("Pocket template of id " + this.templateID + " not found!");
        }
        Object pocket = DimensionalRegistry.getPocketDirectory((class_5321<class_1937>)world.method_27983()).newPocket(builder);
        class_2338 origin = ((Pocket)pocket).getOrigin();
        LOGGER.info("Generating pocket from template " + this.templateID + " at location " + origin);
        PocketCommand.logSetting.values().forEach(commandSource -> commandSource.method_9226((class_2561)new class_2588("commands.pocket.log.creation.generating", new Object[]{this.templateID, origin.method_10263(), origin.method_10264(), origin.method_10260()}), false));
        if (pocket instanceof LazyGenerationPocket) {
            Map<class_2338, RiftBlockEntity> absoluteRifts = template.getAbsoluteRifts((Pocket)pocket);
            this.rifts.addAll(absoluteRifts.values());
            this.queuedRiftBlockEntities = new AbsoluteRiftBlockEntityModifier(absoluteRifts);
        } else {
            template.place((Pocket)pocket, this.placementType);
        }
        return pocket;
    }

    @Override
    public PocketGenerator.PocketGeneratorType<? extends PocketGenerator> getType() {
        return PocketGenerator.PocketGeneratorType.SCHEMATIC;
    }

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public class_2382 getSize(PocketGenerationContext parameters) {
        PocketTemplate template = PocketLoader.getInstance().getTemplates().get(Path.stringPath(this.templateID));
        if (template == null) {
            throw new RuntimeException("Pocket template of id " + this.templateID + " not found!");
        }
        Schematic schem = template.getSchematic();
        return new class_2382((int)schem.getWidth(), (int)schem.getHeight(), (int)schem.getLength());
    }
}

