/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.minecraft.class_1263;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2385;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.Weighted;
import org.dimdev.dimdoors.api.util.math.Equation;
import org.dimdev.dimdoors.pockets.PocketGenerationContext;
import org.dimdev.dimdoors.pockets.TemplateUtils;
import org.dimdev.dimdoors.pockets.generator.ChunkGenerator;
import org.dimdev.dimdoors.pockets.generator.SchematicGenerator;
import org.dimdev.dimdoors.pockets.generator.VoidGenerator;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public abstract class PocketGenerator
implements Weighted<PocketGenerationContext> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final class_2378<PocketGeneratorType<? extends PocketGenerator>> REGISTRY = FabricRegistryBuilder.from((class_2385)new class_2370(class_5321.method_29180((class_2960)new class_2960("dimdoors", "pocket_generator_type")), Lifecycle.stable(), null)).buildAndRegister();
    private static final String defaultWeightEquation = "5";
    private static final int fallbackWeight = 5;
    protected final List<Modifier> modifierList = new ArrayList<Modifier>();
    private class_2487 builderNbt;
    protected String weight = "5";
    protected Equation weightEquation;
    protected Boolean setupLoot;
    private final List<String> tags = new ArrayList<String>();

    public PocketGenerator() {
    }

    public PocketGenerator(String weight) {
        this.weight = weight;
        this.parseWeight();
    }

    public static PocketGenerator deserialize(class_2487 nbt) {
        class_2960 id = class_2960.method_12829((String)nbt.method_10558("type"));
        PocketGeneratorType type = (PocketGeneratorType)REGISTRY.method_10223(id);
        if (type == null) {
            LOGGER.error("Could not deserialize PocketGenerator: " + nbt.toString());
            return null;
        }
        return type.fromNbt(nbt);
    }

    public static class_2487 serialize(PocketGenerator pocketGenerator) {
        return pocketGenerator.toNbt(new class_2487());
    }

    private void parseWeight() {
        try {
            this.weightEquation = Equation.parse(this.weight);
        }
        catch (Equation.EquationParseException e) {
            LOGGER.error("Could not parse weight equation \"" + this.weight + "\", defaulting to default weight equation \"5\"", (Throwable)e);
            try {
                this.weightEquation = Equation.parse(defaultWeightEquation);
            }
            catch (Equation.EquationParseException equationParseException) {
                LOGGER.error("Could not parse default weight equation \"5\", defaulting to fallback weight \"5\"", (Throwable)equationParseException);
                this.weightEquation = stringDoubleMap -> 5.0;
            }
        }
    }

    public PocketGenerator fromNbt(class_2487 nbt) {
        int i;
        if (nbt.method_10573("builder", 10)) {
            this.builderNbt = nbt.method_10562("builder");
        }
        this.weight = nbt.method_10545("weight") ? nbt.method_10558("weight") : defaultWeightEquation;
        this.parseWeight();
        if (nbt.method_10545("setup_loot")) {
            this.setupLoot = nbt.method_10577("setup_loot");
        }
        if (nbt.method_10545("modifiers")) {
            class_2499 modifiersNbt = nbt.method_10554("modifiers", 10);
            for (i = 0; i < modifiersNbt.size(); ++i) {
                this.modifierList.add(Modifier.deserialize(modifiersNbt.method_10602(i)));
            }
        }
        if (nbt.method_10545("tags")) {
            class_2499 nbtList = nbt.method_10554("tags", 8);
            for (i = 0; i < nbtList.size(); ++i) {
                this.tags.add(nbtList.method_10608(i));
            }
        }
        return this;
    }

    public class_2487 toNbt(class_2487 nbt) {
        this.getType().toNbt(nbt);
        if (this.builderNbt != null) {
            nbt.method_10566("builder", (class_2520)this.builderNbt);
        }
        if (!this.weight.equals(defaultWeightEquation)) {
            nbt.method_10582("weight", this.weight);
        }
        if (this.setupLoot != null) {
            nbt.method_10556("setup_loot", this.setupLoot.booleanValue());
        }
        class_2499 modifiersNbt = new class_2499();
        for (Modifier modifier : this.modifierList) {
            modifiersNbt.add((Object)modifier.toNbt(new class_2487()));
        }
        if (modifiersNbt.size() > 0) {
            nbt.method_10566("modifiers", (class_2520)modifiersNbt);
        }
        if (this.tags.size() > 0) {
            class_2499 nbtList = new class_2499();
            for (String nbtStr : this.tags) {
                nbtList.add((Object)class_2519.method_23256((String)nbtStr));
            }
            nbt.method_10566("tags", (class_2520)nbtList);
        }
        return nbt;
    }

    public abstract Pocket prepareAndPlacePocket(PocketGenerationContext var1, Pocket.PocketBuilder<?, ?> var2);

    public abstract PocketGeneratorType<? extends PocketGenerator> getType();

    public abstract String getKey();

    @Override
    public double getWeight(PocketGenerationContext parameters) {
        return this.weightEquation.apply(parameters.toVariableMap(new HashMap<String, Double>()));
    }

    public boolean isSetupLoot() {
        return this.setupLoot != null && this.setupLoot != false;
    }

    public void applyModifiers(PocketGenerationContext parameters, RiftManager manager) {
        for (Modifier modifier : this.modifierList) {
            modifier.apply(parameters, manager);
        }
    }

    public void applyModifiers(PocketGenerationContext parameters, Pocket.PocketBuilder<?, ?> builder) {
        for (Modifier modifier : this.modifierList) {
            modifier.apply(parameters, builder);
        }
    }

    public void setup(Pocket pocket, RiftManager manager, PocketGenerationContext parameters, boolean setupLootTables) {
        class_3218 world = parameters.world();
        if (!(pocket instanceof LazyGenerationPocket) && setupLootTables) {
            pocket.getBlockEntities().forEach((blockPos, blockEntity) -> {
                class_1263 inventory;
                if (blockEntity instanceof class_1263 && (inventory = (class_1263)blockEntity).method_5442() && (blockEntity instanceof class_2595 || blockEntity instanceof class_2601)) {
                    TemplateUtils.setupLootTable(world, blockEntity, inventory, LOGGER);
                    if (inventory.method_5442()) {
                        LOGGER.error(", however Inventory is: empty!");
                    }
                }
            });
        }
        manager.getRifts().forEach(rift -> rift.getDestination().setLocation(new Location(world, rift.method_11016())));
        TemplateUtils.registerRifts(manager.getRifts(), parameters.linkTo(), parameters.linkProperties(), pocket);
    }

    public RiftManager getRiftManager(Pocket pocket) {
        return new RiftManager(pocket);
    }

    public boolean checkTags(List<String> required, List<String> blackList, boolean exact) {
        if (exact && required.size() != this.tags.size()) {
            return false;
        }
        if (required != null) {
            for (String req : required) {
                if (this.tags.contains(req)) continue;
                return false;
            }
        }
        if (blackList != null) {
            for (String black : blackList) {
                if (!this.tags.contains(black)) continue;
                return false;
            }
        }
        return true;
    }

    public Pocket.PocketBuilder<?, ?> pocketBuilder(PocketGenerationContext parameters) {
        if (this.builderNbt == null) {
            return Pocket.builder().expand(this.getSize(parameters));
        }
        AbstractPocket.AbstractPocketBuilder<?, ?> abstractBuilder = AbstractPocket.deserializeBuilder(this.builderNbt);
        if (!(abstractBuilder instanceof Pocket.PocketBuilder)) {
            return Pocket.builder().expand(this.getSize(parameters));
        }
        Pocket.PocketBuilder builder = (Pocket.PocketBuilder)abstractBuilder;
        return builder.expand(this.getSize(parameters));
    }

    public abstract class_2382 getSize(PocketGenerationContext var1);

    public static interface PocketGeneratorType<T extends PocketGenerator> {
        public static final PocketGeneratorType<SchematicGenerator> SCHEMATIC = PocketGeneratorType.register(new class_2960("dimdoors", "schematic"), SchematicGenerator::new);
        public static final PocketGeneratorType<ChunkGenerator> CHUNK = PocketGeneratorType.register(new class_2960("dimdoors", "chunk"), ChunkGenerator::new);
        public static final PocketGeneratorType<VoidGenerator> VOID = PocketGeneratorType.register(new class_2960("dimdoors", "void"), VoidGenerator::new);

        public PocketGenerator fromNbt(class_2487 var1);

        public class_2487 toNbt(class_2487 var1);

        public static void register() {
            DimensionalDoorsInitializer.apiSubscribers.forEach(d -> d.registerPocketGeneratorTypes(REGISTRY));
        }

        public static <U extends PocketGenerator> PocketGeneratorType<U> register(final class_2960 id, final Supplier<U> constructor) {
            return (PocketGeneratorType)class_2378.method_10230(REGISTRY, (class_2960)id, (Object)new PocketGeneratorType<U>(){

                @Override
                public PocketGenerator fromNbt(class_2487 nbt) {
                    return ((PocketGenerator)constructor.get()).fromNbt(nbt);
                }

                @Override
                public class_2487 toNbt(class_2487 nbt) {
                    nbt.method_10582("type", id.toString());
                    return nbt;
                }
            });
        }
    }
}

