/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2791;
import net.minecraft.class_3738;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.pockets.TemplateUtils;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.pockets.modifier.LazyModifier;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.modifier.RiftManager;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public abstract class LazyPocketGenerator
extends PocketGenerator {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean currentlyGenerating = false;
    public static Queue<class_2791> generationQueue = new LinkedList<class_2791>();
    protected List<LazyModifier> lazyModifierList = new ArrayList<LazyModifier>();

    public void generateChunk(LazyGenerationPocket pocket, class_2791 chunk) {
        this.lazyModifierList.forEach(modifier -> modifier.applyToChunk(pocket, chunk));
    }

    public void attachToPocket(LazyGenerationPocket pocket) {
        if (this.modifierList.size() > 0) {
            throw new UnsupportedOperationException("Cannot attach LazyPocketGenerator that has not been cloned yet to pocket");
        }
        pocket.attachGenerator(this);
    }

    @Override
    public PocketGenerator fromNbt(class_2487 nbt) {
        super.fromNbt(nbt);
        if (nbt.method_10545("lazy_modifiers")) {
            class_2499 modifiersNbt = nbt.method_10554("lazy_modifiers", 10);
            for (int i = 0; i < modifiersNbt.size(); ++i) {
                this.lazyModifierList.add((LazyModifier)Modifier.deserialize(modifiersNbt.method_10602(i)));
            }
        }
        return this;
    }

    @Override
    public class_2487 toNbt(class_2487 nbt) {
        super.toNbt(nbt);
        if (this.lazyModifierList.size() > 0) {
            List lazyModNbts = this.lazyModifierList.stream().map(lazyModifier -> lazyModifier.toNbt(new class_2487())).collect(Collectors.toList());
            class_2499 lazyModifiersNbt = new class_2499();
            lazyModifiersNbt.addAll(lazyModNbts);
            nbt.method_10566("lazy_modifiers", (class_2520)lazyModifiersNbt);
        }
        return nbt;
    }

    @Override
    public RiftManager getRiftManager(Pocket pocket) {
        if (pocket instanceof LazyGenerationPocket) {
            return new RiftManager(pocket, true);
        }
        return new RiftManager(pocket, false);
    }

    public void attachLazyModifiers(Collection<LazyModifier> lazyModifiers) {
        this.lazyModifierList.addAll(lazyModifiers);
    }

    public LazyPocketGenerator cloneWithLazyModifiers(class_2338 originalOrigin) {
        LazyPocketGenerator clone = this.cloneWithEmptyModifiers(originalOrigin);
        clone.attachLazyModifiers(this.modifierList.stream().filter(LazyModifier.class::isInstance).map(LazyModifier.class::cast).collect(Collectors.toList()));
        return clone;
    }

    public LazyPocketGenerator cloneWithEmptyModifiers(class_2338 originalOrigin) {
        LazyPocketGenerator generator = this.getNewInstance();
        generator.setupLoot = this.setupLoot;
        return generator;
    }

    public void setSetupLoot(Boolean setupLoot) {
        this.setupLoot = setupLoot;
    }

    public abstract LazyPocketGenerator getNewInstance();

    public void setupChunk(Pocket pocket, class_2791 chunk, boolean setupLootTables) {
        MinecraftServer server = DimensionalDoorsInitializer.getServer();
        chunk.method_12021().stream().map(arg_0 -> ((class_2791)chunk).method_8321(arg_0)).forEach(blockEntity -> {
            if (setupLootTables && blockEntity instanceof class_1263) {
                class_1263 inventory = (class_1263)blockEntity;
                server.method_18858((Runnable)new class_3738(server.method_3780(), () -> {
                    if (inventory.method_5442() && (blockEntity instanceof class_2595 || blockEntity instanceof class_2601)) {
                        TemplateUtils.setupLootTable(DimensionalDoorsInitializer.getWorld(pocket.getWorld()), blockEntity, inventory, LOGGER);
                    }
                }));
            }
        });
    }
}

